/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Preconditions;
import com.samskivert.depot.Log;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.depot.impl.Modifier;
import com.samskivert.jdbc.ColumnDefinition;
import com.samskivert.jdbc.DatabaseLiaison;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaMigration
extends Modifier {
    protected int _targetVersion;
    protected String _tableName;

    public boolean runBeforeDefault() {
        return true;
    }

    public boolean shouldRunMigration(int currentVersion, int targetVersion) {
        return currentVersion < this._targetVersion;
    }

    public void init(String tableName, Map<String, FieldMarshaller<?>> marshallers) {
        this._tableName = tableName;
    }

    protected SchemaMigration(int targetVersion) {
        this._targetVersion = targetVersion;
    }

    protected FieldMarshaller<?> requireMarshaller(Map<String, FieldMarshaller<?>> marshallers, String fieldName) {
        FieldMarshaller<?> marsh = marshallers.get(fieldName);
        Preconditions.checkArgument((marsh != null ? 1 : 0) != 0, (Object)("'" + this._tableName + "' does not contain field '" + fieldName + "'"));
        return marsh;
    }

    public static class DropIndex
    extends SchemaMigration {
        protected String _ixName;

        public DropIndex(int targetVersion, String ixName) {
            super(targetVersion);
            this._ixName = ixName;
        }

        protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
            String fullIxName = this._tableName + "_" + this._ixName;
            if (!liaison.tableContainsIndex(conn, this._tableName, fullIxName)) {
                Log.log.warning((Object)("No index '" + fullIxName + "' found on " + this._tableName), new Object[0]);
                return 0;
            }
            Log.log.info((Object)("Dropping index '" + fullIxName + "' from " + this._tableName), new Object[0]);
            liaison.dropIndex(conn, this._tableName, fullIxName);
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Add
    extends SchemaMigration {
        protected String _fieldName;
        protected String _columnName;
        protected String _defaultValue;
        protected ColumnDefinition _newColumnDef;

        public Add(int targetVersion, ColumnExp<?> column, String defaultValue) {
            super(targetVersion);
            this._fieldName = column.name;
            this._defaultValue = defaultValue;
        }

        @Override
        public boolean runBeforeDefault() {
            return true;
        }

        @Override
        public void init(String tableName, Map<String, FieldMarshaller<?>> marshallers) {
            super.init(tableName, marshallers);
            FieldMarshaller<?> marsh = this.requireMarshaller(marshallers, this._fieldName);
            this._columnName = marsh.getColumnName();
            this._newColumnDef = marsh.getColumnDefinition();
        }

        @Override
        protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
            ColumnDefinition defColumnDef = new ColumnDefinition(this._newColumnDef.type, this._newColumnDef.nullable, this._newColumnDef.unique, this._defaultValue);
            if (liaison.addColumn(conn, this._tableName, this._fieldName, defColumnDef, true)) {
                liaison.changeColumn(conn, this._tableName, this._fieldName, this._newColumnDef.type, null, null, this._newColumnDef.defaultValue);
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Retype
    extends SchemaMigration {
        protected String _fieldName;
        protected String _columnName;
        protected ColumnDefinition _newColumnDef;

        public Retype(int targetVersion, ColumnExp<?> column) {
            super(targetVersion);
            this._fieldName = column.name;
        }

        @Override
        public boolean runBeforeDefault() {
            return false;
        }

        @Override
        public void init(String tableName, Map<String, FieldMarshaller<?>> marshallers) {
            super.init(tableName, marshallers);
            FieldMarshaller<?> marsh = this.requireMarshaller(marshallers, this._fieldName);
            this._columnName = marsh.getColumnName();
            this._newColumnDef = marsh.getColumnDefinition();
        }

        @Override
        protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
            Log.log.info((Object)("Updating type of '" + this._columnName + "' in " + this._tableName), new Object[0]);
            return liaison.changeColumn(conn, this._tableName, this._columnName, this._newColumnDef.type, Boolean.valueOf(this._newColumnDef.nullable), Boolean.valueOf(this._newColumnDef.unique), this._newColumnDef.defaultValue) ? 1 : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rename
    extends SchemaMigration {
        protected String _oldColumnName;
        protected String _fieldName;
        protected String _newColumnName;
        protected ColumnDefinition _newColumnDef;

        public Rename(int targetVersion, String oldColumnName, ColumnExp<?> newColumn) {
            super(targetVersion);
            this._oldColumnName = oldColumnName;
            this._fieldName = newColumn.name;
        }

        @Override
        public boolean runBeforeDefault() {
            return true;
        }

        @Override
        public void init(String tableName, Map<String, FieldMarshaller<?>> marshallers) {
            super.init(tableName, marshallers);
            FieldMarshaller<?> fm = this.requireMarshaller(marshallers, this._fieldName);
            this._newColumnName = fm.getColumnName();
            this._newColumnDef = fm.getColumnDefinition();
        }

        @Override
        protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
            if (!liaison.tableContainsColumn(conn, this._tableName, this._oldColumnName)) {
                Preconditions.checkArgument((boolean)liaison.tableContainsColumn(conn, this._tableName, this._newColumnName), (Object)(this._tableName + " does not contain '" + this._oldColumnName + "'"));
                Log.log.warning((Object)(this._tableName + "." + this._oldColumnName + " already renamed to " + this._newColumnName + "."), new Object[0]);
                return 0;
            }
            Preconditions.checkArgument((!liaison.tableContainsColumn(conn, this._tableName, this._newColumnName) ? 1 : 0) != 0, (Object)(this._tableName + " already contains '" + this._newColumnName + "'"));
            Log.log.info((Object)("Renaming '" + this._oldColumnName + "' to '" + this._newColumnName + "' in: " + this._tableName), new Object[0]);
            return liaison.renameColumn(conn, this._tableName, this._oldColumnName, this._newColumnName, this._newColumnDef) ? 1 : 0;
        }
    }

    public static class Drop
    extends SchemaMigration {
        protected String _columnName;

        public Drop(int targetVersion, String columnName) {
            super(targetVersion);
            this._columnName = columnName;
        }

        protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
            if (!liaison.tableContainsColumn(conn, this._tableName, this._columnName)) {
                Log.log.warning((Object)(this._tableName + "." + this._columnName + " already dropped."), new Object[0]);
                return 0;
            }
            Log.log.info((Object)("Dropping '" + this._columnName + "' from " + this._tableName), new Object[0]);
            return liaison.dropColumn(conn, this._tableName, this._columnName) ? 1 : 0;
        }
    }
}

