/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.samskivert.depot.CacheInvalidator;
import com.samskivert.depot.CountRecord;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.Exps;
import com.samskivert.depot.Key;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.FieldDefinition;
import com.samskivert.depot.clause.ForUpdate;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.GroupBy;
import com.samskivert.depot.clause.Join;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.FindAllQuery;
import com.samskivert.depot.impl.Projector;
import com.samskivert.depot.util.Builder2;
import com.samskivert.depot.util.Builder3;
import com.samskivert.depot.util.Builder4;
import com.samskivert.depot.util.Builder5;
import com.samskivert.depot.util.Tuple2;
import com.samskivert.depot.util.Tuple3;
import com.samskivert.depot.util.Tuple4;
import com.samskivert.depot.util.Tuple5;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query<T extends PersistentRecord>
implements Cloneable {
    protected final PersistenceContext _ctx;
    protected final DepotRepository _repo;
    protected final Class<T> _pclass;
    protected DepotRepository.CacheStrategy _cache = DepotRepository.CacheStrategy.BEST;
    protected WhereClause _where;
    protected OrderBy _orderBy;
    protected GroupBy _groupBy;
    protected Limit _limit;
    protected FromOverride _fromOverride;
    protected ForUpdate _forUpdate;
    protected Cons<Join> _joins;
    protected Cons<FieldDefinition> _fieldDefs;

    public Query<T> noCache() {
        return this.cache(DepotRepository.CacheStrategy.BEST);
    }

    public Query<T> cacheBest() {
        return this.cache(DepotRepository.CacheStrategy.BEST);
    }

    public Query<T> cacheRecords() {
        return this.cache(DepotRepository.CacheStrategy.RECORDS);
    }

    public Query<T> cacheShortKeys() {
        return this.cache(DepotRepository.CacheStrategy.SHORT_KEYS);
    }

    public Query<T> cacheLongKeys() {
        return this.cache(DepotRepository.CacheStrategy.LONG_KEYS);
    }

    public Query<T> cacheContents() {
        return this.cache(DepotRepository.CacheStrategy.CONTENTS);
    }

    public Query<T> cache(DepotRepository.CacheStrategy cache) {
        Object query = this.clone();
        ((Query)query)._cache = cache;
        return query;
    }

    public Query<T> whereTrue() {
        return this.where(Exps.literal("true"));
    }

    public Query<T> where(SQLExpression<?> ... exprs) {
        return this.where(Arrays.asList(exprs));
    }

    public Query<T> where(Iterable<? extends SQLExpression<?>> exprs) {
        Iterator<SQLExpression<?>> iter = exprs.iterator();
        Preconditions.checkArgument((boolean)iter.hasNext(), (Object)"Must supply at least one expression.");
        SQLExpression<?> first = iter.next();
        return this.where(iter.hasNext() ? new Where(Ops.and(exprs)) : new Where(first));
    }

    public <V extends Comparable<? super V>> Query<T> where(ColumnExp<V> column, V value) {
        return this.where(new Where(column, value));
    }

    public <V1 extends Comparable<? super V1>, V2 extends Comparable<? super V2>> Query<T> where(ColumnExp<V1> index1, V1 value1, ColumnExp<V2> index2, V2 value2) {
        return this.where(new Where(index1, value1, index2, value2));
    }

    public Query<T> where(WhereClause where) {
        Preconditions.checkState((this._where == null ? 1 : 0) != 0, (Object)"Where clause is already configured.");
        Object query = this.clone();
        ((Query)query)._where = where;
        return query;
    }

    public Query<T> join(ColumnExp<?> left, ColumnExp<?> right) {
        return this.join(new Join(left, right));
    }

    public Query<T> join(Class<? extends PersistentRecord> joinClass, SQLExpression<?> joinCondition) {
        return this.join(new Join(joinClass, joinCondition));
    }

    public Query<T> join(ColumnExp<?> left, ColumnExp<?> right, Join.Type type) {
        return this.join(new Join(left, right).setType(type));
    }

    public Query<T> join(Join join) {
        Object query = this.clone();
        ((Query)query)._joins = Query.cons(join, ((Query)query)._joins);
        return query;
    }

    public Query<T> groupBy(SQLExpression<?> ... exprs) {
        Preconditions.checkState((this._groupBy == null ? 1 : 0) != 0, (Object)"GroupBy clause is already configured.");
        Object query = this.clone();
        ((Query)query)._groupBy = new GroupBy(exprs);
        return query;
    }

    public Query<T> randomOrder() {
        return this.orderBy(OrderBy.random());
    }

    public Query<T> ascending(SQLExpression<?> value) {
        return this.orderBy(OrderBy.ascending(value));
    }

    public Query<T> descending(SQLExpression<?> value) {
        return this.orderBy(OrderBy.descending(value));
    }

    public Query<T> orderBy(OrderBy orderBy) {
        Preconditions.checkState((this._orderBy == null ? 1 : 0) != 0, (Object)"OrderBy clause is already configured.");
        Object query = this.clone();
        ((Query)query)._orderBy = orderBy;
        return query;
    }

    public Query<T> limit(int count) {
        Preconditions.checkState((this._limit == null ? 1 : 0) != 0, (Object)"Limit clause is already configured.");
        Object query = this.clone();
        ((Query)query)._limit = new Limit(0, count);
        return query;
    }

    public Query<T> limit(int offset, int count) {
        Preconditions.checkState((this._limit == null ? 1 : 0) != 0, (Object)"Limit clause is already configured.");
        Object query = this.clone();
        ((Query)query)._limit = new Limit(offset, count);
        return query;
    }

    public Query<T> override(Class<? extends PersistentRecord> fromClass) {
        return this.override(new FromOverride(fromClass));
    }

    public Query<T> override(Class<? extends PersistentRecord> fromClass1, Class<? extends PersistentRecord> fromClass2) {
        return this.override(new FromOverride(fromClass1, fromClass2));
    }

    public Query<T> override(FromOverride fromOverride) {
        Preconditions.checkState((this._fromOverride == null ? 1 : 0) != 0, (Object)"FromOverride clause is already configured.");
        Object query = this.clone();
        ((Query)query)._fromOverride = fromOverride;
        return query;
    }

    public Query<T> fieldDef(String field, String value) {
        return this.fieldDef(new FieldDefinition(field, value));
    }

    public Query<T> fieldDef(String field, SQLExpression<?> override) {
        return this.fieldDef(new FieldDefinition(field, override));
    }

    public Query<T> fieldDef(ColumnExp<?> field, SQLExpression<?> override) {
        return this.fieldDef(new FieldDefinition(field, override));
    }

    public Query<T> fieldDef(FieldDefinition fieldDef) {
        Object query = this.clone();
        ((Query)query)._fieldDefs = Query.cons(fieldDef, ((Query)query)._fieldDefs);
        return query;
    }

    public Query<T> forUpdate() {
        Preconditions.checkState((this._forUpdate == null ? 1 : 0) != 0, (Object)"ForUpdate clause is already configured.");
        Object query = this.clone();
        ((Query)query)._forUpdate = new ForUpdate();
        return query;
    }

    public T load() {
        return this._repo.load(this._pclass, this._cache, this.getClauseArray());
    }

    public List<T> select() throws DatabaseException {
        return this._repo.findAll(this._pclass, this._cache, this.getClauses());
    }

    public List<Key<T>> selectKeys(boolean useMaster) throws DatabaseException {
        return this._repo.findAllKeys(this._pclass, useMaster, this.getClauses());
    }

    public int selectCount() {
        Preconditions.checkState((this._groupBy == null ? 1 : 0) != 0, (Object)"Do you mean to select(Funcs.countStar())?");
        this._fromOverride = new FromOverride(this._pclass);
        return this._repo.load(CountRecord.class, (DepotRepository.CacheStrategy)this._cache, (QueryClause[])this.getClauseArray()).count;
    }

    public <V> V load(SQLExpression<V> selexp) {
        return Query.getLoaded(this.select(selexp));
    }

    public <V1, V2> Tuple2<V1, V2> load(SQLExpression<V1> exp1, SQLExpression<V2> exp2) {
        return Query.getLoaded(this.select(exp1, exp2));
    }

    public <V1, V2, V3> Tuple3<V1, V2, V3> load(SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3) {
        return Query.getLoaded(this.select(exp1, exp2, exp3));
    }

    public <V1, V2, V3, V4> Tuple4<V1, V2, V3, V4> load(SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3, SQLExpression<V4> exp4) {
        return Query.getLoaded(this.select(exp1, exp2, exp3, exp4));
    }

    public <V1, V2, V3, V4, V5> Tuple5<V1, V2, V3, V4, V5> load(SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3, SQLExpression<V4> exp4, SQLExpression<V5> exp5) {
        return Query.getLoaded(this.select(exp1, exp2, exp3, exp4, exp5));
    }

    public <V> List<V> select(SQLExpression<V> selexp) {
        return (List)this._ctx.invoke(new FindAllQuery.Projection<T, V>(this._ctx, Projector.create(this._pclass, selexp), this.getClauses()));
    }

    public <V1, V2> List<Tuple2<V1, V2>> select(SQLExpression<V1> exp1, SQLExpression<V2> exp2) {
        Builder2 builder = Tuple2.builder();
        return this.select(builder, exp1, exp2);
    }

    public <V1, V2, V3> List<Tuple3<V1, V2, V3>> select(SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3) {
        Builder3 builder = Tuple3.builder();
        return this.select(builder, exp1, exp2, exp3);
    }

    public <V1, V2, V3, V4> List<Tuple4<V1, V2, V3, V4>> select(SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3, SQLExpression<V4> exp4) {
        Builder4 builder = Tuple4.builder();
        return this.select(builder, exp1, exp2, exp3, exp4);
    }

    public <V1, V2, V3, V4, V5> List<Tuple5<V1, V2, V3, V4, V5>> select(SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3, SQLExpression<V4> exp4, SQLExpression<V5> exp5) {
        Builder5 builder = Tuple5.builder();
        return this.select(builder, exp1, exp2, exp3, exp4, exp5);
    }

    public <V> List<V> selectInto(Class<V> resultClass, SQLExpression<?> ... selexps) {
        Projector<T, V> proj = Projector.create(this._pclass, resultClass, selexps);
        return (List)this._ctx.invoke(new FindAllQuery.Projection<T, V>(this._ctx, proj, this.getClauses()));
    }

    public <R, V1, V2> List<R> select(Builder2<R, ? super V1, ? super V2> builder, SQLExpression<V1> exp1, SQLExpression<V2> exp2) {
        Projector<T, R> proj = Projector.create(this._pclass, builder, exp1, exp2);
        return (List)this._ctx.invoke(new FindAllQuery.Projection<T, R>(this._ctx, proj, this.getClauses()));
    }

    public <R, V1, V2, V3> List<R> select(Builder3<R, ? super V1, ? super V2, ? super V3> builder, SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3) {
        Projector<T, R> proj = Projector.create(this._pclass, builder, exp1, exp2, exp3);
        return (List)this._ctx.invoke(new FindAllQuery.Projection<T, R>(this._ctx, proj, this.getClauses()));
    }

    public <R, V1, V2, V3, V4> List<R> select(Builder4<R, ? super V1, ? super V2, ? super V3, ? super V4> builder, SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3, SQLExpression<V4> exp4) {
        Projector<T, R> proj = Projector.create(this._pclass, builder, exp1, exp2, exp3, exp4);
        return (List)this._ctx.invoke(new FindAllQuery.Projection<T, R>(this._ctx, proj, this.getClauses()));
    }

    public <R, V1, V2, V3, V4, V5> List<R> select(Builder5<R, ? super V1, ? super V2, ? super V3, ? super V4, ? super V5> builder, SQLExpression<V1> exp1, SQLExpression<V2> exp2, SQLExpression<V3> exp3, SQLExpression<V4> exp4, SQLExpression<V5> exp5) {
        Projector<T, R> proj = Projector.create(this._pclass, builder, exp1, exp2, exp3, exp4, exp5);
        return (List)this._ctx.invoke(new FindAllQuery.Projection<T, R>(this._ctx, proj, this.getClauses()));
    }

    public int delete() {
        this.assertValidDelete();
        return this._repo.deleteAll(this._pclass, this._where);
    }

    public int delete(CacheInvalidator invalidator) {
        this.assertValidDelete();
        return this._repo.deleteAll(this._pclass, this._where, invalidator);
    }

    protected Query(PersistenceContext ctx, DepotRepository repo, Class<T> pclass) {
        this._ctx = ctx;
        this._repo = repo;
        this._pclass = pclass;
    }

    protected Query<T> clone() {
        try {
            Query qb = (Query)super.clone();
            return qb;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    protected List<QueryClause> getClauses() {
        ArrayList clauses = Lists.newArrayList();
        this.addIfNotNull(clauses, this._where);
        Query.addAll(clauses, this._joins);
        this.addIfNotNull(clauses, this._orderBy);
        this.addIfNotNull(clauses, this._groupBy);
        this.addIfNotNull(clauses, this._limit);
        this.addIfNotNull(clauses, this._fromOverride);
        Query.addAll(clauses, this._fieldDefs);
        this.addIfNotNull(clauses, this._forUpdate);
        return clauses;
    }

    protected QueryClause[] getClauseArray() {
        List<QueryClause> clauses = this.getClauses();
        return clauses.toArray(new QueryClause[clauses.size()]);
    }

    protected void addIfNotNull(List<QueryClause> clauses, QueryClause clause) {
        if (clause != null) {
            clauses.add(clause);
        }
    }

    protected void assertValidDelete() {
        Preconditions.checkState((this._where != null ? 1 : 0) != 0, (Object)"Where clause must be specified for delete.");
        Preconditions.checkState((this._joins == null ? 1 : 0) != 0, (Object)"Join clauses not supported by delete.");
        Preconditions.checkState((this._orderBy == null ? 1 : 0) != 0, (Object)"OrderBy clause not applicable for delete.");
        Preconditions.checkState((this._groupBy == null ? 1 : 0) != 0, (Object)"GroupBy clause not applicable for delete.");
        Preconditions.checkState((this._limit == null ? 1 : 0) != 0, (Object)"Limit clause not supported by delete.");
        Preconditions.checkState((this._fromOverride == null ? 1 : 0) != 0, (Object)"FromOverride clause not applicable for delete.");
        Preconditions.checkState((this._fieldDefs == null ? 1 : 0) != 0, (Object)"FieldDefinition clauses not applicable for delete.");
        Preconditions.checkState((this._forUpdate == null ? 1 : 0) != 0, (Object)"ForUpdate clause not supported by delete.");
    }

    protected static <T> T getLoaded(List<T> selections) {
        return selections.isEmpty() ? null : (T)selections.get(0);
    }

    protected static <T> Cons<T> cons(T head, Cons<T> tail) {
        return new Cons<T>(head, tail);
    }

    protected static void addAll(List<QueryClause> toList, Cons<? extends QueryClause> cons) {
        if (cons != null) {
            toList.add((QueryClause)cons.head);
            Query.addAll(toList, cons.tail);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Cons<T> {
        public T head;
        public Cons<T> tail;

        public Cons(T head, Cons<T> tail) {
            this.head = head;
            this.tail = tail;
        }
    }
}

