/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.CacheAdapter;
import com.samskivert.depot.CacheKey;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Key;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.SchemaMigration;
import com.samskivert.depot.Stats;
import com.samskivert.depot.annotation.TableGenerator;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotMetaData;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.Fetcher;
import com.samskivert.depot.impl.KeyCacheKey;
import com.samskivert.depot.impl.Modifier;
import com.samskivert.depot.impl.Operation;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.LiaisonRegistry;
import com.samskivert.util.StringUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContext {
    public static final boolean DEBUG = Boolean.getBoolean("com.samskivert.depot.debug");
    public static final boolean CACHE_DEBUG = Boolean.getBoolean("com.samskivert.depot.cache_debug");
    public Map<String, TableGenerator> tableGenerators = Maps.newHashMap();
    protected String _ident;
    protected ConnectionProvider _conprov;
    protected DatabaseLiaison _liaison;
    protected DepotMetaData _meta = new DepotMetaData();
    protected boolean _warnOnLazyInit;
    protected Stats _stats = new Stats();
    protected CacheAdapter _cache;
    protected List<DepotRepository> _repositories = Lists.newArrayList();
    protected Map<Class<?>, DepotMarshaller<?>> _marshallers = Maps.newHashMap();
    protected Map<String, Set<CacheListener<?>>> _listenerSets = Maps.newHashMap();

    public CacheAdapter getCacheAdapter() {
        return this._cache;
    }

    public PersistenceContext() {
    }

    public PersistenceContext(String ident, ConnectionProvider conprov, CacheAdapter adapter) {
        this.init(ident, conprov, adapter);
    }

    public void init(String ident, ConnectionProvider conprov, CacheAdapter adapter) {
        this._ident = ident;
        this._conprov = conprov;
        this._liaison = LiaisonRegistry.getLiaison((String)conprov.getURL(ident));
        this._cache = adapter;
        this._meta.init(this);
    }

    public void shutdown() {
        try {
            if (this._cache != null) {
                this._cache.shutdown();
            }
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failure shutting down Depot cache.", new Object[]{t});
        }
        if (this._conprov != null) {
            this._conprov.shutdown();
        }
    }

    public Stats.Snapshot getStats() {
        return this._stats.getSnapshot();
    }

    public SQLBuilder getSQLBuilder(DepotTypes types) {
        return this._meta.getSQLBuilder(types, this._liaison);
    }

    public <T extends PersistentRecord> void registerMigration(Class<T> type, SchemaMigration migration) {
        DepotMarshaller<T> marshaller = this.getRawMarshaller(type);
        if (marshaller.isInitialized()) {
            throw new IllegalStateException("Migrations must be registered before initializeRepositories() is called.");
        }
        marshaller.registerMigration(migration);
    }

    public <T extends PersistentRecord> DepotMarshaller<T> getMarshaller(Class<T> type) throws DatabaseException {
        this.checkAreInitialized();
        DepotMarshaller<T> marshaller = this.getRawMarshaller(type);
        try {
            if (!marshaller.isInitialized()) {
                marshaller.init(this, this._meta);
                if (marshaller.getTableName() != null && this._warnOnLazyInit) {
                    Log.log.warning((Object)"Record initialized lazily", new Object[]{"type", type.getName(), new Exception()});
                }
            }
        }
        catch (DatabaseException pe) {
            throw (DatabaseException)new DatabaseException("Failed to initialize marshaller [type=" + type + "].").initCause(pe);
        }
        return marshaller;
    }

    public <T> T invoke(Fetcher<T> fetcher) throws DatabaseException {
        T result = fetcher.getCachedResult(this);
        if (result != null) {
            fetcher.updateStats(this._stats);
            return result;
        }
        return this.invoke(fetcher, true);
    }

    public int invoke(Modifier modifier) throws DatabaseException {
        return this.invoke(modifier, true);
    }

    public boolean isUsingCache() {
        return this._cache != null;
    }

    public <T> T cacheLookup(CacheKey key) {
        if (this._cache == null) {
            return null;
        }
        CacheAdapter.CachedValue ref = this._cache.lookup(key.getCacheId(), key.getCacheKey());
        return ref == null ? null : (T)ref.getValue();
    }

    public <T> void cacheStore(CacheAdapter.CacheCategory category, CacheKey key, T entry) {
        if (this._cache == null) {
            return;
        }
        if (key == null) {
            Log.log.warning((Object)("Cache key must not be null [entry=" + entry + "]"), new Object[]{new Exception()});
            return;
        }
        Log.log.debug((Object)("storing [key=" + key + ", value=" + entry + "]"), new Object[0]);
        CacheAdapter.CachedValue element = this._cache.lookup(key.getCacheId(), key.getCacheKey());
        Object oldEntry = element != null ? (Object)element.getValue() : null;
        this._cache.store(category, key.getCacheId(), key.getCacheKey(), entry);
        Set<CacheListener<?>> listeners = this._listenerSets.get(key.getCacheId());
        if (listeners != null && listeners.size() > 0) {
            for (CacheListener<?> listener : listeners) {
                Log.log.debug((Object)("cascading [listener=" + listener + "]"), new Object[0]);
                CacheListener<?> casted = listener;
                casted.entryCached(entry, oldEntry);
            }
        }
    }

    public void cacheInvalidate(Key<?> key) {
        if (key == null) {
            Log.log.warning((Object)"Cache key to invalidate must not be null.", new Object[]{new Exception()});
        } else {
            this.cacheInvalidate(new KeyCacheKey(key));
        }
    }

    public void cacheInvalidate(CacheKey key) {
        if (key == null) {
            Log.log.warning((Object)"Cache key to invalidate must not be null.", new Object[]{new Exception()});
        } else {
            this.cacheInvalidate(key.getCacheId(), key.getCacheKey());
        }
    }

    public <T extends Serializable> void cacheInvalidate(String cacheId, Serializable cacheKey) {
        Set<CacheListener<?>> listeners;
        Serializable oldEntry;
        CacheAdapter.CachedValue element;
        if (this._cache == null) {
            return;
        }
        if (CACHE_DEBUG) {
            Log.log.info((Object)"Invalidating", new Object[]{"id", cacheId, "key", cacheKey});
        }
        if ((element = this._cache.lookup(cacheId, cacheKey)) != null && (oldEntry = (Serializable)element.getValue()) != null && (listeners = this._listenerSets.get(cacheId)) != null && listeners.size() > 0) {
            for (CacheListener<?> listener : listeners) {
                Log.log.debug((Object)("cascading [listener=" + listener + "]"), new Object[0]);
                CacheListener<?> casted = listener;
                casted.entryInvalidated(oldEntry);
            }
        }
        this._cache.remove(cacheId, cacheKey);
    }

    public <T extends Serializable> void cacheTraverse(Class<? extends PersistentRecord> pClass, CacheTraverser<T> filter) {
        this.cacheTraverse(pClass.getName(), filter);
    }

    public <T extends Serializable> void cacheTraverse(String cacheId, CacheTraverser<T> filter) {
        if (this._cache == null) {
            return;
        }
        for (Serializable key : this._cache.enumerate(cacheId)) {
            CacheAdapter.CachedValue result = this._cache.lookup(cacheId, key);
            if (result == null || result.getValue() == null) continue;
            filter.visitCacheEntry(this, cacheId, key, (Serializable)result.getValue());
        }
    }

    public <T extends Serializable> void addCacheListener(Class<T> pClass, CacheListener<T> listener) {
        this.addCacheListener(pClass.getName(), listener);
    }

    public <T extends Serializable> void addCacheListener(String cacheId, CacheListener<T> listener) {
        HashSet listenerSet = this._listenerSets.get(cacheId);
        if (listenerSet == null) {
            listenerSet = Sets.newHashSet();
            this._listenerSets.put(cacheId, listenerSet);
        }
        listenerSet.add(listener);
    }

    public void initializeRepositories(boolean warnOnLazyInit) throws DatabaseException {
        for (DepotRepository repo : this._repositories) {
            repo.resolveRecords();
        }
        for (DepotRepository repo : this._repositories) {
            repo.init();
        }
        this._warnOnLazyInit = warnOnLazyInit;
        this._repositories = null;
    }

    protected void repositoryCreated(DepotRepository repo) {
        if (this._repositories == null) {
            if (this._warnOnLazyInit) {
                Log.log.warning((Object)("Repository created lazily: " + repo.getClass().getName()), new Object[0]);
            }
            repo.resolveRecords();
            repo.init();
        } else {
            this._repositories.add(repo);
        }
    }

    protected <T extends PersistentRecord> DepotMarshaller<T> getRawMarshaller(Class<T> type) {
        DepotMarshaller<Object> marshaller = this._marshallers.get(type);
        if (marshaller == null) {
            marshaller = new DepotMarshaller<T>(type, this);
            this._marshallers.put(type, marshaller);
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T invoke(Operation<T> op, boolean retryOnTransientFailure) throws DatabaseException {
        Connection conn;
        this.checkAreInitialized();
        boolean isReadOnly = op.isReadOnly();
        long preConnect = System.nanoTime();
        try {
            conn = this._conprov.getConnection(this._ident, isReadOnly);
        }
        catch (PersistenceException pe) {
            throw new DatabaseException(pe.getMessage(), pe.getCause());
        }
        ArrayList stmts = Lists.newArrayListWithCapacity((int)1);
        Connection connection = conn = JDBCUtil.makeCollector((Connection)conn, (List)stmts);
        synchronized (connection) {
            long preInvoke = System.nanoTime();
            try {
                Iterator<Object> i$;
                T value;
                try {
                    value = op.invoke(this, conn, this._liaison);
                }
                finally {
                    i$ = stmts.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                        }
                        Statement stmt = (Statement)i$.next();
                        stmt.close();
                    }
                }
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                this._stats.noteOp(isReadOnly, preConnect, preInvoke, System.nanoTime());
                op.updateStats(this._stats);
                i$ = value;
                return (T)i$;
            }
            catch (SQLException sqe) {
                if (!isReadOnly && this._liaison.isDuplicateRowException(sqe)) {
                    throw new DuplicateKeyException(sqe.getMessage());
                }
                this._conprov.connectionFailed(this._ident, isReadOnly, conn, sqe);
                conn = null;
                if (!retryOnTransientFailure) throw new DatabaseException("Operation failure " + op, sqe);
                if (!this._liaison.isTransientException(sqe)) throw new DatabaseException("Operation failure " + op, sqe);
                String msg = StringUtil.split((String)String.valueOf(sqe), (String)"\n")[0];
                Log.log.info((Object)("Transient failure executing op, retrying [error=" + msg + "]."), new Object[0]);
            }
            finally {
                if (conn != null) {
                    this._conprov.releaseConnection(this._ident, isReadOnly, conn);
                }
            }
            return this.invoke(op, false);
        }
    }

    protected void checkAreInitialized() {
        if (this._conprov == null) {
            throw new IllegalStateException("This persistence context has not yet been initialized. You are probably doing something too early, like in a repository's constructor. Don't do that.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CacheEvictionFilter<T extends Serializable>
    implements CacheTraverser<T> {
        @Override
        public void visitCacheEntry(PersistenceContext ctx, String cacheId, Serializable key, T record) {
            if (this.testForEviction(key, record)) {
                ctx.cacheInvalidate(cacheId, key);
            }
        }

        protected abstract boolean testForEviction(Serializable var1, T var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CacheTraverser<T extends Serializable> {
        public void visitCacheEntry(PersistenceContext var1, String var2, Serializable var3, T var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CacheListener<T> {
        public void entryInvalidated(T var1);

        public void entryCached(T var1, T var2);
    }
}

