/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.Key;
import com.samskivert.depot.KeySet;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.depot.impl.operator.In;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiKeySet<T extends PersistentRecord>
extends KeySet<T> {
    protected Comparable<?>[][] _keys;
    protected ColumnExp<?>[] _keyFields;

    public MultiKeySet(Class<T> pClass, ColumnExp<?>[] keyFields, Comparable<?>[][] keys) {
        super(pClass);
        this._keys = keys;
        this._keyFields = keyFields;
    }

    @Override
    public SQLExpression<?> getWhereExpression() {
        HashSet columns = Sets.newHashSet();
        for (int ii = 0; ii < this._keyFields.length; ++ii) {
            columns.add(ii);
        }
        return this.rowsToSQLExpression(Lists.newLinkedList(Arrays.asList(this._keys)), columns);
    }

    @Override
    public Iterator<Key<T>> iterator() {
        return Iterators.transform((Iterator)Iterators.forArray(this._keys), (Function)new Function<Comparable<?>[], Key<T>>(){

            public Key<T> apply(Comparable<?>[] key) {
                return new Key(MultiKeySet.this._pClass, key);
            }
        });
    }

    @Override
    public int size() {
        return this._keys.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiKeySet)) {
            return false;
        }
        MultiKeySet oset = (MultiKeySet)obj;
        return this._pClass.equals(oset._pClass) && Arrays.equals(this._keys, oset._keys);
    }

    public int hashCode() {
        return 31 * this._pClass.hashCode() + Arrays.hashCode(this._keys);
    }

    public String toString() {
        return DepotUtil.justClassName(this._pClass) + StringUtil.toString(this._keys);
    }

    protected SQLExpression<?> rowsToSQLExpression(List<Comparable<?>[]> keys, Set<Integer> columnsLeft) {
        ArrayList matches = Lists.newArrayList();
        while (!keys.isEmpty()) {
            int maxSize = 0;
            int maxColumn = -1;
            Comparable maxValue = null;
            for (int column : columnsLeft) {
                Tuple<Comparable<?>, Integer> colChunk = this.findBiggestChunk(keys, column);
                if ((Integer)colChunk.right <= maxSize) continue;
                maxColumn = column;
                maxSize = (Integer)colChunk.right;
                maxValue = (Comparable)colChunk.left;
            }
            if (maxSize > 3) {
                matches.add(this.extractChunk(keys, columnsLeft, maxColumn, maxValue));
                continue;
            }
            matches.addAll(this.gatherDetritus(keys, columnsLeft));
        }
        return Ops.or(matches);
    }

    protected Tuple<Comparable<?>, Integer> findBiggestChunk(List<Comparable<?>[]> rows, int col) {
        int maxCount = 0;
        Comparable<?> maxValue = null;
        HashMap countMap = Maps.newHashMap();
        for (Comparable<?>[] row : rows) {
            Comparable<?> element = row[col];
            Integer count = (Integer)countMap.get(element);
            if (count == null) {
                count = 1;
                countMap.put(element, count);
            } else {
                count = count + 1;
                countMap.put(element, count);
            }
            if (count <= maxCount) continue;
            maxCount = count;
            maxValue = element;
        }
        return new Tuple(maxValue, (Object)maxCount);
    }

    protected SQLExpression<?> extractChunk(List<Comparable<?>[]> rows, Set<Integer> columnsLeft, int column, Comparable<?> value) {
        In otherCondition;
        Iterator<Comparable<?>[]> iterator = rows.iterator();
        LinkedList newRows = Lists.newLinkedList();
        while (iterator.hasNext()) {
            Comparable<?>[] row = iterator.next();
            if (!row[column].equals(value)) continue;
            newRows.add(row);
            iterator.remove();
        }
        HashSet otherColumns = Sets.newHashSet(columnsLeft);
        otherColumns.remove(column);
        if (otherColumns.size() == 1) {
            int otherColumn = (Integer)otherColumns.iterator().next();
            ArrayList otherValues = Lists.newArrayList();
            for (Comparable[] row : newRows) {
                otherValues.add(row[otherColumn]);
            }
            otherCondition = this._keyFields[otherColumn].in(otherValues);
        } else {
            otherCondition = this.rowsToSQLExpression(newRows, otherColumns);
        }
        return Ops.and(this._keyFields[column].eq(value), otherCondition);
    }

    protected List<SQLExpression<?>> gatherDetritus(List<Comparable<?>[]> keys, Set<Integer> columnsLeft) {
        ArrayList conditions = Lists.newArrayList();
        Iterator<Comparable<?>[]> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Comparable<?>[] row = iterator.next();
            ArrayList bits = Lists.newArrayList();
            for (int column : columnsLeft) {
                bits.add(this._keyFields[column].eq(row[column]));
            }
            conditions.add(Ops.and(bits));
            iterator.remove();
        }
        return conditions;
    }
}

