/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.samskivert.depot.Key;
import com.samskivert.depot.MultiKeySet;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.ValidatingCacheInvalidator;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.depot.impl.expression.LiteralExp;
import com.samskivert.depot.impl.operator.In;
import com.samskivert.util.Logger;
import com.samskivert.util.StringUtil;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeySet<T extends PersistentRecord>
extends WhereClause
implements Serializable,
ValidatingCacheInvalidator,
Iterable<Key<T>> {
    protected Class<T> _pClass;

    public static <T extends PersistentRecord> KeySet<T> newKeySet(Class<T> pClass, Collection<Key<T>> keys) {
        if (keys.size() == 0) {
            return new EmptyKeySet<T>(pClass);
        }
        ColumnExp<?>[] keyFields = DepotUtil.getKeyFields(pClass);
        if (keyFields.length == 1) {
            Comparable<?> first = keys.iterator().next().getValues()[0];
            Object[] keyArray = first instanceof Integer ? new Integer[keys.size()] : (first instanceof Integer ? new String[keys.size()] : new Comparable[keys.size()]);
            int ii = 0;
            for (Key<T> key : keys) {
                keyArray[ii++] = key.getValues()[0];
            }
            return new SingleKeySet<T>(pClass, (Comparable<?>[])keyArray);
        }
        Comparable[][] keysValues = new Comparable[keys.size()][];
        int ii = 0;
        for (Key<T> key : keys) {
            keysValues[ii++] = key.getValues();
        }
        return new MultiKeySet<T>(pClass, keyFields, keysValues);
    }

    public static <T extends PersistentRecord> KeySet<T> newSimpleKeySet(Class<T> pClass, Collection<? extends Comparable<?>> keys) {
        ColumnExp<?>[] keyFields = DepotUtil.getKeyFields(pClass);
        if (keyFields.length != 1) {
            throw new IllegalArgumentException("Cannot create KeySet using simple keys for record with non-simple primary key [record=" + pClass + "]");
        }
        if (keys.size() == 0) {
            return new EmptyKeySet<T>(pClass);
        }
        Comparable<?> first = keys.iterator().next();
        Object[] keyArray = first instanceof Integer ? new Integer[keys.size()] : (first instanceof Integer ? new String[keys.size()] : new Comparable[keys.size()]);
        return new SingleKeySet<T>(pClass, (Comparable[])keys.toArray(keyArray));
    }

    public Collection<Key<T>> toCollection() {
        return new AbstractCollection<Key<T>>(){

            @Override
            public Iterator<Key<T>> iterator() {
                return KeySet.this.iterator();
            }

            @Override
            public int size() {
                return KeySet.this.size();
            }
        };
    }

    public abstract int size();

    @Override
    public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
        classSet.add(this._pClass);
    }

    @Override
    public Object accept(FragmentVisitor<?> builder) {
        return builder.visit(this);
    }

    @Override
    public void invalidate(PersistenceContext ctx) {
        for (Key key : this) {
            ctx.cacheInvalidate(key);
        }
    }

    @Override
    public void validateFlushType(Class<?> pClass) {
        if (!pClass.equals(this._pClass)) {
            throw new IllegalArgumentException(Logger.format((Object)"Class mismatch between persistent record and cache invalidator", (Object[])new Object[]{"record", pClass.getSimpleName(), "invtype", this._pClass.getSimpleName()}));
        }
    }

    @Override
    public void validateQueryType(Class<?> pClass) {
        super.validateQueryType(pClass);
        this.validateTypesMatch(pClass, this._pClass);
    }

    protected KeySet(Class<T> pClass) {
        this._pClass = pClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SingleKeySet<T extends PersistentRecord>
    extends KeySet<T> {
        protected Comparable<?>[] _keys;

        public SingleKeySet(Class<T> pClass, Comparable<?>[] keys) {
            super(pClass);
            if (keys.length > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Cannot create where clause for more than 32767 keys at a time.");
            }
            this._keys = keys;
        }

        @Override
        public SQLExpression<?> getWhereExpression() {
            return new In(DepotUtil.getKeyFields(this._pClass)[0], this._keys);
        }

        @Override
        public Iterator<Key<T>> iterator() {
            return Iterators.transform((Iterator)Iterators.forArray((Object[])this._keys), (Function)new Function<Comparable<?>, Key<T>>(){

                public Key<T> apply(Comparable<?> key) {
                    return new Key(SingleKeySet.this._pClass, new Comparable[]{key});
                }
            });
        }

        @Override
        public int size() {
            return this._keys.length;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SingleKeySet)) {
                return false;
            }
            SingleKeySet oset = (SingleKeySet)obj;
            return this._pClass.equals(oset._pClass) && Arrays.equals(this._keys, oset._keys);
        }

        public int hashCode() {
            return 31 * this._pClass.hashCode() + Arrays.hashCode(this._keys);
        }

        public String toString() {
            return DepotUtil.justClassName(this._pClass) + StringUtil.toString(this._keys);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EmptyKeySet<T extends PersistentRecord>
    extends KeySet<T> {
        public EmptyKeySet(Class<T> pClass) {
            super(pClass);
        }

        @Override
        public SQLExpression<?> getWhereExpression() {
            return new LiteralExp("false");
        }

        @Override
        public Iterator<Key<T>> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public int size() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof EmptyKeySet && this._pClass.equals(((EmptyKeySet)obj)._pClass);
        }

        public int hashCode() {
            return this._pClass.hashCode();
        }

        public String toString() {
            return DepotUtil.justClassName(this._pClass) + "(empty)";
        }
    }
}

