/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.CacheAdapter;
import com.samskivert.depot.Log;
import com.samskivert.util.Histogram;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.RMICacheReplicatorFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHCacheAdapter
implements CacheAdapter {
    public static final EHCacheConfig EHCACHE_RECORD_CONFIG = new EHCacheConfig("depotRecord", 200000, 300, 600);
    public static final EHCacheConfig EHCACHE_SHORT_KEYSET_CONFIG = new EHCacheConfig("depotShortKeyset", 25000, 10, 10);
    public static final EHCacheConfig EHCACHE_LONG_KEYSET_CONFIG = new EHCacheConfig("depotLongKeyset", 25000, 300, 300);
    public static final EHCacheConfig EHCACHE_RESULT_CONFIG = new EHCacheConfig("depotResult", 5000, 300, 300);
    protected CacheEventListener _cacheEventListener = new CacheEventListener(){

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }

        public void dispose() {
        }

        public void notifyElementEvicted(Ehcache cache, Element element) {
            Log.log.debug((Object)("notifyElementEvicted(" + cache + ", " + element + ")"), new Object[0]);
            this.removeFromBin(cache, element);
        }

        public void notifyElementExpired(Ehcache cache, Element element) {
            Log.log.debug((Object)("notifyElementExpired(" + cache + ", " + element + ")"), new Object[0]);
            this.removeFromBin(cache, element);
        }

        public void notifyElementPut(Ehcache cache, Element element) {
            Log.log.debug((Object)("notifyElementPut(" + cache + ", " + element + ")"), new Object[0]);
            this.addToBin(cache, element);
        }

        public void notifyElementRemoved(Ehcache cache, Element element) {
            Log.log.debug((Object)("notifyElementRemoved(" + cache + ", " + element + ")"), new Object[0]);
            this.removeFromBin(cache, element);
        }

        public void notifyElementUpdated(Ehcache cache, Element element) {
            Log.log.debug((Object)("notifyElementUpdated(" + cache + ", " + element + ")"), new Object[0]);
            this.addToBin(cache, element);
        }

        public void notifyRemoveAll(Ehcache cache) {
        }

        protected void removeFromBin(Ehcache cache, Element element) {
            EHCacheKey key = (EHCacheKey)element.getKey();
            EHCacheBin<?> bin = EHCacheAdapter.this._bins.get(key.getCacheId());
            if (bin == null) {
                Log.log.debug((Object)"Dropping element removal without cache bin", new Object[]{"key", key});
                return;
            }
            bin.removeKey(key.getCacheKey());
        }

        protected void addToBin(Ehcache cache, Element element) {
            EHCacheKey key = (EHCacheKey)element.getKey();
            EHCacheBin<?> bin = EHCacheAdapter.this._bins.get(key.getCacheId());
            if (bin == null) {
                Log.log.debug((Object)"Dropping element addition without cache bin", new Object[]{"key", key});
                return;
            }
            bin.addKey(key.getCacheKey());
        }
    };
    protected CacheManager _cachemgr;
    protected Histogram _lookups = new Histogram(0, 50, 20);
    protected Histogram _stores = new Histogram(0, 50, 20);
    protected Histogram _removes = new Histogram(0, 50, 20);
    protected Histogram _enumerations = new Histogram(0, 50, 20);
    protected Map<CacheAdapter.CacheCategory, Ehcache> _categories = Collections.synchronizedMap(Maps.newHashMap());
    protected Map<String, EHCacheBin<?>> _bins = Collections.synchronizedMap(Maps.newHashMap());
    protected static Serializable NULL = new NullValue(){};

    public EHCacheAdapter(CacheManager cachemgr, String ident) {
        this(cachemgr, ident, EHCACHE_RECORD_CONFIG, EHCACHE_SHORT_KEYSET_CONFIG, EHCACHE_LONG_KEYSET_CONFIG, EHCACHE_RESULT_CONFIG);
    }

    public EHCacheAdapter(CacheManager cachemgr, String ident, EHCacheConfig recordConfig, EHCacheConfig shortKeySetConfig, EHCacheConfig longKeySetConfig, EHCacheConfig resultConfig) {
        this._cachemgr = cachemgr;
        this.createEHCache(ident, CacheAdapter.CacheCategory.RECORD, recordConfig);
        this.createEHCache(ident, CacheAdapter.CacheCategory.SHORT_KEYSET, shortKeySetConfig);
        this.createEHCache(ident, CacheAdapter.CacheCategory.LONG_KEYSET, longKeySetConfig);
        this.createEHCache(ident, CacheAdapter.CacheCategory.RESULT, resultConfig);
    }

    @Override
    public <T> CacheAdapter.CachedValue<T> lookup(String cacheId, Serializable key) {
        long now = System.currentTimeMillis();
        EHCacheBin<?> bin = this._bins.get(cacheId);
        if (bin == null) {
            return null;
        }
        CacheAdapter.CachedValue<T> result = this.lookup(bin.getCache(), cacheId, key);
        this._lookups.addValue((int)(System.currentTimeMillis() - now));
        return result;
    }

    @Override
    public <T> void store(CacheAdapter.CacheCategory category, String cacheId, Serializable key, T value) {
        long now = System.currentTimeMillis();
        Ehcache cache = this._categories.get((Object)category);
        Preconditions.checkArgument((cache != null ? 1 : 0) != 0, (Object)("Unknown category: " + (Object)((Object)category)));
        EHCacheBin<Object> bin = this._bins.get(cacheId);
        if (bin == null) {
            bin = new EHCacheBin(cache, cacheId);
            this._bins.put(cacheId, bin);
        }
        bin.getCache().put(new Element((Object)new EHCacheKey(cacheId, key), value != null ? value : NULL));
        this._stores.addValue((int)(System.currentTimeMillis() - now));
    }

    @Override
    public void remove(String cacheId, Serializable key) {
        long now = System.currentTimeMillis();
        EHCacheBin<?> bin = this._bins.get(cacheId);
        if (bin != null) {
            bin.getCache().remove((Serializable)new EHCacheKey(cacheId, key));
        }
        this._removes.addValue((int)(System.currentTimeMillis() - now));
    }

    @Override
    public <T> Iterable<Serializable> enumerate(String cacheId) {
        long now = System.currentTimeMillis();
        EHCacheBin<?> bin = this._bins.get(cacheId);
        if (bin == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet(bin.getKeys());
        this._enumerations.addValue((int)(System.currentTimeMillis() - now));
        return result;
    }

    @Override
    public void shutdown() {
        Log.log.debug((Object)"EHCacheAdapter shutting down", new Object[]{"lookups", this._lookups, "stores", this._stores, "removes", this._removes, "enumerations", this._enumerations});
        for (Ehcache cache : this._categories.values()) {
            Log.log.debug((Object)("Removing ehcache " + cache.getName()), new Object[0]);
            this._cachemgr.removeCache(cache.getName());
        }
        this._categories.clear();
        this._bins.clear();
    }

    public EHCachePerformance getPerformanceSnapshot() {
        EHCachePerformance result = new EHCachePerformance();
        result.lookups = this._lookups.clone();
        result.stores = this._stores.clone();
        result.removes = this._removes.clone();
        result.enumerations = this._enumerations.clone();
        return result;
    }

    protected <T> CacheAdapter.CachedValue<T> lookup(Ehcache cache, String cacheId, Serializable key) {
        Element hit = cache.get((Serializable)new EHCacheKey(cacheId, key));
        if (hit == null) {
            return null;
        }
        Serializable rawValue = hit.getValue();
        final Serializable value = rawValue instanceof NullValue ? null : rawValue;
        return new CacheAdapter.CachedValue<T>(){

            @Override
            public T getValue() {
                return value;
            }

            public String toString() {
                return String.valueOf(value);
            }
        };
    }

    protected Ehcache createEHCache(String ident, CacheAdapter.CacheCategory category, EHCacheConfig config) {
        Ehcache cache = config.createCache(ident);
        this.addCacheListeners(cache);
        this._cachemgr.addCache(cache);
        Log.log.debug((Object)("Added new ehcache " + cache.getName()), new Object[0]);
        this._categories.put(category, cache);
        return cache;
    }

    protected void addCacheListeners(Ehcache cache) {
        cache.getCacheEventNotificationService().registerListener(this._cacheEventListener);
        Properties props = new Properties();
        props.setProperty("replicateAsynchronously", "true");
        props.setProperty("replicatePuts", "false");
        props.setProperty("replicateUpdates", "true");
        props.setProperty("replicateUpdatesViaCopy", "false");
        props.setProperty("replicateRemovals", "true");
        cache.getCacheEventNotificationService().registerListener(new RMICacheReplicatorFactory().createCacheEventListener(props));
    }

    protected static class NullValue
    implements Serializable {
        protected NullValue() {
        }

        public String toString() {
            return "<EHCache Null>";
        }

        public boolean equals(Object other) {
            return other != null && other.getClass().equals(NullValue.class);
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static class EHCacheKey
    implements Serializable {
        protected String _id;
        protected Serializable _key;

        public EHCacheKey(String id, Serializable key) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkNotNull((Object)key);
            this._id = id;
            this._key = key;
        }

        public String getCacheId() {
            return this._id;
        }

        public Serializable getCacheKey() {
            return this._key;
        }

        public String toString() {
            return "[" + this._id + ", " + this._key + "]";
        }

        public int hashCode() {
            return 31 * this._id.hashCode() + this._key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EHCacheKey okey = (EHCacheKey)obj;
            return this._id.equals(okey._id) && this._key.equals(okey._key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EHCacheBin<T> {
        protected Ehcache _cache;
        protected String _id;
        protected Set<Serializable> _keys = Sets.newSetFromMap(new ConcurrentHashMap());

        public EHCacheBin(Ehcache cache, String id) {
            this._cache = cache;
            this._id = id;
        }

        public Set<Serializable> getKeys() {
            return this._keys;
        }

        public void addKey(Serializable key) {
            this._keys.add(key);
        }

        public void removeKey(Serializable key) {
            this._keys.remove(key);
        }

        protected Ehcache getCache() {
            return this._cache;
        }
    }

    public static class EHCacheConfig {
        public String name;
        public int maxElementsInMemory;
        public int timeToIdleSeconds;
        public int timeToLiveSeconds;
        public boolean overflowToDisk = false;
        public int maxElementsOnDisk = 0;
        public boolean eternal = false;
        public MemoryStoreEvictionPolicy msep = MemoryStoreEvictionPolicy.LRU;

        public EHCacheConfig(String name, int maxElementsInMemory, int timeToIdleSeconds, int timeToLiveSeconds) {
            this.name = name;
            this.maxElementsInMemory = maxElementsInMemory;
            this.timeToIdleSeconds = timeToIdleSeconds;
            this.timeToLiveSeconds = timeToLiveSeconds;
        }

        public Ehcache createCache(String uid) {
            String cacheName = this.name + (uid == null ? "" : "." + uid);
            return new Cache(cacheName, this.maxElementsInMemory, this.msep, this.overflowToDisk, null, this.eternal, (long)this.timeToLiveSeconds, (long)this.timeToIdleSeconds, false, 0L, null);
        }
    }

    public static class EHCachePerformance {
        public Histogram lookups;
        public Histogram stores;
        public Histogram removes;
        public Histogram enumerations;
    }
}

