/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.msr.malmo;

import com.microsoft.msr.malmo.MalmoJavaJNI;
import com.microsoft.msr.malmo.TimestampedRewardVector;
import com.microsoft.msr.malmo.TimestampedStringVector;
import com.microsoft.msr.malmo.TimestampedVideoFrameVector;

public class WorldState {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected WorldState(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(WorldState worldState) {
        return worldState == null ? 0L : worldState.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MalmoJavaJNI.delete_WorldState(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public boolean getIsMissionRunning() {
        return MalmoJavaJNI.WorldState_IsMissionRunning_get(this.swigCPtr, this);
    }

    public boolean getHasMissionBegun() {
        return MalmoJavaJNI.WorldState_HasMissionBegun_get(this.swigCPtr, this);
    }

    public int getNumberOfVideoFramesSinceLastState() {
        return MalmoJavaJNI.WorldState_NumberOfVideoFramesSinceLastState_get(this.swigCPtr, this);
    }

    public int getNumberOfRewardsSinceLastState() {
        return MalmoJavaJNI.WorldState_NumberOfRewardsSinceLastState_get(this.swigCPtr, this);
    }

    public int getNumberOfObservationsSinceLastState() {
        return MalmoJavaJNI.WorldState_NumberOfObservationsSinceLastState_get(this.swigCPtr, this);
    }

    public TimestampedVideoFrameVector getVideoFrames() {
        long l = MalmoJavaJNI.WorldState_VideoFrames_get(this.swigCPtr, this);
        return l == 0L ? null : new TimestampedVideoFrameVector(l, false);
    }

    public TimestampedRewardVector getRewards() {
        long l = MalmoJavaJNI.WorldState_Rewards_get(this.swigCPtr, this);
        return l == 0L ? null : new TimestampedRewardVector(l, false);
    }

    public TimestampedStringVector getObservations() {
        long l = MalmoJavaJNI.WorldState_Observations_get(this.swigCPtr, this);
        return l == 0L ? null : new TimestampedStringVector(l, false);
    }

    public TimestampedStringVector getMissionControlMessages() {
        long l = MalmoJavaJNI.WorldState_MissionControlMessages_get(this.swigCPtr, this);
        return l == 0L ? null : new TimestampedStringVector(l, false);
    }

    public TimestampedStringVector getErrors() {
        long l = MalmoJavaJNI.WorldState_Errors_get(this.swigCPtr, this);
        return l == 0L ? null : new TimestampedStringVector(l, false);
    }

    public WorldState() {
        this(MalmoJavaJNI.new_WorldState(), true);
    }
}

