/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.annotation.callsuper;

import com.kotcrab.annotation.CallSuper;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;

class CodeAnalyzerTreeScanner
extends TreePathScanner<Object, Trees> {
    private String methodName;
    private MethodTree method;
    private boolean callSuperUsed;

    CodeAnalyzerTreeScanner() {
    }

    @Override
    public Object visitClass(ClassTree classTree, Trees trees) {
        Tree extendTree = classTree.getExtendsClause();
        if (extendTree instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply generic = (JCTree.JCTypeApply)extendTree;
            extendTree = generic.clazz;
        }
        if (extendTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent tree = (JCTree.JCIdent)extendTree;
            Scope members = tree.sym.members();
            if (this.checkScope(members)) {
                return super.visitClass(classTree, trees);
            }
            if (this.checkSuperTypes((Type.ClassType)tree.type)) {
                return super.visitClass(classTree, trees);
            }
        }
        this.callSuperUsed = false;
        return super.visitClass(classTree, trees);
    }

    public boolean checkSuperTypes(Type.ClassType type) {
        if (type.supertype_field != null && type.supertype_field.tsym != null) {
            if (this.checkScope(type.supertype_field.tsym.members())) {
                return true;
            }
            return this.checkSuperTypes((Type.ClassType)type.supertype_field);
        }
        return false;
    }

    public boolean checkScope(Scope members) {
        for (Symbol s : members.getElements()) {
            CallSuper annotation;
            Symbol.MethodSymbol ms;
            if (!(s instanceof Symbol.MethodSymbol) || !((Name)(ms = (Symbol.MethodSymbol)s).getSimpleName()).toString().equals(this.methodName) || (annotation = ms.getAnnotation(CallSuper.class)) == null) continue;
            this.callSuperUsed = true;
            return true;
        }
        return false;
    }

    @Override
    public Object visitMethod(MethodTree methodTree, Trees trees) {
        if (methodTree.getName().toString().equals(this.methodName)) {
            this.method = methodTree;
        }
        return super.visitMethod(methodTree, trees);
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public MethodTree getMethod() {
        return this.method;
    }

    public boolean isCallSuperUsed() {
        return this.callSuperUsed;
    }
}

