/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.annotation.callsuper;

import com.kotcrab.annotation.OverrideCallSuper;
import com.kotcrab.annotation.callsuper.CodeAnalyzerTreeScanner;
import com.sun.source.tree.StatementTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"java.lang.Override"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CallSuperProcessor
extends AbstractProcessor {
    private Trees trees;

    @Override
    public void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.trees = Trees.instance(pe);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Override.class)) {
            List<? extends StatementTree> list;
            if (element.getAnnotation(OverrideCallSuper.class) != null) {
                return false;
            }
            CodeAnalyzerTreeScanner codeScanner = new CodeAnalyzerTreeScanner();
            codeScanner.setMethodName(element.getSimpleName().toString());
            TreePath tp = this.trees.getPath(element.getEnclosingElement());
            codeScanner.scan(tp, this.trees);
            if (!codeScanner.isCallSuperUsed() || this.doesCallSuper(list = codeScanner.getMethod().getBody().getStatements(), codeScanner.getMethodName())) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Overriding method '" + codeScanner.getMethodName() + "' must explicitly call super method from it's parent class", element);
        }
        return false;
    }

    private boolean doesCallSuper(List list, String methodName) {
        for (Object object : list) {
            JCTree.JCExpressionStatement expr;
            String exprString;
            if (!(object instanceof JCTree.JCExpressionStatement) || !(exprString = (expr = (JCTree.JCExpressionStatement)object).toString()).startsWith("super." + methodName) || !exprString.endsWith(");")) continue;
            return true;
        }
        return false;
    }
}

