/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AetherHelper;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.HeaderFilesDirective;
import com.jayway.maven.plugins.android.configuration.Ndk;
import com.jayway.maven.plugins.android.phase05compile.MakefileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.IOUtil;

public class NdkBuildMojo
extends AbstractAndroidMojo {
    @ConfigPojo(prefix="ndk")
    private Ndk ndk;
    @PullParameter
    private String ndkBuildExecutable;
    @PullParameter
    private String ndkBuildDirectory;
    @PullParameter
    private String ndkClassifier;
    @PullParameter
    protected String ndkBuildAdditionalCommandline;
    @PullParameter(defaultValue="false")
    private Boolean clearNativeArtifacts;
    @PullParameter(defaultValue="false")
    private Boolean attachNativeArtifacts;
    private File ndkOutputDirectory;
    private File nativeLibrariesOutputDirectory;
    @PullParameter
    private String target;
    @PullParameter(defaultValue="armeabi")
    private String ndkArchitecture;
    protected ArtifactFactory artifactFactory;
    @PullParameter(defaultValue="true")
    private Boolean attachHeaderFiles;
    @PullParameter(defaultValue="false")
    private Boolean useLocalSrcIncludePaths;
    @PullParameter
    private List<HeaderFilesDirective> headerFilesDirectives;
    private JarArchiver jarArchiver;
    @PullParameter(defaultValue="true")
    private Boolean useHeaderArchives;
    @PullParameter
    private Map<String, String> systemProperties;
    @PullParameter(defaultValue="true")
    private Boolean ignoreBuildWarnings;
    @PullParameter(defaultValue=".*[warning|note]: .*")
    private String buildWarningsRegularExpression;
    @PullParameter(defaultValue="false")
    private Boolean skipStripping;
    @PullParameter(defaultValue="arm-linux-androideabi-4.4.3")
    private String ndkToolchain;
    @PullParameter
    private String ndkFinalLibraryName;
    @PullParameter
    private String makefile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File ndkBuildFile = new File(this.getAndroidNdk().getNdkBuildPath());
            NativeHelper.validateNDKVersion(ndkBuildFile.getParentFile());
            this.validateMakefile(this.project, this.makefile);
            Preparation preparation = new Preparation().invoke();
            File nativeLibDirectory = preparation.getNativeLibDirectory();
            boolean libsDirectoryExists = preparation.isLibsDirectoryExists();
            File directoryToRemove = preparation.getDirectoryToRemove();
            CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            executor.setErrorListener(this.getNdkErrorListener());
            Set<Artifact> nativeLibraryArtifacts = this.findNativeLibraryDependencies();
            Set<Artifact> resolveNativeLibraryArtifacts = AetherHelper.resolveArtifacts(nativeLibraryArtifacts, this.repoSystem, this.repoSession, this.projectRepos);
            File androidMavenMakefile = File.createTempFile("android_maven_plugin_makefile", ".mk");
            androidMavenMakefile.deleteOnExit();
            MakefileHelper.MakefileHolder makefileHolder = MakefileHelper.createMakefileFromArtifacts(androidMavenMakefile.getParentFile(), resolveNativeLibraryArtifacts, this.useHeaderArchives, this.repoSession, this.projectRepos, this.repoSystem);
            IOUtil.copy((String)makefileHolder.getMakeFile(), (OutputStream)new FileOutputStream(androidMavenMakefile));
            executor.addEnvironment("ANDROID_MAVEN_PLUGIN_MAKEFILE", androidMavenMakefile.getAbsolutePath());
            if (NativeHelper.hasStaticNativeLibraryArtifact(resolveNativeLibraryArtifacts)) {
                executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_STATIC_LIBRARIES", MakefileHelper.createLibraryList(resolveNativeLibraryArtifacts, true));
            }
            if (NativeHelper.hasSharedNativeLibraryArtifact(resolveNativeLibraryArtifacts)) {
                executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_SHARED_LIBRARIES", MakefileHelper.createLibraryList(resolveNativeLibraryArtifacts, false));
            }
            File makefileCaptureFile = File.createTempFile("android_maven_plugin_makefile_captures", ".tmp");
            makefileCaptureFile.deleteOnExit();
            executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE", makefileCaptureFile.getAbsolutePath());
            if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
                for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                    executor.addEnvironment(entry.getKey(), entry.getValue());
                }
            }
            executor.setLogger(this.getLog());
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("-C");
            if (this.ndkBuildDirectory == null) {
                this.ndkBuildDirectory = this.project.getBasedir().getAbsolutePath();
            }
            commands.add(this.ndkBuildDirectory);
            if (this.makefile != null) {
                File makeFile = new File(this.project.getBasedir(), this.makefile);
                if (!makeFile.exists()) {
                    this.getLog().error((CharSequence)("Specified makefile " + makeFile + " does not exist"));
                    throw new MojoExecutionException("Specified makefile " + makeFile + " does not exist");
                }
                commands.add("-f");
                commands.add(this.makefile);
            }
            commands.add("NDK_TOOLCHAIN=" + this.ndkToolchain);
            if (this.ndkBuildAdditionalCommandline != null) {
                String[] additionalCommands;
                for (String command : additionalCommands = this.ndkBuildAdditionalCommandline.split(" ")) {
                    commands.add(command);
                }
            }
            if (this.target != null) {
                commands.add(this.target);
            } else {
                commands.add(this.project.getArtifactId());
            }
            String ndkBuildPath = this.resolveNdkBuildExecutable();
            this.getLog().info((CharSequence)(ndkBuildPath + " " + ((Object)commands).toString()));
            executor.executeCommand(ndkBuildPath, commands, this.project.getBasedir(), true);
            this.cleanUp(nativeLibDirectory, libsDirectoryExists, directoryToRemove, makefileHolder, makefileCaptureFile);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error during build: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error while executing: " + e.getMessage()));
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(File nativeLibDirectory, boolean libsDirectoryExists, File directoryToRemove, MakefileHelper.MakefileHolder makefileHolder, File makefileCaptureFile) throws IOException, MojoExecutionException {
        try {
            if (this.clearNativeArtifacts.booleanValue()) {
                nativeLibDirectory = this.cleanUpNativeArtifacts(nativeLibDirectory, libsDirectoryExists);
            }
            if ("so".equals(this.project.getPackaging()) || "a".equals(this.project.getPackaging()) || this.attachNativeArtifacts.booleanValue()) {
                File nativeArtifactFile;
                if (this.ndkFinalLibraryName == null) {
                    File[] files = nativeLibDirectory.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            if ("a".equals(NdkBuildMojo.this.project.getPackaging())) {
                                return name.startsWith("lib" + (NdkBuildMojo.this.target != null ? NdkBuildMojo.this.target : NdkBuildMojo.this.project.getArtifactId())) && name.endsWith(".a");
                            }
                            return name.startsWith("lib" + (NdkBuildMojo.this.target != null ? NdkBuildMojo.this.target : NdkBuildMojo.this.project.getArtifactId())) && name.endsWith(".so");
                        }
                    });
                    if (files == null || files.length != 1) {
                        this.getLog().warn((CharSequence)("Error while detecting native compile artifacts: " + (files == null || files.length == 0 ? "None found" : "Found more than 1 artifact")));
                        if (files != null && files.length > 1) {
                            this.getLog().debug((CharSequence)("List of files found: " + Arrays.asList(files)));
                            this.getLog().error((CharSequence)"Currently, only a single, final native library is supported by the build");
                            throw new MojoExecutionException("Currently, only a single, final native library is supported by the build");
                        }
                        this.getLog().error((CharSequence)"No native compiled library found, did the native compile complete successfully?");
                        throw new MojoExecutionException("No native compiled library found, did the native compile complete successfully?");
                    }
                    nativeArtifactFile = files[0];
                } else {
                    nativeArtifactFile = new File(nativeLibDirectory, this.ndkFinalLibraryName + "." + this.project.getPackaging());
                    if (!nativeArtifactFile.exists()) {
                        this.getLog().error((CharSequence)("Could not locate final native library using the provided ndkFinalLibraryName " + this.ndkFinalLibraryName + " (tried " + nativeArtifactFile.getAbsolutePath() + ")"));
                        throw new MojoExecutionException("Could not locate final native library using the provided ndkFinalLibraryName " + this.ndkFinalLibraryName + " (tried " + nativeArtifactFile.getAbsolutePath() + ")");
                    }
                }
                String artifactType = this.resolveArtifactType(nativeArtifactFile);
                if ("so".equals(artifactType) && !this.skipStripping.booleanValue()) {
                    this.getLog().debug((CharSequence)("Post processing (stripping) native compiled artifact: " + nativeArtifactFile));
                    this.invokeNDKStripper(nativeArtifactFile);
                }
                this.getLog().debug((CharSequence)("Adding native compiled artifact: " + nativeArtifactFile));
                File fileToAttach = nativeArtifactFile;
                if (!libsDirectoryExists) {
                    this.getLog().debug((CharSequence)"Moving native compiled artifact to target directory for preservation");
                    File destFile = new File(this.project.getBuild().getDirectory(), nativeArtifactFile.getName());
                    FileUtils.moveFile((File)nativeArtifactFile, (File)destFile);
                    fileToAttach = destFile;
                }
                this.projectHelper.attachArtifact(this.project, artifactType, this.ndkClassifier != null ? this.ndkClassifier : this.ndkArchitecture, fileToAttach);
            }
            this.processMakefileCapture(makefileCaptureFile);
        }
        finally {
            if (!libsDirectoryExists) {
                this.getLog().info((CharSequence)"Cleaning up native library output directory after build");
                this.getLog().debug((CharSequence)("Removing directory: " + directoryToRemove));
                FileUtils.deleteDirectory((File)directoryToRemove);
            }
            if (makefileHolder != null) {
                this.getLog().info((CharSequence)"Cleaning up extracted include directories used for build");
                MakefileHelper.cleanupAfterBuild(makefileHolder);
            }
        }
    }

    private CommandExecutor.ErrorListener getNdkErrorListener() {
        return new CommandExecutor.ErrorListener(){

            @Override
            public boolean isError(String error) {
                if (NdkBuildMojo.this.ignoreBuildWarnings.booleanValue()) {
                    return false;
                }
                Pattern pattern = Pattern.compile(NdkBuildMojo.this.buildWarningsRegularExpression);
                Matcher matcher = pattern.matcher(error);
                return !matcher.matches();
            }
        };
    }

    private File cleanUpNativeArtifacts(File nativeLibDirectory, boolean libsDirectoryExists) throws IOException {
        File destinationDirectory = new File(this.ndkOutputDirectory.getAbsolutePath(), "/" + this.ndkArchitecture);
        if (!libsDirectoryExists) {
            FileUtils.moveDirectory((File)nativeLibDirectory, (File)destinationDirectory);
        } else {
            FileUtils.copyDirectory((File)nativeLibDirectory, (File)destinationDirectory);
            FileUtils.cleanDirectory((File)nativeLibDirectory);
        }
        nativeLibDirectory = destinationDirectory;
        return nativeLibDirectory;
    }

    private void validateMakefile(MavenProject project, String makefile) {
    }

    private void invokeNDKStripper(File file) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Detected shared library artifact, will now strip it");
            CommandExecutor stripCommandExecutor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            stripCommandExecutor.setErrorListener(new CommandExecutor.ErrorListener(){

                @Override
                public boolean isError(String error) {
                    NdkBuildMojo.this.getLog().error((CharSequence)("Error while stripping binary: " + error));
                    return true;
                }
            });
            stripCommandExecutor.setLogger(this.getLog());
            stripCommandExecutor.executeCommand(this.resolveNdkStripper().getAbsolutePath(), Arrays.asList(file.getAbsolutePath()));
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)"Error while attempting to strip shared library", (Throwable)e);
            throw new MojoExecutionException("Error while attempting to strip shared library");
        }
    }

    private String resolveNdkBuildExecutable() throws MojoExecutionException {
        if (this.ndkBuildExecutable != null) {
            this.getLog().debug((CharSequence)("ndk-build overriden, using " + this.ndkBuildExecutable));
            return this.ndkBuildExecutable;
        }
        return this.getAndroidNdk().getNdkBuildPath();
    }

    private File resolveNdkStripper() throws MojoExecutionException {
        return this.getAndroidNdk().getStripper(this.ndkToolchain);
    }

    private void processMakefileCapture(File localCIncludesFile) throws MojoExecutionException {
        try {
            if (this.attachHeaderFiles.booleanValue()) {
                ArrayList<HeaderFilesDirective> finalHeaderFilesDirectives = new ArrayList<HeaderFilesDirective>();
                if (this.useLocalSrcIncludePaths.booleanValue()) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(localCIncludesFile));
                    String localCIncludes = props.getProperty("LOCAL_C_INCLUDES");
                    if (localCIncludes != null && !localCIncludes.trim().isEmpty()) {
                        String[] includes;
                        for (String include : includes = localCIncludes.split(" ")) {
                            HeaderFilesDirective headerFilesDirective = new HeaderFilesDirective();
                            File includeDir = new File(this.project.getBasedir(), include);
                            headerFilesDirective.setDirectory(includeDir.getAbsolutePath());
                            headerFilesDirective.setIncludes(new String[]{"**/*.h"});
                            finalHeaderFilesDirectives.add(headerFilesDirective);
                        }
                    }
                } else if (this.headerFilesDirectives != null) {
                    finalHeaderFilesDirectives.addAll(this.headerFilesDirectives);
                }
                if (finalHeaderFilesDirectives.isEmpty()) {
                    this.getLog().debug((CharSequence)"No header files included, will add default set");
                    HeaderFilesDirective e = new HeaderFilesDirective();
                    e.setDirectory(new File(this.project.getBasedir() + "/jni").getAbsolutePath());
                    e.setIncludes(new String[]{"**/*.h"});
                    finalHeaderFilesDirectives.add(e);
                }
                this.createHeaderArchive(finalHeaderFilesDirectives);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while processing headers to include: " + e.getMessage(), e);
        }
    }

    private void createHeaderArchive(List<HeaderFilesDirective> finalHeaderFilesDirectives) throws MojoExecutionException {
        try {
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver(this.jarArchiver);
            File jarFile = new File(new File(this.project.getBuild().getDirectory()), this.project.getBuild().getFinalName() + ".har");
            mavenArchiver.setOutputFile(jarFile);
            for (HeaderFilesDirective headerFilesDirective : finalHeaderFilesDirectives) {
                mavenArchiver.getArchiver().addDirectory(new File(headerFilesDirective.getDirectory()), headerFilesDirective.getIncludes(), headerFilesDirective.getExcludes());
            }
            MavenArchiveConfiguration mavenArchiveConfiguration = new MavenArchiveConfiguration();
            mavenArchiveConfiguration.setAddMavenDescriptor(false);
            mavenArchiver.createArchive(this.project, mavenArchiveConfiguration);
            this.projectHelper.attachArtifact(this.project, "har", this.ndkClassifier != null ? this.ndkClassifier : this.ndkArchitecture, jarFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private Set<Artifact> findNativeLibraryDependencies() throws MojoExecutionException {
        NativeHelper nativeHelper = new NativeHelper(this.project, this.projectRepos, this.repoSession, this.repoSystem, this.artifactFactory, this.getLog());
        Set<Artifact> staticLibraryArtifacts = nativeHelper.getNativeDependenciesArtifacts(this.unpackedApkLibsDirectory, false);
        Set<Artifact> sharedLibraryArtifacts = nativeHelper.getNativeDependenciesArtifacts(this.unpackedApkLibsDirectory, true);
        LinkedHashSet<Artifact> mergedArtifacts = new LinkedHashSet<Artifact>(staticLibraryArtifacts);
        mergedArtifacts.addAll(sharedLibraryArtifacts);
        return mergedArtifacts;
    }

    private String resolveArtifactType(File file) {
        if ("so".equals(this.project.getPackaging()) || "a".equals(this.project.getPackaging())) {
            return this.project.getPackaging();
        }
        return file.getName().endsWith("so") ? "so" : "a";
    }

    private class Preparation {
        private File nativeLibDirectory;
        private boolean libsDirectoryExists;
        private File directoryToRemove;

        private Preparation() {
        }

        public File getNativeLibDirectory() {
            return this.nativeLibDirectory;
        }

        public boolean isLibsDirectoryExists() {
            return this.libsDirectoryExists;
        }

        public File getDirectoryToRemove() {
            return this.directoryToRemove;
        }

        public Preparation invoke() {
            this.nativeLibDirectory = new File(NdkBuildMojo.this.nativeLibrariesOutputDirectory, NdkBuildMojo.this.ndkArchitecture);
            this.libsDirectoryExists = this.nativeLibDirectory.exists();
            this.directoryToRemove = this.nativeLibDirectory;
            if (!this.libsDirectoryExists) {
                NdkBuildMojo.this.getLog().info((CharSequence)("Creating native output directory " + this.nativeLibDirectory));
                if (!NdkBuildMojo.this.nativeLibrariesOutputDirectory.exists()) {
                    if (NdkBuildMojo.this.nativeLibrariesOutputDirectory.getParentFile().exists()) {
                        this.nativeLibDirectory.mkdir();
                    } else {
                        this.nativeLibDirectory.mkdirs();
                        this.directoryToRemove = NdkBuildMojo.this.nativeLibrariesOutputDirectory.getParentFile();
                    }
                } else if (this.nativeLibDirectory.getParentFile().exists()) {
                    this.nativeLibDirectory.mkdir();
                } else {
                    this.nativeLibDirectory.mkdirs();
                    this.directoryToRemove = this.nativeLibDirectory.getParentFile();
                }
            }
            return this;
        }
    }
}

