/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.AndroidSigner;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.configuration.Sign;
import com.jayway.maven.plugins.android.phase09package.ApkBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.AbstractScanner;
import org.codehaus.plexus.util.DirectoryScanner;

public class ApkMojo
extends AbstractAndroidMojo {
    private Sign sign;
    private String signDebug;
    private String renameManifestPackage;
    private String renameInstrumentationTargetPackage;
    private boolean extractDuplicates;
    private File nativeLibrariesOutputDirectory;
    private String nativeLibrariesDependenciesHardwareArchitectureDefault;
    private String classifier;
    private String nativeLibrariesDependenciesHardwareArchitectureOverride;
    private File[] sourceDirectories;
    protected ArtifactFactory artifactFactory;
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);
    private Map<String, List<File>> m_jars = new HashMap<String, List<File>>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generateApk) {
            return;
        }
        this.generateIntermediateAp_();
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + "apk");
        boolean signWithDebugKeyStore = this.getAndroidSigner().isSignWithDebugKeyStore();
        if (this.getAndroidSigner().shouldCreateBothSignedAndUnsignedApk()) {
            this.getLog().info((CharSequence)("Creating debug key signed apk file " + outputFile));
            this.createApkFile(outputFile, true);
            File unsignedOutputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "-unsigned." + "apk");
            this.getLog().info((CharSequence)("Creating additional unsigned apk file " + unsignedOutputFile));
            this.createApkFile(unsignedOutputFile, false);
            this.projectHelper.attachArtifact(this.project, unsignedOutputFile, this.classifier == null ? "unsigned" : this.classifier + "_unsigned");
        } else {
            this.createApkFile(outputFile, signWithDebugKeyStore);
        }
        if (this.classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, outputFile, this.classifier);
        }
    }

    void createApkFile(File outputFile, boolean signWithDebugKeyStore) throws MojoExecutionException {
        File dexFile = new File(this.project.getBuild().getDirectory(), "classes.dex");
        File zipArchive = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        ArrayList<File> sourceFolders = new ArrayList<File>();
        if (this.sourceDirectories != null) {
            for (File f : this.sourceDirectories) {
                sourceFolders.add(f);
            }
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        ArrayList<File> nativeFolders = new ArrayList<File>();
        boolean useInternalAPKBuilder = true;
        try {
            this.initializeAPKBuilder();
        }
        catch (Throwable e) {
            useInternalAPKBuilder = false;
        }
        this.processNativeLibraries(nativeFolders);
        if (useInternalAPKBuilder) {
            this.doAPKWithAPKBuilder(outputFile, dexFile, zipArchive, sourceFolders, jarFiles, nativeFolders, false, signWithDebugKeyStore, false);
        } else {
            this.doAPKWithCommand(outputFile, dexFile, zipArchive, sourceFolders, jarFiles, nativeFolders, signWithDebugKeyStore);
        }
    }

    private void computeDuplicateFiles(File jar) throws ZipException, IOException {
        ZipFile file = new ZipFile(jar);
        Enumeration<? extends ZipEntry> list = file.entries();
        while (list.hasMoreElements()) {
            ZipEntry ze = list.nextElement();
            if (ze.getName().contains("META-INF/") || ze.isDirectory()) continue;
            List<File> l = this.m_jars.get(ze.getName());
            if (l == null) {
                l = new ArrayList<File>();
                this.m_jars.put(ze.getName(), l);
            }
            l.add(jar);
        }
    }

    private void doAPKWithAPKBuilder(File outputFile, File dexFile, File zipArchive, ArrayList<File> sourceFolders, ArrayList<File> jarFiles, ArrayList<File> nativeFolders, boolean verbose, boolean signWithDebugKeyStore, boolean debug) throws MojoExecutionException {
        sourceFolders.add(new File(this.project.getBuild().getOutputDirectory()));
        for (Artifact artifact : this.getRelevantCompileArtifacts()) {
            if (this.extractDuplicates) {
                try {
                    this.computeDuplicateFiles(artifact.getFile());
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Cannot compute duplicates files from " + artifact.getFile().getAbsolutePath()), (Throwable)e);
                }
            }
            jarFiles.add(artifact.getFile());
        }
        if (this.extractDuplicates) {
            ArrayList<String> duplicates = new ArrayList<String>();
            ArrayList<File> jarToModify = new ArrayList<File>();
            for (String s : this.m_jars.keySet()) {
                List<File> l = this.m_jars.get(s);
                if (l.size() <= 1) continue;
                this.getLog().warn((CharSequence)("Duplicate file " + s + " : " + l));
                duplicates.add(s);
                for (int i = 1; i < l.size(); ++i) {
                    if (jarToModify.contains(l.get(i))) continue;
                    jarToModify.add(l.get(i));
                }
            }
            for (File file : jarToModify) {
                File newJar = this.removeDuplicatesFromJar(file, duplicates);
                int index = jarFiles.indexOf(file);
                if (newJar == null) continue;
                jarFiles.set(index, newJar);
            }
        }
        ApkBuilder builder = new ApkBuilder(outputFile, zipArchive, dexFile, signWithDebugKeyStore, verbose ? System.out : null);
        if (debug) {
            builder.setDebugMode(debug);
        }
        for (File sourceFolder : sourceFolders) {
            builder.addSourceFolder(sourceFolder);
        }
        for (File jarFile : jarFiles) {
            if (jarFile.isDirectory()) {
                String[] filenames;
                for (String filename : filenames = jarFile.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return PATTERN_JAR_EXT.matcher(name).matches();
                    }
                })) {
                    builder.addResourcesFromJar(new File(jarFile, filename));
                }
                continue;
            }
            builder.addResourcesFromJar(jarFile);
        }
        for (File nativeFolder : nativeFolders) {
            builder.addNativeLibraries(nativeFolder, null);
        }
        builder.sealApk();
    }

    private File removeDuplicatesFromJar(File in, List<String> duplicates) {
        File target = new File(this.project.getBasedir(), "target");
        File tmp = new File(target, "unpacked-embedded-jars");
        tmp.mkdirs();
        File out = new File(tmp, in.getName());
        if (out.exists()) {
            return out;
        }
        try {
            out.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream fos = null;
        ZipOutputStream jos = null;
        try {
            fos = new FileOutputStream(out);
            jos = new ZipOutputStream(fos);
        }
        catch (FileNotFoundException e1) {
            this.getLog().error((CharSequence)("Cannot remove duplicates : the output file " + out.getAbsolutePath() + " does not found"));
            return null;
        }
        ZipFile inZip = null;
        try {
            inZip = new ZipFile(in);
            Enumeration<? extends ZipEntry> entries = inZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (duplicates.contains(entry.getName())) continue;
                jos.putNextEntry(entry);
                InputStream currIn = inZip.getInputStream(entry);
                ApkMojo.copyStreamWithoutClosing(currIn, jos);
                currIn.close();
                jos.closeEntry();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Cannot removing duplicates : " + e.getMessage()));
            return null;
        }
        try {
            if (inZip != null) {
                inZip.close();
            }
            jos.close();
            fos.close();
            jos = null;
            fos = null;
        }
        catch (IOException e) {
            // empty catch block
        }
        this.getLog().info((CharSequence)(in.getName() + " rewritten without duplicates : " + out.getAbsolutePath()));
        return out;
    }

    private static void copyStreamWithoutClosing(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.write(b, 0, n);
        }
    }

    private void doAPKWithCommand(File outputFile, File dexFile, File zipArchive, ArrayList<File> sourceFolders, ArrayList<File> jarFiles, ArrayList<File> nativeFolders, boolean signWithDebugKeyStore) throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(outputFile.getAbsolutePath());
        if (!signWithDebugKeyStore) {
            commands.add("-u");
        }
        commands.add("-z");
        commands.add(new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_").getAbsolutePath());
        commands.add("-f");
        commands.add(new File(this.project.getBuild().getDirectory(), "classes.dex").getAbsolutePath());
        commands.add("-rf");
        commands.add(new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath());
        if (nativeFolders != null && !nativeFolders.isEmpty()) {
            for (File lib : nativeFolders) {
                commands.add("-nf");
                commands.add(lib.getAbsolutePath());
            }
        }
        for (Artifact artifact : this.getRelevantCompileArtifacts()) {
            commands.add("-rj");
            commands.add(artifact.getFile().getAbsolutePath());
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("apkbuilder") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("apkbuilder"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private void initializeAPKBuilder() throws MojoExecutionException {
        File file = this.getAndroidSdk().getSDKLibJar();
        ApkBuilder.initialize(this.getLog(), file);
    }

    private void processNativeLibraries(List<File> natives) throws MojoExecutionException {
        boolean hasValidBuildNativeLibrariesDirectory;
        boolean hasValidNativeLibrariesDirectory = this.nativeLibrariesDirectory != null && this.nativeLibrariesDirectory.exists() && this.nativeLibrariesDirectory.listFiles() != null && this.nativeLibrariesDirectory.listFiles().length > 0;
        NativeHelper nativeHelper = new NativeHelper(this.project, this.projectRepos, this.repoSession, this.repoSystem, this.artifactFactory, this.getLog());
        Set<Artifact> artifacts = nativeHelper.getNativeDependenciesArtifacts(this.unpackedApkLibsDirectory, true);
        boolean bl = hasValidBuildNativeLibrariesDirectory = this.nativeLibrariesOutputDirectory.exists() && this.nativeLibrariesOutputDirectory.listFiles() != null && this.nativeLibrariesOutputDirectory.listFiles().length > 0;
        if (artifacts.isEmpty() && hasValidNativeLibrariesDirectory && !hasValidBuildNativeLibrariesDirectory) {
            this.getLog().debug((CharSequence)("No native library dependencies detected, will point directly to " + this.nativeLibrariesDirectory));
            natives.add(this.nativeLibrariesDirectory);
        } else if (!artifacts.isEmpty() || hasValidNativeLibrariesDirectory) {
            File destinationDirectory = new File(this.nativeLibrariesOutputDirectory.getAbsolutePath());
            destinationDirectory.mkdirs();
            natives.add(destinationDirectory);
            if (hasValidNativeLibrariesDirectory) {
                this.copyLocalNativeLibraries(this.nativeLibrariesDirectory, destinationDirectory);
            }
            if (hasValidBuildNativeLibrariesDirectory) {
                this.copyLocalNativeLibraries(this.nativeLibrariesOutputDirectory, destinationDirectory);
            }
            if (!artifacts.isEmpty()) {
                for (Artifact resolvedArtifact : artifacts) {
                    if ("so".equals(resolvedArtifact.getType())) {
                        File artifactFile = resolvedArtifact.getFile();
                        try {
                            String artifactId = resolvedArtifact.getArtifactId();
                            String filename = artifactId.startsWith("lib") ? artifactId + ".so" : "lib" + artifactId + ".so";
                            File finalDestinationDirectory = this.getFinalDestinationDirectoryFor(resolvedArtifact, destinationDirectory);
                            File file = new File(finalDestinationDirectory, filename);
                            this.getLog().debug((CharSequence)("Copying native dependency " + artifactId + " (" + resolvedArtifact.getGroupId() + ") to " + file));
                            FileUtils.copyFile((File)artifactFile, (File)file);
                            continue;
                        }
                        catch (Exception e) {
                            throw new MojoExecutionException("Could not copy native dependency.", e);
                        }
                    }
                    if (!"apklib".equals(resolvedArtifact.getType())) continue;
                    natives.add(new File(this.getLibraryUnpackDirectory(resolvedArtifact) + "/libs"));
                }
            }
        }
    }

    private File getFinalDestinationDirectoryFor(Artifact resolvedArtifact, File destinationDirectory) {
        String hardwareArchitecture = this.getHardwareArchitectureFor(resolvedArtifact);
        File finalDestinationDirectory = new File(destinationDirectory, hardwareArchitecture + "/");
        finalDestinationDirectory.mkdirs();
        return finalDestinationDirectory;
    }

    private String getHardwareArchitectureFor(Artifact resolvedArtifact) {
        if (StringUtils.isNotBlank((String)this.nativeLibrariesDependenciesHardwareArchitectureOverride)) {
            return this.nativeLibrariesDependenciesHardwareArchitectureOverride;
        }
        String classifier = resolvedArtifact.getClassifier();
        if (StringUtils.isNotBlank((String)classifier)) {
            return classifier;
        }
        return this.nativeLibrariesDependenciesHardwareArchitectureDefault;
    }

    private void copyLocalNativeLibraries(File localNativeLibrariesDirectory, File destinationDirectory) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Copying existing native libraries from " + localNativeLibrariesDirectory));
        try {
            FileUtils.copyDirectory((File)localNativeLibrariesDirectory, (File)destinationDirectory, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".so");
                }
            });
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not copy native libraries: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Could not copy native dependency.", (Exception)e);
        }
    }

    private void generateIntermediateAp_() throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        if (this.extractedDependenciesRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency resource files to combined resource directory.");
                if (!this.combinedRes.exists() && !this.combinedRes.mkdirs()) {
                    throw new MojoExecutionException("Could not create directory for combined resources at " + this.combinedRes.getAbsolutePath());
                }
                FileUtils.copyDirectory((File)this.extractedDependenciesRes, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.resourceDirectory.exists() && this.combinedRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.resourceDirectory, (File)this.combinedRes, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        for (String pattern : DirectoryScanner.DEFAULTEXCLUDES) {
                            if (!DirectoryScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            ApkMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from resource copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.extractedDependenciesAssets.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency assets files to combined assets directory.");
                FileUtils.copyDirectory((File)this.extractedDependenciesAssets, (File)this.combinedAssets, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        for (String pattern : AbstractScanner.DEFAULTEXCLUDES) {
                            if (!AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            ApkMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from asset copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>(this.getAllRelevantDependencyArtifacts());
        for (Artifact artifact : artifactList) {
            File apklibAsssetsDirectory;
            if (!artifact.getType().equals("apklib") || !(apklibAsssetsDirectory = new File(this.getLibraryUnpackDirectory(artifact) + "/assets")).exists()) continue;
            try {
                this.getLog().info((CharSequence)"Copying dependency assets files to combined assets directory.");
                FileUtils.copyDirectory((File)apklibAsssetsDirectory, (File)this.combinedAssets, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        for (String pattern : AbstractScanner.DEFAULTEXCLUDES) {
                            if (!AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            ApkMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from asset copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.assetsDirectory.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local assets files to combined assets directory.");
                FileUtils.copyDirectory((File)this.assetsDirectory, (File)this.combinedAssets, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        for (String pattern : AbstractScanner.DEFAULTEXCLUDES) {
                            if (!AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            ApkMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from asset copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        File androidJar = this.getAndroidSdk().getAndroidJar();
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-f");
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.combinedRes.exists()) {
            commands.add("-S");
            commands.add(this.combinedRes.getAbsolutePath());
        } else if (this.resourceDirectory.exists()) {
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String apkLibResDir;
            if (!artifact.getType().equals("apklib") || !new File(apkLibResDir = this.getLibraryUnpackDirectory(artifact) + "/res").exists()) continue;
            commands.add("-S");
            commands.add(apkLibResDir);
        }
        commands.add("--auto-add-overlay");
        if (this.combinedAssets.exists()) {
            commands.add("-A");
            commands.add(this.combinedAssets.getAbsolutePath());
        }
        if (StringUtils.isNotBlank((String)this.renameManifestPackage)) {
            commands.add("--rename-manifest-package");
            commands.add(this.renameManifestPackage);
        }
        if (StringUtils.isNotBlank((String)this.renameInstrumentationTargetPackage)) {
            commands.add("--rename-instrumentation-target-package");
            commands.add(this.renameInstrumentationTargetPackage);
        }
        commands.add("-I");
        commands.add(androidJar.getAbsolutePath());
        commands.add("-F");
        commands.add(outputFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        for (String aaptExtraArg : this.aaptExtraArgs) {
            commands.add(aaptExtraArg);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    protected AndroidSigner getAndroidSigner() {
        if (this.sign == null) {
            return new AndroidSigner(this.signDebug);
        }
        return new AndroidSigner(this.sign.getDebug());
    }
}

