/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal.js;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.HelperRegistry;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.internal.Files;
import wiremock.com.github.jknack.handlebars.js.HandlebarsJs;

public class RhinoHandlebars
extends HandlebarsJs {
    private int optimizationLevel = -1;
    private static final String HELPERS_ENV = RhinoHandlebars.envSource("/helpers.rhino.js");

    public RhinoHandlebars(HelperRegistry helperRegistry) {
        super(helperRegistry);
    }

    public RhinoHandlebars(HelperRegistry helperRegistry, int optimizationLevel) {
        super(helperRegistry);
        this.optimizationLevel = optimizationLevel;
    }

    public void registerHelper(String name, final JsHelper helper) {
        this.registry.registerHelper(name, new Helper<Object>(){

            @Override
            public Object apply(Object context, Options options) throws IOException {
                Object jsContext = RhinoHandlebars.toJsObject(options.context.model(), options.context);
                Object arg0 = context;
                Integer paramSize = (Integer)options.data(Context.PARAM_SIZE);
                arg0 = paramSize == 0 ? "___NOT_SET_" : RhinoHandlebars.toJsObject(arg0, options.context);
                Object result = helper.apply(jsContext, arg0, new OptionsJs(options));
                if (result instanceof NativeArray) {
                    return new BetterNativeArray((List)result, options.context);
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerHelpers(String filename, String source) throws Exception {
        org.mozilla.javascript.Context ctx = null;
        try {
            ctx = this.newContext();
            Scriptable sharedScope = this.helpersEnvScope(ctx);
            Scriptable scope = ctx.newObject(sharedScope);
            scope.setParentScope(null);
            scope.setPrototype(sharedScope);
            ctx.evaluateString(scope, source, filename, 1, null);
        }
        finally {
            if (ctx != null) {
                org.mozilla.javascript.Context.exit();
            }
        }
    }

    private org.mozilla.javascript.Context newContext() {
        org.mozilla.javascript.Context ctx = org.mozilla.javascript.Context.enter();
        ctx.setOptimizationLevel(this.optimizationLevel);
        ctx.setErrorReporter(new ToolErrorReporter(false));
        ctx.setLanguageVersion(180);
        return ctx;
    }

    private Scriptable helpersEnvScope(org.mozilla.javascript.Context ctx) {
        ScriptableObject env = ctx.initStandardObjects();
        env.put("Handlebars_java", (Scriptable)env, (Object)this);
        ctx.evaluateString(env, HELPERS_ENV, "helpers.rhino.js", 1, null);
        return env;
    }

    private static String envSource(String location) {
        try {
            return Files.read(location);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read " + location, ex);
        }
    }

    private static NativeObject hash(Map<?, Object> map, Context context) {
        BetterNativeObject hash = new BetterNativeObject(context);
        for (Map.Entry<?, Object> prop : map.entrySet()) {
            hash.defineProperty(prop.getKey().toString(), prop.getValue(), 1);
        }
        return hash;
    }

    private static Object toJsObject(Object object, Context parent) {
        if (object == null) {
            return null;
        }
        if (object == Scriptable.NOT_FOUND) {
            return Scriptable.NOT_FOUND;
        }
        if (object instanceof Number) {
            return object;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof CharSequence || object instanceof Character) {
            return object.toString();
        }
        if (Map.class.isInstance(object)) {
            return RhinoHandlebars.hash((Map)object, parent);
        }
        if (Collection.class.isInstance(object)) {
            return new BetterNativeArray((Collection)object, parent);
        }
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            return new BetterNativeArray(array, parent);
        }
        if (object instanceof NativeArray) {
            return new BetterNativeArray((NativeArray)object, parent);
        }
        if (object instanceof Scriptable) {
            return object;
        }
        Context context = object instanceof Context ? (Context)object : Context.newContext(parent, object);
        return RhinoHandlebars.toJsObject(context);
    }

    private static Object toJsObject(Context context) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        for (Map.Entry<String, Object> property : context.propertySet()) {
            hash.put(property.getKey(), property.getValue());
        }
        return RhinoHandlebars.hash(hash, context);
    }

    public static class OptionsJs {
        private Options options;
        public NativeObject hash;
        public NativeArray params;

        public OptionsJs(Options options) {
            this.options = options;
            this.hash = RhinoHandlebars.hash(options.hash, options.context);
            this.params = new BetterNativeArray(options.params, options.context);
        }

        public CharSequence fn(Object context) throws IOException {
            return this.options.fn(context);
        }

        public CharSequence fn() throws IOException {
            return this.options.fn();
        }

        public CharSequence inverse(Object context) throws IOException {
            return this.options.inverse(context);
        }

        public CharSequence inverse() throws IOException {
            return this.options.inverse();
        }
    }

    public static interface JsHelper {
        public Object apply(Object var1, Object var2, OptionsJs var3);
    }

    private static class BetterNativeObject
    extends NativeObject {
        private Context context;
        private Map<Object, Object> state = new HashMap<Object, Object>();

        public BetterNativeObject(Context context) {
            this.context = context;
        }

        @Override
        public Object get(String name, Scriptable start) {
            Object value = this.state.get(name);
            if (value != null) {
                return value;
            }
            value = super.get(name, start);
            value = RhinoHandlebars.toJsObject(value, this.context);
            this.state.put(name, value);
            return value;
        }
    }

    private static class BetterNativeArray
    extends NativeArray {
        private Context context;
        private Map<Object, Object> state = new HashMap<Object, Object>();

        public BetterNativeArray(Object[] array, Context context) {
            super(array);
            this.context = context;
        }

        public BetterNativeArray(Collection<Object> collection, Context context) {
            this(collection.toArray(new Object[collection.size()]), context);
        }

        @Override
        public Object get(int index, Scriptable start) {
            Object value = this.state.get(index);
            if (value != null) {
                return value;
            }
            value = super.get(index, start);
            value = RhinoHandlebars.toJsObject(value, this.context);
            this.state.put(index, value);
            return value;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            String sep = ",";
            for (Object v : this) {
                buff.append(v).append(sep);
            }
            if (buff.length() > 0) {
                buff.setLength(buff.length() - sep.length());
            }
            return buff.toString();
        }
    }
}

