/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.server;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.CreatesManualRunner;
import com.github.searls.jasmine.NullLog;
import com.github.searls.jasmine.coffee.DetectsCoffee;
import com.github.searls.jasmine.coffee.HandlesRequestsForCoffee;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;

public class JasmineResourceHandler
extends ResourceHandler {
    private DetectsCoffee detectsCoffee = new DetectsCoffee();
    private HandlesRequestsForCoffee handlesRequestsForCoffee = new HandlesRequestsForCoffee();
    private CreatesManualRunner createsManualRunner;

    public JasmineResourceHandler(AbstractJasmineMojo config) {
        this.createsManualRunner = new CreatesManualRunner(config);
        this.createsManualRunner.setLog(new NullLog());
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.createManualSpecRunnerIfNecessary(target);
        Resource resource = this.getResource((HttpServletRequest)baseRequest);
        response.addDateHeader("EXPIRES", 0L);
        if (this.detectsCoffee.detect(target) && this.weCanHandleIt(baseRequest, resource)) {
            this.handlesRequestsForCoffee.handle(baseRequest, response, resource);
        } else {
            super.handle(target, baseRequest, (HttpServletRequest)baseRequest, response);
        }
    }

    private void createManualSpecRunnerIfNecessary(String target) throws IOException {
        if ("/".equals(target)) {
            this.createsManualRunner.create();
        }
    }

    private boolean weCanHandleIt(Request baseRequest, Resource resource) {
        return !baseRequest.isHandled() && resource != null && resource.exists();
    }
}

