/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.io.FileUtilsWrapper;
import com.github.searls.jasmine.io.IOUtilsWrapper;
import com.github.searls.jasmine.io.scripts.ScriptResolver;
import com.github.searls.jasmine.runner.ReporterType;
import java.io.File;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlGeneratorConfiguration {
    private final String sourceEncoding;
    private final ReporterType reporterType;
    private final File customRunnerTemplate;
    private FileUtilsWrapper fileUtilsWrapper;
    private IOUtilsWrapper ioUtilsWrapper;
    private String specRunnerTemplate;
    private ScriptResolver scriptResolver;
    private String sourceDirectoryRelativePath;
    private String scriptLoaderPath;
    private File customRunnerConfiguration;

    public HtmlGeneratorConfiguration(ReporterType reporterType, AbstractJasmineMojo configuration, ScriptResolver scriptResolver) throws IOException {
        scriptResolver.resolveScripts();
        this.sourceEncoding = configuration.getSourceEncoding();
        this.reporterType = reporterType;
        this.customRunnerTemplate = configuration.getCustomRunnerTemplate();
        this.specRunnerTemplate = configuration.getSpecRunnerTemplate();
        this.scriptResolver = scriptResolver;
        this.customRunnerConfiguration = configuration.getCustomRunnerConfiguration();
        this.fileUtilsWrapper = new FileUtilsWrapper();
        this.ioUtilsWrapper = new IOUtilsWrapper();
        this.scriptLoaderPath = configuration.getScriptLoaderPath();
    }

    public Set<String> getAllScripts() throws IOException {
        return this.scriptResolver.getAllScripts();
    }

    public Set<String> getAllScriptsRelativePath() throws IOException {
        return this.scriptResolver.getAllScriptsRelativePath();
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public ReporterType getReporterType() {
        return this.reporterType;
    }

    public File getCustomRunnerTemplate() {
        return this.customRunnerTemplate;
    }

    public String readFileToString(File customRunnerTemplate) throws IOException {
        return this.fileUtilsWrapper.readFileToString(customRunnerTemplate);
    }

    public String IOtoString(String defaultHtmlTemplatePath) throws IOException {
        return this.ioUtilsWrapper.toString(defaultHtmlTemplatePath);
    }

    public String getRunnerTemplate(String defaultHtmlTemplatePath) throws IOException {
        if (null != this.getCustomRunnerTemplate()) {
            return this.readFileToString(this.getCustomRunnerTemplate());
        }
        return this.IOtoString(defaultHtmlTemplatePath);
    }

    public String getSpecRunnerTemplate() {
        return this.specRunnerTemplate;
    }

    public Set<String> getSpecs() throws IOException {
        return this.scriptResolver.getSpecs();
    }

    public String getSourceDirectory() throws IOException {
        return this.scriptResolver.getSourceDirectory();
    }

    public Set<String> getPreloads() {
        return this.scriptResolver.getPreloads();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlGeneratorConfiguration that = (HtmlGeneratorConfiguration)o;
        if (this.customRunnerTemplate != null ? !this.customRunnerTemplate.equals(that.customRunnerTemplate) : that.customRunnerTemplate != null) {
            return false;
        }
        if (this.reporterType != that.reporterType) {
            return false;
        }
        if (this.sourceEncoding != null ? !this.sourceEncoding.equals(that.sourceEncoding) : that.sourceEncoding != null) {
            return false;
        }
        return !(this.specRunnerTemplate != null ? !this.specRunnerTemplate.equals(that.specRunnerTemplate) : that.specRunnerTemplate != null);
    }

    public int hashCode() {
        int result = this.sourceEncoding != null ? this.sourceEncoding.hashCode() : 0;
        result = 31 * result + (this.reporterType != null ? this.reporterType.hashCode() : 0);
        result = 31 * result + (this.customRunnerTemplate != null ? this.customRunnerTemplate.hashCode() : 0);
        result = 31 * result + (this.specRunnerTemplate != null ? this.specRunnerTemplate.hashCode() : 0);
        return result;
    }

    public Set<String> getSpecsRelativePath() throws IOException {
        return this.scriptResolver.getSpecsRelativePath();
    }

    public String getSourceDirectoryRelativePath() throws IOException {
        return this.scriptResolver.getSourceDirectoryRelativePath();
    }

    public Set<String> getPreloadsRelativePath() throws IOException {
        return this.scriptResolver.getPreloadsRelativePath();
    }

    public String getCustomRunnerConfiguration() throws IOException {
        if (null != this.customRunnerConfiguration) {
            return this.fileUtilsWrapper.readFileToString(this.customRunnerConfiguration);
        }
        return null;
    }

    public void setFileUtilsWrapper(FileUtilsWrapper fileUtilsWrapper) {
        this.fileUtilsWrapper = fileUtilsWrapper;
    }

    public void setIoUtilsWrapper(IOUtilsWrapper ioUtilsWrapper) {
        this.ioUtilsWrapper = ioUtilsWrapper;
    }

    public String getScriptLoaderPath() {
        return this.scriptLoaderPath;
    }
}

