/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.WebClient;
import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.format.JasmineResultLogger;
import com.github.searls.jasmine.io.scripts.TargetDirScriptResolver;
import com.github.searls.jasmine.model.JasmineResult;
import com.github.searls.jasmine.runner.ReporterType;
import com.github.searls.jasmine.runner.SpecRunnerExecutor;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGeneratorFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class TestMojo
extends AbstractJasmineMojo {
    public void run() throws Exception {
        if (!this.skipTests) {
            this.getLog().info((CharSequence)"Executing Jasmine Specs");
            File runnerFile = this.writeSpecRunnerToOutputDirectory();
            JasmineResult result = this.executeSpecs(runnerFile);
            this.logResults(result);
            this.throwAnySpecFailures(result);
        } else {
            this.getLog().info((CharSequence)"Skipping Jasmine Specs");
        }
    }

    private File writeSpecRunnerToOutputDirectory() throws IOException {
        SpecRunnerHtmlGenerator generator = new SpecRunnerHtmlGeneratorFactory().create(ReporterType.JsApiReporter, this, new TargetDirScriptResolver(this));
        String html = generator.generate();
        this.getLog().debug((CharSequence)("Writing out Spec Runner HTML " + html + " to directory " + this.jasmineTargetDir));
        File runnerFile = new File(this.jasmineTargetDir, this.specRunnerHtmlFileName);
        FileUtils.writeStringToFile((File)runnerFile, (String)html);
        return runnerFile;
    }

    private JasmineResult executeSpecs(File runnerFile) throws MalformedURLException {
        WebDriver driver = this.createDriver();
        JasmineResult result = new SpecRunnerExecutor().execute(runnerFile.toURI().toURL(), new File(this.jasmineTargetDir, this.junitXmlReportFileName), driver, this.timeout, this.debug, this.getLog(), this.format);
        return result;
    }

    private WebDriver createDriver() {
        BrowserVersion htmlUnitBrowserVersion;
        if (!HtmlUnitDriver.class.getName().equals(this.webDriverClassName)) {
            try {
                Class<?> klass = Class.forName(this.webDriverClassName);
                Constructor<?> ctor = klass.getConstructor(new Class[0]);
                return (WebDriver)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't instantiate webDriverClassName", e);
            }
        }
        try {
            htmlUnitBrowserVersion = (BrowserVersion)BrowserVersion.class.getField(this.browserVersion).get(BrowserVersion.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HtmlUnitDriver driver = new HtmlUnitDriver(htmlUnitBrowserVersion){

            protected WebClient modifyWebClient(WebClient client) {
                client.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
                if (!TestMojo.this.debug) {
                    client.setIncorrectnessListener(new IncorrectnessListener(){

                        public void notify(String arg0, Object arg1) {
                        }
                    });
                }
                return client;
            }
        };
        driver.setJavascriptEnabled(true);
        return driver;
    }

    private void logResults(JasmineResult result) {
        JasmineResultLogger resultLogger = new JasmineResultLogger();
        resultLogger.setLog(this.getLog());
        resultLogger.log(result);
    }

    private void throwAnySpecFailures(JasmineResult result) throws MojoFailureException {
        if (this.haltOnFailure && !result.didPass()) {
            throw new MojoFailureException("There were Jasmine spec failures.");
        }
    }
}

