/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine;

import com.github.searls.jasmine.AbstractJasmineMojo;
import com.github.searls.jasmine.ResourceHandlerConfigurator;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

public class ServerMojo
extends AbstractJasmineMojo {
    public static final String INSTRUCTION_FORMAT = "\n\nServer started--it's time to spec some JavaScript! You can run your specs as you develop by visiting this URL in a web browser: \n\n  http://localhost:%s\n\nThe server will monitor these two directories for scripts that you add, remove, and change:\n\n  source directory: %s\n\n  spec directory: %s\n\nJust leave this process running as you test-drive your code, refreshing your browser window to re-run your specs. You can kill the server with Ctrl-C when you're done.";
    private Server server = new Server();
    private RelativizesFilePaths relativizesFilePaths = new RelativizesFilePaths();

    public void run() throws Exception {
        this.addConnectorToServer();
        this.addHandlersToServer();
        this.startServer();
    }

    private void addHandlersToServer() throws IOException {
        this.server.setHandler(new ResourceHandlerConfigurator(this, this.relativizesFilePaths).createHandler(this.specRunnerTemplate));
    }

    private void addConnectorToServer() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.serverPort);
        this.server.addConnector((Connector)connector);
    }

    private void startServer() throws Exception {
        this.server.start();
        this.getLog().info((CharSequence)this.buildServerInstructions());
        this.server.join();
    }

    private String buildServerInstructions() throws IOException {
        return String.format(INSTRUCTION_FORMAT, this.serverPort, this.relativizesFilePaths.relativize(this.mavenProject.getBasedir(), this.sources.getDirectory()), this.relativizesFilePaths.relativize(this.mavenProject.getBasedir(), this.specs.getDirectory()));
    }
}

