/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.matchers.util;

import com.google.common.base.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HamcrestConverter<T, U> {
    private final Function<U, T> converter;

    public HamcrestConverter(Function<U, T> converter) {
        this.converter = converter;
    }

    public TypeSafeMatcher<U> convert(Matcher<T> matcher) {
        return new ConverterMatcher<T, U>(matcher, this.converter);
    }

    private static class ConverterMatcher<V, W>
    extends TypeSafeMatcher<W> {
        private final Matcher<V> matcher;
        private final Function<W, V> converter;

        public ConverterMatcher(Matcher<V> matcher, Function<W, V> converter) {
            this.matcher = matcher;
            this.converter = converter;
        }

        protected boolean matchesSafely(W item) {
            return this.matcher.matches(this.converter.apply(item));
        }

        public void describeTo(Description description) {
            this.matcher.describeTo(description);
        }
    }
}

