/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.matchers;

import com.github.restdriver.exception.RuntimeAssertionFailure;
import java.io.IOException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.xml.sax.SAXException;

public class IsEquivalentXml
extends TypeSafeMatcher<String> {
    private final String xml;

    public IsEquivalentXml(String xml) {
        this.xml = xml;
    }

    public final void describeTo(Description description) {
        description.appendText("A string with XML equivalent to: " + this.xml);
    }

    protected boolean matchesSafely(String item) {
        try {
            Diff diff = XMLUnit.compareXML((String)this.xml, (String)item);
            return diff.identical();
        }
        catch (IOException e) {
            throw new RuntimeAssertionFailure("Failed to compare XML", e);
        }
        catch (SAXException e) {
            throw new RuntimeAssertionFailure("Failed to compare XML", e);
        }
    }
}

