/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.matchers;

import com.fasterxml.jackson.databind.JsonNode;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class HasJsonValue
extends TypeSafeMatcher<JsonNode> {
    private final String fieldName;
    private final Matcher<?> valueMatcher;

    public HasJsonValue(String fieldName, Matcher<?> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("JsonNode with '" + this.fieldName + "' matching: ");
        this.valueMatcher.describeTo(description);
    }

    public boolean matchesSafely(JsonNode jsonNode) {
        JsonNode node = jsonNode.get(this.fieldName);
        if (node == null) {
            return false;
        }
        if (node.isInt()) {
            return this.valueMatcher.matches((Object)node.intValue());
        }
        if (node.isLong()) {
            return this.valueMatcher.matches((Object)node.longValue());
        }
        if (node.isTextual()) {
            return this.valueMatcher.matches((Object)node.textValue());
        }
        if (node.isBoolean()) {
            return this.valueMatcher.matches((Object)node.booleanValue());
        }
        if (node.isDouble()) {
            return this.valueMatcher.matches((Object)node.doubleValue());
        }
        if (node.isObject()) {
            return this.valueMatcher.matches((Object)node);
        }
        if (node.isNull()) {
            return this.valueMatcher.matches(null);
        }
        return false;
    }
}

