/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.restdriver.matchers.HasJsonPath;
import com.github.restdriver.matchers.HasJsonWhich;
import com.github.restdriver.matchers.IsEquivalentXml;
import com.github.restdriver.matchers.MatchesRegex;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class Matchers {
    private Matchers() {
    }

    public static MatchesRegex matchingRegex(String pattern) {
        return new MatchesRegex(Pattern.compile(pattern));
    }

    public static MatchesRegex matchingRegex(Pattern pattern) {
        return new MatchesRegex(pattern);
    }

    public static IsEquivalentXml equivalentXmlTo(String xml) {
        return new IsEquivalentXml(xml);
    }

    public static HasJsonWhich hasJsonWhich(Matcher<JsonNode> matcher) {
        return new HasJsonWhich(matcher);
    }

    public static <T> TypeSafeMatcher<JsonNode> hasJsonPath(String jsonPath) {
        return new HasJsonPath(jsonPath);
    }

    public static <T> TypeSafeMatcher<JsonNode> hasJsonPath(String jsonPath, Matcher<T> matcher) {
        return new HasJsonPath<T>(jsonPath, matcher);
    }
}

