/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.mavanagaiata;

import com.github.koraktor.mavanagaiata.AbstractGitMojo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

public class GitTagMojo
extends AbstractGitMojo {
    private RevWalk revWalk;
    private String tag;
    private Map<RevCommit, String> tagCommits;

    public void run() throws MojoExecutionException {
        try {
            int distance;
            this.tag = null;
            RevCommit head = this.getHead();
            this.revWalk = new RevWalk(this.repository);
            Map tags = this.repository.getTags();
            this.tagCommits = new HashMap<RevCommit, String>();
            for (Map.Entry tag : tags.entrySet()) {
                try {
                    RevTag revTag = this.revWalk.parseTag((AnyObjectId)((Ref)tag.getValue()).getObjectId());
                    RevObject object = this.revWalk.peel((RevObject)revTag);
                    if (!(object instanceof RevCommit)) continue;
                    this.tagCommits.put((RevCommit)object, (String)tag.getKey());
                }
                catch (IncorrectObjectTypeException e) {}
            }
            String abbrevId = this.repository.getObjectDatabase().newReader().abbreviate((AnyObjectId)head).name();
            if (this.tagCommits.isEmpty() || (distance = this.walkCommits(head, 0)) < 0) {
                this.addProperty("tag.describe", abbrevId);
                this.addProperty("tag.name", "");
            } else {
                this.addProperty("tag.name", this.tag);
                String tagDescribe = this.tag;
                if (distance > 0) {
                    tagDescribe = tagDescribe + "-" + distance + "-g" + abbrevId;
                }
                if (this.isDirty()) {
                    tagDescribe = tagDescribe + this.dirtyFlag;
                }
                this.addProperty("tag.describe", tagDescribe);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read Git tag", (Exception)e);
        }
    }

    private boolean isTagged(RevCommit commit) {
        if (this.tagCommits.containsKey(commit)) {
            this.tag = this.tagCommits.get(commit);
            return true;
        }
        return false;
    }

    private int walkCommits(RevCommit commit, int distance) throws IOException {
        if (this.isTagged(commit = (RevCommit)this.revWalk.peel((RevObject)commit))) {
            return distance;
        }
        int currentDistance = -1;
        for (RevCommit parent : commit.getParents()) {
            int tagDistance = this.walkCommits(parent, distance + 1);
            if (currentDistance == -1) {
                currentDistance = tagDistance;
                continue;
            }
            if (-1 >= tagDistance || tagDistance >= currentDistance) continue;
            currentDistance = tagDistance;
        }
        return currentDistance;
    }
}

