/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.mavanagaiata;

import com.github.koraktor.mavanagaiata.AbstractGitOutputMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class GitContributorsMojo
extends AbstractGitOutputMojo {
    protected String contributorPrefix = " * ";
    protected String header = "Contributors\n============\n";
    protected File outputFile;
    protected boolean showCounts = true;
    protected boolean showEmail = false;
    protected String sort;

    public void run() throws MojoExecutionException {
        this.contributorPrefix = this.contributorPrefix.replaceAll("([^\\\\])\\\\n", "$1\n");
        this.header = this.header.replaceAll("([^\\\\])\\\\n", "$1\n");
        try {
            RevCommit tempCommit;
            RevWalk revWalk = new RevWalk(this.repository);
            revWalk.markStart(this.getHead());
            ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            while ((tempCommit = revWalk.next()) != null) {
                commits.add(tempCommit);
            }
            if (this.sort == null) {
                this.sort = "count";
            } else {
                this.sort = this.sort.toLowerCase();
                if (!this.sort.equals("date") && !this.sort.equals("name")) {
                    this.sort = "count";
                }
            }
            final HashMap<String, Integer> counts = new HashMap<String, Integer>();
            if (this.showCounts || this.sort.equals("count")) {
                for (RevCommit commit : commits) {
                    String emailAddress = commit.getAuthorIdent().getEmailAddress();
                    if (!counts.containsKey(emailAddress)) {
                        counts.put(emailAddress, 1);
                        continue;
                    }
                    counts.put(emailAddress, (Integer)counts.get(emailAddress) + 1);
                }
            }
            if (this.sort.equals("date")) {
                Collections.reverse(commits);
            } else if (this.sort.equals("name")) {
                Collections.sort(commits, new Comparator<RevCommit>(){

                    @Override
                    public int compare(RevCommit c1, RevCommit c2) {
                        String a1 = c1.getAuthorIdent().getName();
                        String a2 = c2.getAuthorIdent().getName();
                        return a1.compareTo(a2);
                    }
                });
            } else {
                Collections.sort(commits, new Comparator<RevCommit>(){

                    @Override
                    public int compare(RevCommit c1, RevCommit c2) {
                        Integer count1 = (Integer)counts.get(c1.getAuthorIdent().getEmailAddress());
                        Integer count2 = (Integer)counts.get(c1.getAuthorIdent().getEmailAddress());
                        return count1.compareTo(count2);
                    }
                });
            }
            final LinkedHashMap<String, String> contributors = new LinkedHashMap<String, String>();
            for (RevCommit commit : commits) {
                PersonIdent author = commit.getAuthorIdent();
                String emailAddress = author.getEmailAddress();
                if (contributors.containsKey(emailAddress)) continue;
                contributors.put(emailAddress, author.getName());
            }
            ArrayList emailAddresses = new ArrayList(contributors.keySet());
            if (!this.sort.equals("date")) {
                if (this.sort.equals("name")) {
                    Collections.sort(emailAddresses, new Comparator<String>(){

                        @Override
                        public int compare(String e1, String e2) {
                            String n1 = (String)contributors.get(e1);
                            String n2 = (String)contributors.get(e2);
                            return n1.compareTo(n2);
                        }
                    });
                } else {
                    Collections.sort(emailAddresses, new Comparator<String>(){

                        @Override
                        public int compare(String e1, String e2) {
                            Integer count1 = (Integer)counts.get(e1);
                            Integer count2 = (Integer)counts.get(e2);
                            return count2.compareTo(count1);
                        }
                    });
                }
            }
            this.outputStream.println(this.header);
            for (String emailAddress : emailAddresses) {
                this.outputStream.print(this.contributorPrefix + (String)contributors.get(emailAddress));
                if (this.showEmail) {
                    this.outputStream.print(" (" + emailAddress + ")");
                }
                if (this.showCounts) {
                    this.outputStream.print(" (" + counts.get(emailAddress) + ")");
                }
                this.outputStream.println();
            }
            this.insertFooter();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read contributors from Git", (Exception)e);
        }
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

