/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.mavanagaiata;

import com.github.koraktor.mavanagaiata.AbstractGitMojo;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitCommitMojo
extends AbstractGitMojo {
    protected String dateFormat;

    public GitCommitMojo() {
        this.dateFormat = this.baseDateFormat;
    }

    public void run() throws MojoExecutionException {
        try {
            RevCommit commit = this.getHead();
            String abbrevId = this.repository.getObjectDatabase().newReader().abbreviate((AnyObjectId)commit).name();
            PersonIdent author = commit.getAuthorIdent();
            PersonIdent committer = commit.getCommitterIdent();
            String shaId = commit.getName();
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFormat);
            dateFormat.setTimeZone(author.getTimeZone());
            String authorDate = dateFormat.format(author.getWhen());
            dateFormat.setTimeZone(author.getTimeZone());
            String commitDate = dateFormat.format(committer.getWhen());
            if (this.isDirty()) {
                abbrevId = abbrevId + this.dirtyFlag;
                shaId = shaId + this.dirtyFlag;
            }
            this.addProperty("commit.abbrev", abbrevId);
            this.addProperty("commit.author.date", authorDate);
            this.addProperty("commit.author.name", author.getName());
            this.addProperty("commit.author.email", author.getEmailAddress());
            this.addProperty("commit.committer.date", commitDate);
            this.addProperty("commit.committer.name", committer.getName());
            this.addProperty("commit.committer.email", committer.getEmailAddress());
            this.addProperty("commit.id", shaId);
            this.addProperty("commit.sha", shaId);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read Git commit information", (Exception)e);
        }
    }
}

