/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.mavanagaiata;

import com.github.koraktor.mavanagaiata.AbstractGitOutputMojo;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

public class GitChangelogMojo
extends AbstractGitOutputMojo {
    protected boolean createGitHubLinks = false;
    protected String commitPrefix = " * ";
    protected String dateFormat = this.baseDateFormat;
    protected String gitHubProject;
    protected String gitHubUser;
    protected String header = "Changelog\n=========\n";
    protected File outputFile;
    protected boolean skipTagged = false;
    protected String tagPrefix = "\nVersion ";

    public void run() throws MojoExecutionException {
        try {
            RevCommit commit;
            RevWalk revWalk = new RevWalk(this.repository);
            Map tagRefs = this.repository.getTags();
            HashMap<String, RevTag> tags = new HashMap<String, RevTag>();
            for (Map.Entry tag : tagRefs.entrySet()) {
                try {
                    RevTag revTag = revWalk.parseTag((AnyObjectId)((Ref)tag.getValue()).getObjectId());
                    RevObject object = revWalk.peel((RevObject)revTag);
                    if (!(object instanceof RevCommit)) continue;
                    tags.put(object.getName(), revTag);
                }
                catch (IncorrectObjectTypeException e) {}
            }
            revWalk.markStart(this.getHead());
            this.outputStream.println(this.header);
            String branch = this.repository.getBranch();
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFormat);
            RevTag currentTag = null;
            boolean firstCommit = true;
            while ((commit = revWalk.next()) != null) {
                if (tags.containsKey(commit.getName())) {
                    RevTag lastTag = currentTag;
                    currentTag = (RevTag)tags.get(commit.getName());
                    if (lastTag == null) {
                        this.insertGitHubLink(currentTag, branch);
                    } else {
                        this.insertGitHubLink(currentTag, lastTag);
                    }
                    PersonIdent taggerIdent = currentTag.getTaggerIdent();
                    dateFormat.setTimeZone(taggerIdent.getTimeZone());
                    String dateString = dateFormat.format(taggerIdent.getWhen());
                    this.outputStream.println(this.tagPrefix + currentTag.getTagName() + " - " + dateString + "\n");
                    if (this.skipTagged) {
                        firstCommit = false;
                        continue;
                    }
                } else if (firstCommit) {
                    this.outputStream.println("Commits on branch \"" + branch + "\"\n");
                }
                this.outputStream.println(this.commitPrefix + commit.getShortMessage());
                firstCommit = false;
            }
            if (currentTag == null) {
                this.insertGitHubLink(branch, null);
            } else {
                this.insertGitHubLink(currentTag, null);
            }
            this.insertFooter();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to generate changelog from Git", (Exception)e);
        }
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    protected void init() throws MojoExecutionException {
        this.commitPrefix = this.commitPrefix.replaceAll("([^\\\\])\\\\n", "$1\n");
        this.header = this.header.replaceAll("([^\\\\])\\\\n", "$1\n");
        this.tagPrefix = this.tagPrefix.replaceAll("([^\\\\])\\\\n", "$1\n");
        if (this.gitHubProject == null || this.gitHubProject.length() == 0 || this.gitHubUser == null || this.gitHubUser.length() == 0) {
            this.createGitHubLinks = false;
        }
        super.init();
    }

    private void insertGitHubLink(Object lastRef, Object currentRef) {
        if (this.createGitHubLinks) {
            boolean isBranch;
            if (currentRef == null) {
                isBranch = lastRef instanceof String;
            } else {
                isBranch = currentRef instanceof String;
                if (!isBranch) {
                    currentRef = ((RevTag)currentRef).getTagName();
                }
            }
            if (lastRef instanceof RevTag) {
                lastRef = ((RevTag)lastRef).getTagName();
            }
            String url = String.format("https://github.com/%s/%s/", this.gitHubUser, this.gitHubProject);
            url = currentRef == null ? url + String.format("commits/%s", lastRef) : url + String.format("compare/%s...%s", lastRef, currentRef);
            String text = "See Git history for ";
            text = currentRef != null ? (isBranch ? text + "changes in the \"" + currentRef + "\" branch since version " + lastRef : text + "version " + currentRef) : (isBranch ? text + "changes in the \"" + lastRef + "\" branch" : text + "version " + lastRef);
            text = text + " at: ";
            this.outputStream.println("\n" + text + url);
        }
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

