/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.mavanagaiata;

import com.github.koraktor.mavanagaiata.AbstractGitMojo;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractGitOutputMojo
extends AbstractGitMojo {
    protected String encoding = "UTF-8";
    protected String footer = "\nGenerated by Mavanagaiata at %s";
    protected PrintStream outputStream;

    protected void cleanup() {
        if (this.outputStream != null) {
            this.outputStream.flush();
            if (this.getOutputFile() != null) {
                this.outputStream.close();
            }
        }
        super.cleanup();
    }

    protected void init() throws MojoExecutionException {
        this.initOutputStream();
        super.init();
    }

    protected void initOutputStream() throws MojoExecutionException {
        if (this.getOutputFile() == null) {
            this.outputStream = System.out;
        } else {
            try {
                if (!this.getOutputFile().getParentFile().exists()) {
                    this.getOutputFile().getParentFile().mkdirs();
                }
                this.outputStream = new PrintStream(this.getOutputFile(), this.encoding);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not initialize output file.", (Exception)e);
            }
        }
    }

    protected void insertFooter() {
        if (this.footer.length() > 0) {
            SimpleDateFormat baseDateFormat = new SimpleDateFormat(this.baseDateFormat);
            this.outputStream.println(String.format(this.footer, baseDateFormat.format(new Date())));
        }
    }

    public abstract File getOutputFile();

    public abstract void setOutputFile(File var1);
}

