/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.mavanagaiata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public abstract class AbstractGitMojo
extends AbstractMojo {
    protected String baseDateFormat = "MM/dd/yyyy hh:mm a Z";
    protected File baseDir;
    protected String dirtyFlag = "-dirty";
    protected File gitDir;
    protected String head = "HEAD";
    protected MavenProject project;
    protected String[] propertyPrefixes = new String[]{"mavanagaiata", "mvngit"};
    protected Repository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException {
        try {
            this.init();
            this.run();
        }
        finally {
            this.cleanup();
        }
    }

    protected void addProperty(String name, String value) {
        Properties properties = this.project.getProperties();
        for (String prefix : this.propertyPrefixes) {
            properties.put(prefix + "." + name, value);
        }
    }

    protected void cleanup() {
        if (this.repository != null) {
            this.repository.close();
            this.repository = null;
        }
    }

    protected void init() throws MojoExecutionException {
        try {
            this.initRepository();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to initialize Mojo", (Exception)e);
        }
    }

    protected void initRepository() throws IOException, MojoExecutionException {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        repositoryBuilder.readEnvironment();
        if (this.gitDir == null && this.baseDir == null) {
            throw new MojoExecutionException("Neither baseDir nor gitDir is set.");
        }
        if (this.baseDir != null && !this.baseDir.exists()) {
            throw new FileNotFoundException("The baseDir " + this.baseDir + " does not exist");
        }
        if (this.gitDir != null && !this.gitDir.exists()) {
            throw new FileNotFoundException("The gitDir " + this.gitDir + " does not exist");
        }
        repositoryBuilder.setGitDir(this.gitDir);
        repositoryBuilder.setWorkTree(this.baseDir);
        this.repository = repositoryBuilder.build();
        if (!this.repository.getObjectDatabase().exists()) {
            File path = this.baseDir == null ? this.gitDir : this.baseDir;
            throw new FileNotFoundException(path + " is not a Git repository");
        }
    }

    protected boolean isDirty() throws IOException, MojoExecutionException {
        FileTreeIterator workTreeIterator = new FileTreeIterator(this.repository);
        IndexDiff indexDiff = new IndexDiff(this.repository, this.repository.resolve(this.head), (WorkingTreeIterator)workTreeIterator);
        indexDiff.diff();
        return !new Status(indexDiff).isClean();
    }

    protected RevCommit getHead() throws IOException, MojoExecutionException {
        RevWalk revWalk = new RevWalk(this.repository);
        ObjectId head = this.repository.resolve(this.head);
        return revWalk.parseCommit((AnyObjectId)head);
    }

    protected abstract void run() throws MojoExecutionException;
}

