/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.binding;

import com.dangdang.ddframe.rdb.sharding.api.rule.BindingTableRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.router.binding.BindingRoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleTableRouter;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingTablesRouter {
    private static final Logger log = LoggerFactory.getLogger(BindingTablesRouter.class);
    private final ShardingRule shardingRule;
    private final Collection<String> logicTables;
    private final ConditionContext conditionContext;
    private final BindingTableRule bindingTableRule;
    private final SQLStatementType sqlStatementType;

    public BindingTablesRouter(ShardingRule shardingRule, Collection<String> logicTables, ConditionContext conditionContext, SQLStatementType sqlStatementType) {
        this.shardingRule = shardingRule;
        this.logicTables = logicTables;
        this.conditionContext = conditionContext;
        this.sqlStatementType = sqlStatementType;
        Optional<BindingTableRule> optionalBindingTableRule = shardingRule.findBindingTableRule(logicTables.iterator().next());
        Preconditions.checkState((boolean)optionalBindingTableRule.isPresent());
        this.bindingTableRule = (BindingTableRule)optionalBindingTableRule.get();
    }

    public BindingRoutingResult route() {
        BindingRoutingResult result = null;
        for (String each : this.logicTables) {
            if (null == result) {
                result = new BindingRoutingResult(new SingleTableRouter(this.shardingRule, each, this.conditionContext, this.sqlStatementType).route());
                continue;
            }
            result.bind(this.bindingTableRule, each);
        }
        log.trace("binding table sharding result: {}", result);
        return result;
    }
}

