/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row;

import com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling.aggregation.AggregationUnit;
import com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling.aggregation.AggregationUnitFactory;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.AbstractResultSetRow;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.AggregationColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.GroupByColumn;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class GroupByResultSetRow
extends AbstractResultSetRow {
    private final ResultSet resultSet;
    private final List<GroupByColumn> groupByColumns;
    private final Map<AggregationColumn, AggregationUnit> aggregationUnitMap;

    public GroupByResultSetRow(ResultSet resultSet, List<GroupByColumn> groupByColumns, List<AggregationColumn> aggregationColumns) throws SQLException {
        super(resultSet);
        this.resultSet = resultSet;
        this.groupByColumns = groupByColumns;
        this.aggregationUnitMap = Maps.toMap(aggregationColumns, (Function)new Function<AggregationColumn, AggregationUnit>(){

            public AggregationUnit apply(AggregationColumn input) {
                return AggregationUnitFactory.create(input.getAggregationType());
            }
        });
    }

    public void aggregate() throws SQLException {
        for (Map.Entry<AggregationColumn, AggregationUnit> each : this.aggregationUnitMap.entrySet()) {
            each.getValue().merge(this.getAggregationValues(each.getKey().getDerivedColumns().isEmpty() ? Collections.singletonList(each.getKey()) : each.getKey().getDerivedColumns()));
        }
    }

    private List<Comparable<?>> getAggregationValues(List<AggregationColumn> aggregationColumns) throws SQLException {
        ArrayList result = new ArrayList(aggregationColumns.size());
        for (AggregationColumn each : aggregationColumns) {
            result.add((Comparable)this.resultSet.getObject(each.getColumnIndex()));
        }
        return result;
    }

    public void generateResult() {
        for (AggregationColumn each : this.aggregationUnitMap.keySet()) {
            this.setCell(each.getColumnIndex(), this.aggregationUnitMap.get(each).getResult());
        }
    }

    public List<Object> getGroupByValues() throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(this.groupByColumns.size());
        for (GroupByColumn each : this.groupByColumns) {
            result.add(this.resultSet.getObject(each.getColumnIndex()));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("GroupByKey is: ");
        result.append(Lists.transform(this.groupByColumns, (Function)new Function<GroupByColumn, Object>(){

            public Object apply(GroupByColumn input) {
                return GroupByResultSetRow.this.getCell(input.getColumnIndex());
            }
        }));
        if (this.aggregationUnitMap.isEmpty()) {
            return result.toString();
        }
        result.append("; Aggregation result is: ").append(Lists.transform(new ArrayList<AggregationColumn>(this.aggregationUnitMap.keySet()), (Function)new Function<AggregationColumn, String>(){

            public String apply(AggregationColumn input) {
                Object value = GroupByResultSetRow.this.getCell(input.getColumnIndex());
                value = null == value ? "null" : value;
                return String.format("{index:%d, type:%s, value:%s}", new Object[]{input.getColumnIndex(), input.getAggregationType(), value});
            }
        }));
        return result.toString();
    }
}

