/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.dangdang.ddframe.rdb.sharding.executor.PreparedStatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.PreparedStatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.jdbc.BackendPreparedStatementWrapper;
import com.dangdang.ddframe.rdb.sharding.jdbc.BackendStatementWrapper;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractPreparedStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetFactory;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.MergeContext;
import com.dangdang.ddframe.rdb.sharding.router.PreparedSQLRouter;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class ShardingPreparedStatement
extends AbstractPreparedStatementAdapter {
    private final PreparedSQLRouter preparedSQLRouter;
    private final List<PreparedStatementExecutorWrapper> cachedPreparedStatementWrappers = new ArrayList<PreparedStatementExecutorWrapper>();
    private Integer autoGeneratedKeys;
    private int[] columnIndexes;
    private String[] columnNames;
    private int batchIndex;

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql) {
        this(shardingConnection, sql, 1003, 1007, 1);
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency) {
        this(shardingConnection, sql, resultSetType, resultSetConcurrency, 1);
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(shardingConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.preparedSQLRouter = shardingConnection.getShardingContext().getSqlRouteEngine().prepareSQL(sql);
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int autoGeneratedKeys) {
        this(shardingConnection, sql);
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int[] columnIndexes) {
        this(shardingConnection, sql);
        this.columnIndexes = columnIndexes;
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, String[] columnNames) {
        this(shardingConnection, sql);
        this.columnNames = columnNames;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet rs;
        try {
            rs = ResultSetFactory.getResultSet(new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.routeSQL()).executeQuery(), this.getMergeContext());
        }
        finally {
            this.clearRouteContext();
        }
        this.setCurrentResultSet(rs);
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            int n = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.routeSQL()).executeUpdate();
            return n;
        }
        finally {
            this.clearRouteContext();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            boolean bl = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.routeSQL()).execute();
            return bl;
        }
        finally {
            this.clearRouteContext();
        }
    }

    @Override
    protected void clearRouteContext() throws SQLException {
        this.resetBatch();
        this.cachedPreparedStatementWrappers.clear();
        this.batchIndex = 0;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.clearRouteContext();
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            for (PreparedStatementExecutorWrapper each : this.routeSQL()) {
                each.getPreparedStatement().addBatch();
                each.mapBatchIndex(this.batchIndex);
            }
            ++this.batchIndex;
            this.getGeneratedKeyContext().addRow();
        }
        finally {
            this.resetBatch();
        }
    }

    private void resetBatch() throws SQLException {
        super.clearRouteContext();
        this.clearParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.cachedPreparedStatementWrappers).executeBatch(this.batchIndex);
            return nArray;
        }
        finally {
            this.clearRouteContext();
        }
    }

    private List<PreparedStatementExecutorWrapper> routeSQL() throws SQLException {
        ArrayList<PreparedStatementExecutorWrapper> result = new ArrayList<PreparedStatementExecutorWrapper>();
        SQLRouteResult sqlRouteResult = this.preparedSQLRouter.route(this.getParameters());
        MergeContext mergeContext = sqlRouteResult.getMergeContext();
        this.setMergeContext(mergeContext);
        this.setGeneratedKeyContext(sqlRouteResult.getGeneratedKeyContext());
        for (SQLExecutionUnit each : sqlRouteResult.getExecutionUnits()) {
            PreparedStatement preparedStatement = (PreparedStatement)this.getStatement(this.getShardingConnection().getConnection(each.getDataSource(), sqlRouteResult.getSqlStatementType()), each.getSql());
            this.replayMethodsInvocation(preparedStatement);
            this.getParameters().replayMethodsInvocation(preparedStatement);
            result.add(this.wrap(preparedStatement, each));
        }
        return result;
    }

    private PreparedStatementExecutorWrapper wrap(final PreparedStatement preparedStatement, SQLExecutionUnit sqlExecutionUnit) {
        Optional wrapperOptional = Iterators.tryFind(this.cachedPreparedStatementWrappers.iterator(), (Predicate)new Predicate<PreparedStatementExecutorWrapper>(){

            public boolean apply(PreparedStatementExecutorWrapper input) {
                return Objects.equals(input.getPreparedStatement(), preparedStatement);
            }
        });
        if (wrapperOptional.isPresent()) {
            ((PreparedStatementExecutorWrapper)wrapperOptional.get()).addBatchParameters(this.getParameters());
            return (PreparedStatementExecutorWrapper)wrapperOptional.get();
        }
        PreparedStatementExecutorWrapper result = new PreparedStatementExecutorWrapper(preparedStatement, this.getParameters(), sqlExecutionUnit);
        this.cachedPreparedStatementWrappers.add(result);
        return result;
    }

    @Override
    protected BackendStatementWrapper generateStatement(Connection conn, String shardingSql) throws SQLException {
        if (null != this.autoGeneratedKeys) {
            this.getGeneratedKeyContext().setAutoGeneratedKeys(this.autoGeneratedKeys);
            return new BackendPreparedStatementWrapper(conn.prepareStatement(shardingSql, this.autoGeneratedKeys), shardingSql);
        }
        if (null != this.columnIndexes) {
            this.getGeneratedKeyContext().setColumnIndexes(this.columnIndexes);
            return new BackendPreparedStatementWrapper(conn.prepareStatement(shardingSql, this.columnIndexes), shardingSql);
        }
        if (null != this.columnNames) {
            this.getGeneratedKeyContext().setColumnNames(this.columnNames);
            return new BackendPreparedStatementWrapper(conn.prepareStatement(shardingSql, this.columnNames), shardingSql);
        }
        if (0 != this.getResultSetHoldability()) {
            return new BackendPreparedStatementWrapper(conn.prepareStatement(shardingSql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability()), shardingSql);
        }
        return new BackendPreparedStatementWrapper(conn.prepareStatement(shardingSql, this.getResultSetType(), this.getResultSetConcurrency()), shardingSql);
    }
}

