/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor.wrapper;

import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.AbstractExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.google.common.base.Optional;
import java.sql.Statement;

public final class StatementExecutorWrapper
extends AbstractExecutorWrapper {
    private final Statement statement;
    private final Optional<DMLExecutionEvent> dmlExecutionEvent;
    private final Optional<DQLExecutionEvent> dqlExecutionEvent;

    public StatementExecutorWrapper(Statement statement, SQLExecutionUnit sqlExecutionUnit) {
        super(sqlExecutionUnit);
        this.statement = statement;
        if (this.isDML()) {
            this.dmlExecutionEvent = Optional.of((Object)new DMLExecutionEvent(this.getSqlExecutionUnit().getDataSource(), this.getSqlExecutionUnit().getSql()));
            this.dqlExecutionEvent = Optional.absent();
        } else if (this.isDQL()) {
            this.dqlExecutionEvent = Optional.of((Object)new DQLExecutionEvent(this.getSqlExecutionUnit().getDataSource(), this.getSqlExecutionUnit().getSql()));
            this.dmlExecutionEvent = Optional.absent();
        } else {
            this.dmlExecutionEvent = Optional.absent();
            this.dqlExecutionEvent = Optional.absent();
        }
    }

    @Override
    public Optional<DMLExecutionEvent> getDMLExecutionEvent() {
        return this.dmlExecutionEvent;
    }

    @Override
    public Optional<DQLExecutionEvent> getDQLExecutionEvent() {
        return this.dqlExecutionEvent;
    }

    public Statement getStatement() {
        return this.statement;
    }
}

