/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.executor.EventPostman;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorDataMap;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorExceptionHandler;
import com.dangdang.ddframe.rdb.sharding.executor.MergeUnit;
import com.dangdang.ddframe.rdb.sharding.executor.event.EventExecutionType;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.PreparedStatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.google.common.base.Optional;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PreparedStatementExecutor {
    private final ExecutorEngine executorEngine;
    private final Collection<PreparedStatementExecutorWrapper> preparedStatementExecutorWrappers;
    private final EventPostman eventPostman;

    public PreparedStatementExecutor(ExecutorEngine executorEngine, Collection<PreparedStatementExecutorWrapper> preparedStatementExecutorWrappers) {
        this.executorEngine = executorEngine;
        this.preparedStatementExecutorWrappers = preparedStatementExecutorWrappers;
        this.eventPostman = new EventPostman(preparedStatementExecutorWrappers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSet> executeQuery() {
        List<ResultSet> result;
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeQuery");
        this.eventPostman.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.preparedStatementExecutorWrappers.size()) {
                List<ResultSet> list = Collections.singletonList(this.executeQueryInternal(this.preparedStatementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap));
                return list;
            }
            result = this.executorEngine.execute(this.preparedStatementExecutorWrappers, new ExecuteUnit<PreparedStatementExecutorWrapper, ResultSet>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResultSet execute(PreparedStatementExecutorWrapper input) throws Exception {
                    Connection connection = input.getPreparedStatement().getConnection();
                    synchronized (connection) {
                        return PreparedStatementExecutor.this.executeQueryInternal(input, isExceptionThrown, dataMap);
                    }
                }
            });
        }
        finally {
            MetricsContext.stop(context);
        }
        return result;
    }

    private ResultSet executeQueryInternal(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        ResultSet result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = preparedStatementExecutorWrapper.getPreparedStatement().executeQuery();
        }
        catch (SQLException ex) {
            this.eventPostman.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
        this.eventPostman.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeUpdate");
        this.eventPostman.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.preparedStatementExecutorWrappers.size()) {
                int n = this.executeUpdateInternal(this.preparedStatementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap);
                return n;
            }
            int n = this.executorEngine.execute(this.preparedStatementExecutorWrappers, new ExecuteUnit<PreparedStatementExecutorWrapper, Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer execute(PreparedStatementExecutorWrapper input) throws Exception {
                    Connection connection = input.getPreparedStatement().getConnection();
                    synchronized (connection) {
                        return PreparedStatementExecutor.this.executeUpdateInternal(input, isExceptionThrown, dataMap);
                    }
                }
            }, new MergeUnit<Integer, Integer>(){

                @Override
                public Integer merge(List<Integer> results) {
                    if (null == results) {
                        return 0;
                    }
                    int result = 0;
                    for (Integer each : results) {
                        result += each.intValue();
                    }
                    return result;
                }
            });
            return n;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private int executeUpdateInternal(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        int result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = preparedStatementExecutorWrapper.getPreparedStatement().executeUpdate();
        }
        catch (SQLException ex) {
            this.eventPostman.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return 0;
        }
        this.eventPostman.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-execute");
        this.eventPostman.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.preparedStatementExecutorWrappers.size()) {
                PreparedStatementExecutorWrapper preparedStatementExecutorWrapper = this.preparedStatementExecutorWrappers.iterator().next();
                boolean bl = this.executeInternal(preparedStatementExecutorWrapper, isExceptionThrown, dataMap);
                return bl;
            }
            List<Boolean> result = this.executorEngine.execute(this.preparedStatementExecutorWrappers, new ExecuteUnit<PreparedStatementExecutorWrapper, Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean execute(PreparedStatementExecutorWrapper input) throws Exception {
                    Connection connection = input.getPreparedStatement().getConnection();
                    synchronized (connection) {
                        return PreparedStatementExecutor.this.executeInternal(input, isExceptionThrown, dataMap);
                    }
                }
            });
            boolean bl = null == result || result.isEmpty() ? false : result.get(0);
            return bl;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private boolean executeInternal(PreparedStatementExecutorWrapper preparedStatementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        boolean result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = preparedStatementExecutorWrapper.getPreparedStatement().execute();
        }
        catch (SQLException ex) {
            this.eventPostman.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return false;
        }
        this.eventPostman.postExecutionEventsAfterExecution(preparedStatementExecutorWrapper);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(final int batchSize) {
        Timer.Context context = MetricsContext.start("ShardingPreparedStatement-executeUpdate");
        this.eventPostman.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.preparedStatementExecutorWrappers.size()) {
                int[] nArray = this.executeBatchInternal(this.preparedStatementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap);
                return nArray;
            }
            int[] nArray = this.executorEngine.execute(this.preparedStatementExecutorWrappers, new ExecuteUnit<PreparedStatementExecutorWrapper, int[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int[] execute(PreparedStatementExecutorWrapper input) throws Exception {
                    Connection connection = input.getPreparedStatement().getConnection();
                    synchronized (connection) {
                        return PreparedStatementExecutor.this.executeBatchInternal(input, isExceptionThrown, dataMap);
                    }
                }
            }, new MergeUnit<int[], int[]>(){

                @Override
                public int[] merge(List<int[]> results) {
                    if (null == results) {
                        return new int[]{0};
                    }
                    int[] result = new int[batchSize];
                    int i = 0;
                    for (PreparedStatementExecutorWrapper each : PreparedStatementExecutor.this.preparedStatementExecutorWrappers) {
                        for (Integer[] indices : each.getBatchIndices()) {
                            int n = indices[0];
                            result[n] = result[n] + results.get(i)[indices[1]];
                        }
                        ++i;
                    }
                    return result;
                }
            });
            return nArray;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private int[] executeBatchInternal(PreparedStatementExecutorWrapper batchPreparedStatementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        int[] result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = batchPreparedStatementExecutorWrapper.getPreparedStatement().executeBatch();
        }
        catch (SQLException ex) {
            this.eventPostman.postExecutionEventsAfterExecution(batchPreparedStatementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
        this.eventPostman.postExecutionEventsAfterExecution(batchPreparedStatementExecutorWrapper);
        return result;
    }
}

