/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.parser.result.GeneratedKeyContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.SQLParsedResult;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteEngine;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.List;

public class PreparedSQLRouter {
    private final String logicSql;
    private final SQLRouteEngine engine;
    private final ShardingRule shardingRule;
    private SQLParsedResult sqlParsedResult;
    private Optional<TableRule> tableRuleOptional;

    public SQLRouteResult route(List<Object> parameters) {
        if (null == this.sqlParsedResult) {
            this.sqlParsedResult = this.engine.parseSQL(this.logicSql, parameters);
            this.tableRuleOptional = this.shardingRule.tryFindTableRule(this.sqlParsedResult.getRouteContext().getTables().iterator().next().getName());
        } else {
            this.generateId(parameters);
            this.engine.setParameters(parameters);
            for (ConditionContext each : this.sqlParsedResult.getConditionContexts()) {
                each.setNewConditionValue(parameters);
            }
        }
        return this.engine.routeSQL(this.sqlParsedResult);
    }

    private void generateId(List<Object> parameters) {
        if (!this.tableRuleOptional.isPresent()) {
            return;
        }
        TableRule tableRule = (TableRule)this.tableRuleOptional.get();
        GeneratedKeyContext generatedKeyContext = this.sqlParsedResult.getGeneratedKeyContext();
        for (String each : generatedKeyContext.getColumns()) {
            Object id = tableRule.generateId(each);
            parameters.add(id);
            generatedKeyContext.putValue(each, id);
        }
    }

    @ConstructorProperties(value={"logicSql", "engine", "shardingRule"})
    public PreparedSQLRouter(String logicSql, SQLRouteEngine engine, ShardingRule shardingRule) {
        this.logicSql = logicSql;
        this.engine = engine;
        this.shardingRule = shardingRule;
    }
}

