/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.pipeline.reducer;

import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMergeContext;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.delegate.AbstractDelegateResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.OrderByResultSetRow;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.OrderByColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamingOrderByReducerResultSet
extends AbstractDelegateResultSet {
    private static final Logger log = LoggerFactory.getLogger(StreamingOrderByReducerResultSet.class);
    private final List<OrderByColumn> orderByColumns;
    private final List<ResultSet> resultSets = new LinkedList<ResultSet>();

    public StreamingOrderByReducerResultSet(ResultSetMergeContext resultSetMergeContext) throws SQLException {
        super(resultSetMergeContext.getShardingResultSets().getResultSets());
        this.orderByColumns = resultSetMergeContext.getCurrentOrderByKeys();
        this.resultSets.addAll(resultSetMergeContext.getShardingResultSets().getResultSets());
    }

    @Override
    protected boolean firstNext() throws SQLException {
        this.initialResultSetCursors();
        return this.doNext();
    }

    private void initialResultSetCursors() throws SQLException {
        for (ResultSet each : this.resultSets) {
            each.next();
        }
    }

    @Override
    protected boolean afterFirstNext() throws SQLException {
        if (!this.getDelegate().next()) {
            this.resultSets.remove(this.getDelegate());
        }
        return this.doNext();
    }

    private boolean doNext() throws SQLException {
        this.setDelegateResultSet();
        return !this.resultSets.isEmpty();
    }

    private void setDelegateResultSet() throws SQLException {
        OrderByResultSetRow chosenOrderByValue = null;
        for (ResultSet each : this.resultSets) {
            OrderByResultSetRow eachOrderByValue = new OrderByResultSetRow(each, this.orderByColumns);
            if (null != chosenOrderByValue && chosenOrderByValue.compareTo(eachOrderByValue) <= 0) continue;
            chosenOrderByValue = eachOrderByValue;
            this.setDelegate(each);
        }
        log.trace("Chosen order by value: {}, current result set hashcode: {}", chosenOrderByValue, (Object)this.getDelegate().hashCode());
    }
}

