/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.config.common.internal.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ShardingValueWrapper {
    private final Comparable<?> value;

    public ShardingValueWrapper(Comparable<?> value) {
        Preconditions.checkArgument((value instanceof Number || value instanceof Date || value instanceof String ? 1 : 0) != 0, (Object)String.format("Value must be type of Number, Data or String, your value type is '%s'", value.getClass().getName()));
        this.value = value;
    }

    public long longValue() {
        return this.numberValue().longValue();
    }

    public double doubleValue() {
        return this.numberValue().doubleValue();
    }

    private Number numberValue() {
        if (this.value instanceof Number) {
            return (Number)((Object)this.value);
        }
        if (this.value instanceof Date) {
            return ((Date)this.value).getTime();
        }
        return new BigDecimal(this.value.toString());
    }

    public Date dateValue(String format) throws ParseException {
        if (this.value instanceof Number) {
            return new Date(((Number)((Object)this.value)).longValue());
        }
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)format) ? 1 : 0) != 0);
        return new SimpleDateFormat(format).parse(this.value.toString());
    }

    public Date dateValue() throws ParseException {
        return this.dateValue(null);
    }

    public String toString(String format) {
        if (this.value instanceof Date) {
            return new SimpleDateFormat(format).format(((Date)this.value).getTime());
        }
        if (this.value instanceof Number) {
            return new SimpleDateFormat(format).format(((Number)((Object)this.value)).longValue());
        }
        return this.toString();
    }

    public String toString() {
        return this.value.toString();
    }
}

