/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.boot.swagger.web;

import com.battcn.boot.swagger.annotation.ApiOrder;
import com.battcn.boot.swagger.model.Order;
import com.battcn.boot.swagger.properties.SwaggerSecurityProperties;
import com.battcn.boot.swagger.utils.HostNameProvider;
import com.battcn.boot.swagger.utils.RequestUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UriComponents;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@ConditionalOnProperty(name={"spring.swagger.enabled"}, havingValue="true", matchIfMissing=true)
@RestController
@ApiIgnore
public class CustomSwagger2Controller {
    private static final String DEFAULT = "DEFAULT";
    private static final String V3_SWAGGER_API_DOCS = "/v3/api-docs";
    private static final String V3_SWAGGER_SECURITY_URL = "/v3/swagger-security";
    private static final String V3_SWAGGER_SECURITY_LOGIN_URL = "/v3/swagger-login";
    private final SwaggerSecurityProperties swaggerSecurityProperties;
    private final String hostNameOverride;
    private final DocumentationCache documentationCache;
    private final ServiceModelToSwagger2Mapper mapper;
    private final JsonSerializer jsonSerializer;
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;

    @Autowired
    public CustomSwagger2Controller(SwaggerSecurityProperties swaggerSecurityProperties, Environment environment, DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper, JsonSerializer jsonSerializer, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.hostNameOverride = environment.getProperty("springfox.documentation.swagger.v2.host", DEFAULT);
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
        this.swaggerSecurityProperties = swaggerSecurityProperties;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @GetMapping(value={"/v3/swagger-security"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Map<String, Boolean>> getCustomDocumentation() {
        HashMap<String, Boolean> meteData = new HashMap<String, Boolean>(2);
        meteData.put("security", this.swaggerSecurityProperties.isFilterPlugin());
        return new ResponseEntity(meteData, HttpStatus.OK);
    }

    @PostMapping(value={"/v3/swagger-login"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Void> loginSwagger(HttpSession session, HttpServletResponse response, String username, String password) throws IOException {
        if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
            RequestUtils.writeForbidden(response);
        }
        if (!username.equals(this.swaggerSecurityProperties.getUsername()) || !password.equals(this.swaggerSecurityProperties.getPassword())) {
            RequestUtils.writeForbidden(response);
        }
        if (this.swaggerSecurityProperties.getUsername().equals(username) && password.equals(this.swaggerSecurityProperties.getPassword())) {
            String sessionId = session.getId();
            session.setAttribute(sessionId, (Object)sessionId);
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }

    @GetMapping(value={"/v3/api-docs"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        String groupName = Optional.ofNullable(swaggerGroup).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Swagger swagger = this.mapper.mapDocumentation(documentation);
        swagger.setVendorExtension("x-order-tags", (Object)"");
        UriComponents uriComponents = HostNameProvider.componentsFrom(servletRequest, swagger.getBasePath());
        swagger.basePath(Strings.isNullOrEmpty((String)uriComponents.getPath()) ? "/" : uriComponents.getPath());
        if (Strings.isNullOrEmpty((String)swagger.getHost())) {
            swagger.host(this.hostName(uriComponents));
        }
        List<Order> orders = this.findOrder();
        List tags = swagger.getTags();
        for (Tag tag : tags) {
            for (Order order : orders) {
                if (!order.getTags().contains(tag.getName())) continue;
                tag.setVendorExtension("x-order", (Object)order.getOrder());
            }
        }
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)swagger), HttpStatus.OK);
    }

    private List<Order> findOrder() {
        ArrayList orders = Lists.newArrayList();
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry methodEntry : handlerMethods.entrySet()) {
            HandlerMethod method = (HandlerMethod)methodEntry.getValue();
            Class<?> declaringClass = method.getMethod().getDeclaringClass();
            String simpleName = declaringClass.getSimpleName();
            ApiOrder apiOrder = (ApiOrder)AnnotationUtils.findAnnotation(declaringClass, ApiOrder.class);
            Api api = (Api)AnnotationUtils.findAnnotation(declaringClass, Api.class);
            Order order = new Order();
            if (apiOrder != null) {
                order.setOrder(apiOrder.value());
            }
            if (api != null) {
                order.setTags(Lists.newArrayList((Object[])api.tags()));
            } else {
                String lowerCase = simpleName.replaceAll("-", "").toLowerCase();
                order.setTags(Lists.newArrayList((Object[])new String[]{lowerCase}));
            }
            orders.add(order);
        }
        return orders;
    }

    private String hostName(UriComponents uriComponents) {
        if (DEFAULT.equals(this.hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return this.hostNameOverride;
    }
}

