/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.hiero.unicodefont;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.tools.hiero.unicodefont.Glyph;
import com.badlogic.gdx.tools.hiero.unicodefont.UnicodeFont;
import com.badlogic.gdx.tools.hiero.unicodefont.effects.ColorEffect;
import com.badlogic.gdx.tools.hiero.unicodefont.effects.Effect;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.lwjgl.opengl.GL11;

public class GlyphPage {
    private final UnicodeFont unicodeFont;
    private final int pageWidth;
    private final int pageHeight;
    private final Texture texture;
    private int pageX;
    private int pageY;
    private int rowHeight;
    private boolean orderAscending;
    private final List pageGlyphs = new ArrayList(32);
    public static final int MAX_GLYPH_SIZE = 256;
    private static ByteBuffer scratchByteBuffer = ByteBuffer.allocateDirect(262144);
    private static IntBuffer scratchIntBuffer;
    private static BufferedImage scratchImage;
    static Graphics2D scratchGraphics;
    public static FontRenderContext renderContext;

    GlyphPage(UnicodeFont unicodeFont, int pageWidth, int pageHeight) {
        this.unicodeFont = unicodeFont;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.texture = new Texture(pageWidth, pageHeight, Pixmap.Format.RGBA8888);
    }

    int loadGlyphs(List glyphs, int maxGlyphsToLoad) {
        if (this.rowHeight != 0 && maxGlyphsToLoad == -1) {
            int testX = this.pageX;
            int testY = this.pageY;
            int testRowHeight = this.rowHeight;
            Iterator iter = this.getIterator(glyphs);
            while (iter.hasNext()) {
                Glyph glyph = (Glyph)iter.next();
                int width = glyph.getWidth();
                int height = glyph.getHeight();
                if (testX + width >= this.pageWidth) {
                    testX = 0;
                    testY += testRowHeight;
                    testRowHeight = height;
                } else if (height > testRowHeight) {
                    testRowHeight = height;
                }
                if (testY + testRowHeight >= this.pageWidth) {
                    return 0;
                }
                testX += width;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.texture.bind();
        int i = 0;
        Iterator iter = this.getIterator(glyphs);
        while (iter.hasNext()) {
            Glyph glyph = (Glyph)iter.next();
            int width = Math.min(256, glyph.getWidth());
            int height = Math.min(256, glyph.getHeight());
            if (this.rowHeight == 0) {
                this.rowHeight = height;
            } else if (this.pageX + width >= this.pageWidth) {
                if (this.pageY + this.rowHeight + height >= this.pageHeight) break;
                this.pageX = 0;
                this.pageY += this.rowHeight;
                this.rowHeight = height;
            } else if (height > this.rowHeight) {
                if (this.pageY + height >= this.pageHeight) break;
                this.rowHeight = height;
            }
            this.renderGlyph(glyph, width, height);
            this.pageGlyphs.add(glyph);
            this.pageX += width;
            iter.remove();
            if (++i != maxGlyphsToLoad) continue;
            this.orderAscending = !this.orderAscending;
            break;
        }
        this.orderAscending = !this.orderAscending;
        return i;
    }

    private void renderGlyph(Glyph glyph, int width, int height) {
        scratchGraphics.setComposite(AlphaComposite.Clear);
        scratchGraphics.fillRect(0, 0, 256, 256);
        scratchGraphics.setComposite(AlphaComposite.SrcOver);
        if (this.unicodeFont.getNativeRendering()) {
            for (Effect effect : this.unicodeFont.getEffects()) {
                if (!(effect instanceof ColorEffect)) continue;
                scratchGraphics.setColor(((ColorEffect)effect).getColor());
            }
            scratchGraphics.setColor(Color.white);
            scratchGraphics.setFont(this.unicodeFont.getFont());
            scratchGraphics.drawString("" + (char)glyph.getCodePoint(), 0, this.unicodeFont.getAscent());
        } else {
            scratchGraphics.setColor(Color.white);
            Iterator iter = this.unicodeFont.getEffects().iterator();
            while (iter.hasNext()) {
                ((Effect)iter.next()).draw(scratchImage, scratchGraphics, this.unicodeFont, glyph);
            }
            glyph.setShape(null);
        }
        width = Math.min(width, this.texture.getWidth());
        height = Math.min(height, this.texture.getHeight());
        WritableRaster raster = scratchImage.getRaster();
        int[] row = new int[width];
        for (int y = 0; y < height; ++y) {
            raster.getDataElements(0, y, width, 1, row);
            scratchIntBuffer.put(row);
        }
        GL11.glTexSubImage2D((int)3553, (int)0, (int)this.pageX, (int)this.pageY, (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)scratchByteBuffer);
        scratchIntBuffer.clear();
        float u = (float)this.pageX / (float)this.texture.getWidth();
        float v = (float)this.pageY / (float)this.texture.getHeight();
        float u2 = (float)(this.pageX + width) / (float)this.texture.getWidth();
        float v2 = (float)(this.pageY + height) / (float)this.texture.getHeight();
        glyph.setTexture(this.texture, u, v, u2, v2);
    }

    private Iterator getIterator(List glyphs) {
        if (this.orderAscending) {
            return glyphs.iterator();
        }
        final ListIterator iter = glyphs.listIterator(glyphs.size());
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return iter.hasPrevious();
            }

            public Object next() {
                return iter.previous();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public List getGlyphs() {
        return this.pageGlyphs;
    }

    public Texture getTexture() {
        return this.texture;
    }

    static {
        scratchByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        scratchIntBuffer = scratchByteBuffer.asIntBuffer();
        scratchImage = new BufferedImage(256, 256, 2);
        scratchGraphics = (Graphics2D)scratchImage.getGraphics();
        scratchGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        scratchGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        renderContext = scratchGraphics.getFontRenderContext();
    }
}

