/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.hiero;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglCanvas;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.tools.hiero.unicodefont.effects.EffectUtil;
import de.matthiasmann.twlthemeeditor.fontgen.CharSet;
import de.matthiasmann.twlthemeeditor.fontgen.Effect;
import de.matthiasmann.twlthemeeditor.fontgen.FontData;
import de.matthiasmann.twlthemeeditor.fontgen.FontGenerator;
import de.matthiasmann.twlthemeeditor.fontgen.Padding;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lwjgl.opengl.GL11;

public class Hiero4
extends JFrame {
    static final String NEHE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890\n\"!`?'.,;:()[]{}<>|/@\\^$-%+=#_&~*\u007f";
    com.badlogic.gdx.graphics.Color renderingBackgroundColor = com.badlogic.gdx.graphics.Color.BLACK;
    Preferences prefs;
    Renderer renderer;
    FontData fontData;
    FontGenerator fontGenerator;
    HashSet<Character> sampleChars = new HashSet(256);
    HashSet<Character> remainingSampleChars = new HashSet(256);
    JScrollPane appliedEffectsScroll;
    JPanel appliedEffectsPanel;
    JButton addEffectButton;
    JTextPane sampleTextPane;
    JSpinner padAdvanceXSpinner;
    JList effectsList;
    JPanel gamePanel;
    JTextField fontFileText;
    JRadioButton fontFileRadio;
    JRadioButton systemFontRadio;
    JSpinner padBottomSpinner;
    JSpinner padLeftSpinner;
    JSpinner padRightSpinner;
    JSpinner padTopSpinner;
    JList fontList;
    JSpinner fontSizeSpinner;
    DefaultComboBoxModel fontListModel;
    JLabel backgroundColorLabel;
    JButton browseButton;
    JSpinner padAdvanceYSpinner;
    JCheckBox italicCheckBox;
    JCheckBox boldCheckBox;
    JRadioButton vectorRadio;
    JRadioButton drawStringRadio;
    JRadioButton freetypeRadio;
    JComboBox glyphPageHeightCombo;
    JComboBox glyphPageWidthCombo;
    JPanel glyphCachePanel;
    JRadioButton glyphCacheRadio;
    JRadioButton sampleTextRadio;
    JButton sampleAsciiButton;
    JButton sampleNeheButton;
    DefaultComboBoxModel effectsListModel;
    JMenuItem openMenuItem;
    JMenuItem saveMenuItem;
    JMenuItem exitMenuItem;
    JMenuItem saveBMFontMenuItem;

    public Hiero4() {
        super("Hiero v4.0 - Bitmap Font Tool");
        Splash splash = new Splash(this, "/splash.jpg", 2000);
        this.initialize();
        splash.close();
        this.renderer = new Renderer();
        this.gamePanel.add(new LwjglCanvas((ApplicationListener)this.renderer).getCanvas());
        this.prefs = Preferences.userNodeForPackage(Hiero4.class);
        Color backgroundColor = EffectUtil.fromString(this.prefs.get("background", "000000"));
        this.backgroundColorLabel.setIcon(Hiero4.getColorIcon(backgroundColor));
        this.renderingBackgroundColor = new com.badlogic.gdx.graphics.Color((float)backgroundColor.getRed() / 255.0f, (float)backgroundColor.getGreen() / 255.0f, (float)backgroundColor.getBlue() / 255.0f, 1.0f);
        boolean useFontList = Hiero4.getFontFile(Font.decode("Arial")) != null;
        this.fontList.setEnabled(useFontList);
        this.systemFontRadio.setEnabled(useFontList);
        this.fontFileRadio.setSelected(!useFontList);
        this.fontFileText.setText(this.prefs.get("font.file", ""));
        this.setVisible(true);
    }

    void initialize() {
        this.initializeComponents();
        this.initializeMenus();
        this.initializeEvents();
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.sampleNeheButton.doClick();
    }

    void changeFont() {
        if (this.renderer.batch == null) {
            return;
        }
        String path = this.systemFontRadio.isSelected() ? Hiero4.getFontFile(Font.decode((String)this.fontList.getSelectedValue())) : this.fontFileText.getText();
        if (path == null) {
            this.renderer.font = null;
            return;
        }
        int fontSize = (Integer)this.fontSizeSpinner.getValue();
        try {
            this.fontData = new FontData(new File(path), (float)fontSize);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.renderer.font = null;
            return;
        }
        this.sampleChars.clear();
        this.updateFont(true);
    }

    void updateFont(boolean force) {
        if (this.fontData == null || this.renderer.batch == null) {
            return;
        }
        final String text = this.sampleTextPane.getText();
        if (!force) {
            boolean newCharFound = false;
            this.remainingSampleChars.clear();
            this.remainingSampleChars.addAll(this.sampleChars);
            for (int i = text.length() - 1; i >= 0; --i) {
                Character ch = Character.valueOf(text.charAt(i));
                if (this.sampleChars.add(ch)) {
                    newCharFound = true;
                }
                this.remainingSampleChars.remove(ch);
            }
            if (!newCharFound && this.remainingSampleChars.isEmpty()) {
                return;
            }
        }
        this.sampleChars.clear();
        for (int i = text.length() - 1; i >= 0; --i) {
            this.sampleChars.add(Character.valueOf(text.charAt(i)));
        }
        int fontSize = (Integer)this.fontSizeSpinner.getValue();
        int style = 0;
        if (this.boldCheckBox.isSelected()) {
            style = 1;
            if (this.italicCheckBox.isSelected()) {
                style |= 2;
            }
        } else if (this.italicCheckBox.isSelected()) {
            style = 2;
        }
        this.fontData = this.fontData.deriveFont((float)fontSize, style);
        int sampleFontSize = this.sampleTextPane.getFont().getSize();
        if (sampleFontSize < 14) {
            sampleFontSize = 14;
        }
        this.sampleTextPane.setFont(this.fontData.getJavaFont().deriveFont((float)sampleFontSize));
        final Padding padding = new Padding(((Integer)this.padTopSpinner.getValue()).intValue(), ((Integer)this.padLeftSpinner.getValue()).intValue(), ((Integer)this.padBottomSpinner.getValue()).intValue(), ((Integer)this.padRightSpinner.getValue()).intValue(), ((Integer)this.padAdvanceXSpinner.getValue()).intValue());
        final int width = (Integer)this.glyphPageWidthCombo.getSelectedItem();
        final int height = (Integer)this.glyphPageHeightCombo.getSelectedItem();
        final FontGenerator.GeneratorMethod method = this.vectorRadio.isSelected() ? FontGenerator.GeneratorMethod.AWT_VECTOR : (this.drawStringRadio.isSelected() ? FontGenerator.GeneratorMethod.AWT_DRAWSTRING : FontGenerator.GeneratorMethod.FREETYPE2);
        new Thread(){

            @Override
            public void run() {
                Hiero4.this.fontGenerator = new FontGenerator(Hiero4.this.fontData, method);
                CharSet charset = new CharSet();
                charset.setManualCharacters(text);
                try {
                    Hiero4.this.fontGenerator.generate(width, height, charset, padding, new Effect.Renderer[0], true);
                    Hiero4.this.fontGenerator.write(new File("out"), FontGenerator.ExportFormat.TEXT);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final ByteBuffer buffer = ByteBuffer.allocateDirect(0x400000);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        Hiero4.this.fontGenerator.getTextureData(buffer.asIntBuffer());
                        TextureRegion glyphRegion = new TextureRegion(new Texture(new TextureData(){
                            Pixmap pixmap;

                            public int getWidth() {
                                return width;
                            }

                            public int getHeight() {
                                return height;
                            }

                            public Pixmap consumePixmap() {
                                this.pixmap = new Pixmap(width, height, Pixmap.Format.RGBA8888);
                                this.pixmap.getPixels().put(buffer);
                                this.pixmap.getPixels().rewind();
                                return this.pixmap;
                            }

                            public boolean disposePixmap() {
                                return true;
                            }

                            public Pixmap.Format getFormat() {
                                return this.pixmap.getFormat();
                            }

                            public boolean useMipMaps() {
                                return false;
                            }

                            public boolean isManaged() {
                                return true;
                            }

                            public TextureData.TextureDataType getType() {
                                return TextureData.TextureDataType.Pixmap;
                            }

                            public void consumeCustomData(int target) {
                            }

                            public boolean isPrepared() {
                                return true;
                            }

                            public void prepare() {
                            }
                        }));
                        Hiero4.this.renderer.font = new BitmapFont(Gdx.files.absolute("out"), glyphRegion, false);
                    }
                });
            }
        }.start();
    }

    private void initializeEvents() {
        class FontChangeListener
        implements ChangeListener,
        ActionListener {
            FontChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                Hiero4.this.changeFont();
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Hiero4.this.changeFont();
            }
        }
        FontChangeListener change = new FontChangeListener();
        this.fontFileRadio.addActionListener(change);
        this.systemFontRadio.addActionListener(change);
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                Hiero4.this.prefs.put("system.font", (String)Hiero4.this.fontList.getSelectedValue());
                Hiero4.this.changeFont();
            }
        });
        class FontUpdateListener
        implements ChangeListener,
        ActionListener,
        DocumentListener {
            private final boolean force;

            public FontUpdateListener(boolean force) {
                this.force = force;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                Hiero4.this.updateFont(this.force);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Hiero4.this.updateFont(this.force);
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                Hiero4.this.updateFont(this.force);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                Hiero4.this.updateFont(this.force);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                Hiero4.this.updateFont(this.force);
            }

            public void addSpinners(JSpinner[] spinners) {
                for (int i = 0; i < spinners.length; ++i) {
                    final JSpinner spinner = spinners[i];
                    spinner.addChangeListener(this);
                    ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().addKeyListener(new KeyAdapter(){
                        String lastText;

                        @Override
                        public void keyReleased(KeyEvent evt) {
                            JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
                            String text = textField.getText();
                            if (text.length() == 0) {
                                return;
                            }
                            if (text.equals(this.lastText)) {
                                return;
                            }
                            this.lastText = text;
                            int caretPosition = textField.getCaretPosition();
                            try {
                                spinner.setValue(Integer.valueOf(text));
                                textField.setCaretPosition(caretPosition);
                            }
                            catch (Throwable ignored) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }
        FontUpdateListener update = new FontUpdateListener(true);
        FontUpdateListener updateText = new FontUpdateListener(false);
        update.addSpinners(new JSpinner[]{this.padTopSpinner, this.padRightSpinner, this.padBottomSpinner, this.padLeftSpinner, this.padAdvanceXSpinner, this.padAdvanceYSpinner});
        this.fontSizeSpinner.addChangeListener(update);
        this.glyphPageWidthCombo.addActionListener(update);
        this.glyphPageHeightCombo.addActionListener(update);
        this.boldCheckBox.addActionListener(update);
        this.italicCheckBox.addActionListener(update);
        this.vectorRadio.addActionListener(update);
        this.drawStringRadio.addActionListener(update);
        this.freetypeRadio.addActionListener(update);
        this.sampleTextPane.getDocument().addDocumentListener(updateText);
        this.sampleTextRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Hiero4.this.glyphCachePanel.setVisible(false);
            }
        });
        this.glyphCacheRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Hiero4.this.glyphCachePanel.setVisible(true);
            }
        });
        this.fontFileText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.changed();
            }

            private void changed() {
                File file = new File(Hiero4.this.fontFileText.getText());
                if (!(!Hiero4.this.fontList.isEnabled() || file.exists() && file.isFile())) {
                    return;
                }
                Hiero4.this.prefs.put("font.file", Hiero4.this.fontFileText.getText());
                Hiero4.this.updateFont(true);
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileDialog dialog = new FileDialog((Frame)Hiero4.this, "Choose TrueType font file", 0);
                dialog.setLocationRelativeTo(null);
                dialog.setFile("*.ttf");
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName == null) {
                    return;
                }
                Hiero4.this.fontFileText.setText(new File(dialog.getDirectory(), fileName).getAbsolutePath());
            }
        });
        this.backgroundColorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Color color = JColorChooser.showDialog(null, "Choose a background color", EffectUtil.fromString(Hiero4.this.prefs.get("background", "000000")));
                if (color == null) {
                    return;
                }
                Hiero4.this.renderingBackgroundColor = new com.badlogic.gdx.graphics.Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
                Hiero4.this.backgroundColorLabel.setIcon(Hiero4.getColorIcon(color));
                Hiero4.this.prefs.put("background", EffectUtil.toString(color));
            }
        });
        this.saveBMFontMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (Hiero4.this.fontGenerator == null) {
                    return;
                }
                FileDialog dialog = new FileDialog((Frame)Hiero4.this, "Save BMFont files", 1);
                dialog.setLocationRelativeTo(null);
                dialog.setFile("*.fnt");
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName == null) {
                    return;
                }
                try {
                    Hiero4.this.fontGenerator.write(new File(dialog.getDirectory(), fileName), FontGenerator.ExportFormat.TEXT);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Hiero4.this.dispose();
            }
        });
        this.sampleNeheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Hiero4.this.sampleTextPane.setText(Hiero4.NEHE);
            }
        });
        this.sampleAsciiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(Hiero4.NEHE);
                buffer.append('\n');
                int count = 0;
                for (int i = 33; i <= 255; ++i) {
                    if (buffer.indexOf(Character.toString((char)i)) != -1) continue;
                    buffer.append((char)i);
                    if (++count % 30 != 0) continue;
                    buffer.append('\n');
                }
                Hiero4.this.sampleTextPane.setText(buffer.toString());
            }
        });
    }

    private void initializeComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel leftSidePanel = new JPanel();
        leftSidePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)leftSidePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel fontPanel = new JPanel();
        leftSidePanel.add((Component)fontPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        fontPanel.setLayout(new GridBagLayout());
        fontPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel(32, 0, 256, 1));
        fontPanel.add((Component)this.fontSizeSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        ((JSpinner.DefaultEditor)this.fontSizeSpinner.getEditor()).getTextField().setColumns(2);
        JScrollPane fontScroll = new JScrollPane();
        fontPanel.add((Component)fontScroll, new GridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.fontListModel = new DefaultComboBoxModel<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.fontList = new JList();
        fontScroll.setViewportView(this.fontList);
        this.fontList.setModel(this.fontListModel);
        this.fontList.setVisibleRowCount(6);
        this.fontList.setSelectedIndex(0);
        fontScroll.setMinimumSize(new Dimension(220, this.fontList.getPreferredScrollableViewportSize().height));
        this.systemFontRadio = new JRadioButton("System:", true);
        fontPanel.add((Component)this.systemFontRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.systemFontRadio.setMargin(new Insets(0, 0, 0, 0));
        this.fontFileRadio = new JRadioButton("File:");
        fontPanel.add((Component)this.fontFileRadio, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.fontFileRadio.setMargin(new Insets(0, 0, 0, 0));
        this.fontFileText = new JTextField();
        fontPanel.add((Component)this.fontFileText, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        fontPanel.add((Component)new JLabel("Size:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.boldCheckBox = new JCheckBox("Bold");
        fontPanel.add((Component)this.boldCheckBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.italicCheckBox = new JCheckBox("Italic");
        fontPanel.add((Component)this.italicCheckBox, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.browseButton = new JButton("...");
        fontPanel.add((Component)this.browseButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.browseButton.setMargin(new Insets(0, 0, 0, 0));
        fontPanel.add((Component)new JLabel("Rendering:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.vectorRadio = new JRadioButton("Vector");
        fontPanel.add((Component)this.vectorRadio, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        if (!FontGenerator.GeneratorMethod.FREETYPE2.isAvailable) {
            this.vectorRadio.setSelected(true);
        }
        this.drawStringRadio = new JRadioButton("DrawString");
        fontPanel.add((Component)this.drawStringRadio, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.freetypeRadio = new JRadioButton("FreeType");
        fontPanel.add((Component)this.freetypeRadio, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        if (FontGenerator.GeneratorMethod.FREETYPE2.isAvailable) {
            this.freetypeRadio.setSelected(true);
        } else {
            this.freetypeRadio.setEnabled(false);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.systemFontRadio);
        buttonGroup.add(this.fontFileRadio);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.vectorRadio);
        buttonGroup.add(this.drawStringRadio);
        buttonGroup.add(this.freetypeRadio);
        JPanel samplePanel = new JPanel();
        leftSidePanel.add((Component)samplePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        samplePanel.setLayout(new GridBagLayout());
        samplePanel.setBorder(BorderFactory.createTitledBorder("Sample Text"));
        JScrollPane textScroll = new JScrollPane();
        samplePanel.add((Component)textScroll, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.sampleTextPane = new JTextPane();
        textScroll.setViewportView(this.sampleTextPane);
        this.sampleNeheButton = new JButton();
        this.sampleNeheButton.setText("NEHE");
        samplePanel.add((Component)this.sampleNeheButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.sampleAsciiButton = new JButton();
        this.sampleAsciiButton.setText("ASCII");
        samplePanel.add((Component)this.sampleAsciiButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        JPanel renderingPanel = new JPanel();
        leftSidePanel.add((Component)renderingPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        renderingPanel.setBorder(BorderFactory.createTitledBorder("Rendering"));
        renderingPanel.setLayout(new GridBagLayout());
        JPanel wrapperPanel = new JPanel();
        renderingPanel.add((Component)wrapperPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        wrapperPanel.setLayout(new BorderLayout());
        wrapperPanel.setBackground(Color.white);
        this.gamePanel = new JPanel();
        wrapperPanel.add(this.gamePanel);
        this.gamePanel.setLayout(new BorderLayout());
        this.gamePanel.setBackground(Color.white);
        this.glyphCachePanel = new JPanel(){
            private int maxWidth;

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = this.maxWidth = Math.max(this.maxWidth, size.width);
                return size;
            }
        };
        this.glyphCachePanel.setVisible(false);
        renderingPanel.add((Component)this.glyphCachePanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.glyphCachePanel.setLayout(new GridBagLayout());
        this.glyphCachePanel.add((Component)new JLabel("Page width:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.glyphCachePanel.add((Component)new JLabel("Page height:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.glyphPageWidthCombo = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(new Integer[]{new Integer(64), new Integer(128), new Integer(256), new Integer(512), new Integer(1024), new Integer(2048)}));
        this.glyphCachePanel.add((Component)this.glyphPageWidthCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.glyphPageWidthCombo.setSelectedIndex(4);
        this.glyphPageHeightCombo = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(new Integer[]{new Integer(64), new Integer(128), new Integer(256), new Integer(512), new Integer(1024), new Integer(2048)}));
        this.glyphCachePanel.add((Component)this.glyphPageHeightCombo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.glyphPageHeightCombo.setSelectedIndex(4);
        JPanel radioButtonsPanel = new JPanel();
        renderingPanel.add((Component)radioButtonsPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        radioButtonsPanel.setLayout(new GridBagLayout());
        this.sampleTextRadio = new JRadioButton("Sample text");
        radioButtonsPanel.add((Component)this.sampleTextRadio, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.sampleTextRadio.setSelected(true);
        this.glyphCacheRadio = new JRadioButton("Glyph cache");
        radioButtonsPanel.add((Component)this.glyphCacheRadio, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        radioButtonsPanel.add((Component)new JLabel("Background:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.backgroundColorLabel = new JLabel();
        radioButtonsPanel.add((Component)this.backgroundColorLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.glyphCacheRadio);
        buttonGroup2.add(this.sampleTextRadio);
        JPanel rightSidePanel = new JPanel();
        rightSidePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)rightSidePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new GridBagLayout());
        rightSidePanel.add((Component)paddingPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        paddingPanel.setBorder(BorderFactory.createTitledBorder("Padding"));
        this.padTopSpinner = new JSpinner();
        paddingPanel.add((Component)this.padTopSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ((JSpinner.DefaultEditor)this.padTopSpinner.getEditor()).getTextField().setColumns(2);
        this.padRightSpinner = new JSpinner();
        paddingPanel.add((Component)this.padRightSpinner, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        ((JSpinner.DefaultEditor)this.padRightSpinner.getEditor()).getTextField().setColumns(2);
        this.padLeftSpinner = new JSpinner();
        paddingPanel.add((Component)this.padLeftSpinner, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        ((JSpinner.DefaultEditor)this.padLeftSpinner.getEditor()).getTextField().setColumns(2);
        this.padBottomSpinner = new JSpinner();
        paddingPanel.add((Component)this.padBottomSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ((JSpinner.DefaultEditor)this.padBottomSpinner.getEditor()).getTextField().setColumns(2);
        JPanel advancePanel = new JPanel();
        FlowLayout advancePanelLayout = new FlowLayout();
        advancePanel.setLayout(advancePanelLayout);
        paddingPanel.add((Component)advancePanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        advancePanel.add(new JLabel("X:"));
        this.padAdvanceXSpinner = new JSpinner();
        advancePanel.add(this.padAdvanceXSpinner);
        ((JSpinner.DefaultEditor)this.padAdvanceXSpinner.getEditor()).getTextField().setColumns(2);
        advancePanel.add(new JLabel("Y:"));
        this.padAdvanceYSpinner = new JSpinner();
        advancePanel.add(this.padAdvanceYSpinner);
        ((JSpinner.DefaultEditor)this.padAdvanceYSpinner.getEditor()).getTextField().setColumns(2);
        JPanel effectsPanel = new JPanel();
        effectsPanel.setLayout(new GridBagLayout());
        rightSidePanel.add((Component)effectsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        effectsPanel.setBorder(BorderFactory.createTitledBorder("Effects"));
        effectsPanel.setMinimumSize(new Dimension(210, 1));
        JScrollPane effectsScroll = new JScrollPane();
        effectsPanel.add((Component)effectsScroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.effectsListModel = new DefaultComboBoxModel();
        this.effectsList = new JList();
        effectsScroll.setViewportView(this.effectsList);
        this.effectsList.setModel(this.effectsListModel);
        this.effectsList.setVisibleRowCount(6);
        effectsScroll.setMinimumSize(this.effectsList.getPreferredScrollableViewportSize());
        this.addEffectButton = new JButton("Add");
        effectsPanel.add((Component)this.addEffectButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 6, 5), 0, 0));
        this.addEffectButton.setEnabled(false);
        this.appliedEffectsScroll = new JScrollPane();
        effectsPanel.add((Component)this.appliedEffectsScroll, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.appliedEffectsScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.appliedEffectsScroll.setHorizontalScrollBarPolicy(31);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.appliedEffectsScroll.setViewportView(panel);
        this.appliedEffectsPanel = new JPanel();
        this.appliedEffectsPanel.setLayout(new GridBagLayout());
        panel.add((Component)this.appliedEffectsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.appliedEffectsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black));
    }

    private void initializeMenus() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu();
        menuBar.add(fileMenu);
        fileMenu.setText("File");
        fileMenu.setMnemonic(70);
        this.openMenuItem = new JMenuItem("Open Hiero settings file...");
        this.openMenuItem.setMnemonic(79);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(this.openMenuItem);
        this.saveMenuItem = new JMenuItem("Save Hiero settings file...");
        this.saveMenuItem.setMnemonic(83);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(this.saveMenuItem);
        fileMenu.addSeparator();
        this.saveBMFontMenuItem = new JMenuItem("Save BMFont files (text)...");
        this.saveBMFontMenuItem.setMnemonic(66);
        this.saveBMFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        fileMenu.add(this.saveBMFontMenuItem);
        fileMenu.addSeparator();
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.setMnemonic(88);
        fileMenu.add(this.exitMenuItem);
    }

    static Icon getColorIcon(Color color) {
        BufferedImage image = new BufferedImage(32, 16, 1);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(1, 1, 30, 14);
        g.setColor(Color.black);
        g.drawRect(0, 0, 31, 15);
        return new ImageIcon(image);
    }

    public static String getFontFile(Font font) {
        try {
            font.getFamily();
            Field font2DHandleField = Font.class.getDeclaredField("font2DHandle");
            font2DHandleField.setAccessible(true);
            Object font2DHandle = font2DHandleField.get(font);
            Field font2DField = font2DHandle.getClass().getDeclaredField("font2D");
            Object font2D = font2DField.get(font2DHandle);
            Field platNameField = Class.forName("sun.font.PhysicalFont").getDeclaredField("platName");
            platNameField.setAccessible(true);
            return (String)platNameField.get(font2D);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeels.length;
        for (int i = 0; i < n; ++i) {
            if (!"Nimbus".equals(lookAndFeels[i].getName())) continue;
            try {
                UIManager.setLookAndFeel(lookAndFeels[i].getClassName());
            }
            catch (Throwable ignored) {}
            break;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Hiero4();
            }
        });
    }

    class Renderer
    implements ApplicationListener {
        SpriteBatch batch;
        BitmapFont font;

        Renderer() {
        }

        public void create() {
            this.batch = new SpriteBatch();
            Hiero4.this.changeFont();
        }

        public void resize(int width, int height) {
            GL11.glViewport((int)0, (int)0, (int)width, (int)height);
            this.batch.getProjectionMatrix().setToOrtho(0.0f, (float)width, 0.0f, (float)height, 0.0f, 1.0f);
        }

        public void render() {
            int viewWidth = Gdx.graphics.getWidth();
            int viewHeight = Gdx.graphics.getHeight();
            BitmapFont font = this.font;
            if (font == null) {
                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glClear((int)16384);
                return;
            }
            if (Hiero4.this.sampleTextRadio.isSelected()) {
                GL11.glClearColor((float)Hiero4.this.renderingBackgroundColor.r, (float)Hiero4.this.renderingBackgroundColor.g, (float)Hiero4.this.renderingBackgroundColor.b, (float)Hiero4.this.renderingBackgroundColor.a);
                GL11.glClear((int)16384);
                this.batch.begin();
                font.drawWrapped((Batch)this.batch, (CharSequence)Hiero4.this.sampleTextPane.getText(), 0.0f, (float)viewHeight, (float)viewWidth);
                this.batch.end();
            } else {
                GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glClear((int)16384);
                TextureRegion region = font.getRegion();
                float y = viewHeight - region.getRegionHeight();
                GL11.glColor4f((float)Hiero4.this.renderingBackgroundColor.r, (float)Hiero4.this.renderingBackgroundColor.g, (float)Hiero4.this.renderingBackgroundColor.b, (float)0.0f);
                GL11.glBegin((int)7);
                GL11.glVertex3f((float)0.0f, (float)(y + (float)region.getRegionHeight()), (float)0.0f);
                GL11.glVertex3f((float)0.0f, (float)y, (float)0.0f);
                GL11.glVertex3f((float)region.getRegionWidth(), (float)y, (float)0.0f);
                GL11.glVertex3f((float)region.getRegionWidth(), (float)(y + (float)region.getRegionHeight()), (float)0.0f);
                GL11.glEnd();
                this.batch.begin();
                this.batch.draw(region, 0.0f, y);
                this.batch.end();
            }
        }

        public void pause() {
        }

        public void resume() {
        }

        public void dispose() {
        }
    }

    private static class Splash
    extends JWindow {
        final int minMillis;
        final long startTime;

        public Splash(Frame frame, String imageFile, int minMillis) {
            super(frame);
            this.minMillis = minMillis;
            this.getContentPane().add((Component)new JLabel(new ImageIcon(Splash.class.getResource(imageFile))), "Center");
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.startTime = System.currentTimeMillis();
        }

        public void close() {
            final long endTime = System.currentTimeMillis();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (endTime - Splash.this.startTime < (long)Splash.this.minMillis) {
                        Splash.this.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent evt) {
                                Splash.this.dispose();
                            }
                        });
                        try {
                            Thread.sleep((long)Splash.this.minMillis - (endTime - Splash.this.startTime));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Splash.this.dispose();
                        }
                    });
                }
            }, "Splash").start();
        }
    }
}

