/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.jglfw;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.InputProcessorQueue;
import com.badlogic.gdx.backends.jglfw.JglfwApplication;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.jglfw.Glfw;
import com.badlogic.jglfw.GlfwCallback;
import com.badlogic.jglfw.GlfwCallbackAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JglfwInput
implements Input {
    final JglfwApplication app;
    final InputProcessorQueue processorQueue;
    InputProcessor processor;
    int pressedKeys = 0;
    boolean keyJustPressed = false;
    boolean[] justPressedKeys = new boolean[256];
    boolean justTouched;
    int deltaX;
    int deltaY;
    long currentEventTime;

    public JglfwInput(final JglfwApplication app, boolean queueEvents) {
        this.app = app;
        InputProcessor inputProcessor = new InputProcessor(){
            private int mouseX;
            private int mouseY;

            public boolean keyDown(int keycode) {
                ++JglfwInput.this.pressedKeys;
                JglfwInput.this.keyJustPressed = true;
                JglfwInput.this.justPressedKeys[keycode] = true;
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.keyDown(keycode) : false;
            }

            public boolean keyUp(int keycode) {
                --JglfwInput.this.pressedKeys;
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.keyUp(keycode) : false;
            }

            public boolean keyTyped(char character) {
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.keyTyped(character) : false;
            }

            public boolean touchDown(int screenX, int screenY, int pointer, int button) {
                JglfwInput.this.justTouched = true;
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.touchDown(screenX, screenY, pointer, button) : false;
            }

            public boolean touchUp(int screenX, int screenY, int pointer, int button) {
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.touchUp(screenX, screenY, pointer, button) : false;
            }

            public boolean touchDragged(int screenX, int screenY, int pointer) {
                JglfwInput.this.deltaX = screenX - this.mouseX;
                JglfwInput.this.deltaY = screenY - this.mouseY;
                this.mouseX = screenX;
                this.mouseY = screenY;
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.touchDragged(this.mouseX, this.mouseY, 0) : false;
            }

            public boolean mouseMoved(int screenX, int screenY) {
                JglfwInput.this.deltaX = screenX - this.mouseX;
                JglfwInput.this.deltaY = screenY - this.mouseY;
                this.mouseX = screenX;
                this.mouseY = screenY;
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.mouseMoved(this.mouseX, this.mouseY) : false;
            }

            public boolean scrolled(int amount) {
                app.graphics.requestRendering();
                return JglfwInput.this.processor != null ? JglfwInput.this.processor.scrolled(amount) : false;
            }
        };
        if (queueEvents) {
            this.processorQueue = new InputProcessorQueue(inputProcessor);
            inputProcessor = this.processorQueue;
        } else {
            this.processorQueue = null;
        }
        app.getCallbacks().add((GlfwCallback)new GlfwInputProcessor(inputProcessor));
    }

    public void update() {
        this.deltaX = 0;
        this.deltaY = 0;
        this.justTouched = false;
        if (this.keyJustPressed) {
            this.keyJustPressed = false;
            for (int i = 0; i < this.justPressedKeys.length; ++i) {
                this.justPressedKeys[i] = false;
            }
        }
        if (this.processorQueue != null) {
            this.processorQueue.drain();
        } else {
            this.currentEventTime = System.nanoTime();
            Glfw.glfwPollEvents();
        }
    }

    public float getAccelerometerX() {
        return 0.0f;
    }

    public float getAccelerometerY() {
        return 0.0f;
    }

    public float getAccelerometerZ() {
        return 0.0f;
    }

    public int getX() {
        return Glfw.glfwGetCursorPosX((long)this.app.graphics.window);
    }

    public int getX(int pointer) {
        return pointer > 0 ? 0 : this.getX();
    }

    public int getY() {
        return Glfw.glfwGetCursorPosY((long)this.app.graphics.window);
    }

    public int getY(int pointer) {
        return pointer > 0 ? 0 : this.getY();
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaX(int pointer) {
        return pointer > 0 ? 0 : this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public int getDeltaY(int pointer) {
        return pointer > 0 ? 0 : this.deltaY;
    }

    public boolean isTouched() {
        return Glfw.glfwGetMouseButton((long)this.app.graphics.window, (int)0) || Glfw.glfwGetMouseButton((long)this.app.graphics.window, (int)1) || Glfw.glfwGetMouseButton((long)this.app.graphics.window, (int)2);
    }

    public boolean isTouched(int pointer) {
        return pointer > 0 ? false : this.isTouched();
    }

    public boolean justTouched() {
        return this.justTouched;
    }

    public boolean isButtonPressed(int button) {
        return Glfw.glfwGetMouseButton((long)this.app.graphics.window, (int)button);
    }

    public boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.pressedKeys > 0;
        }
        if (key == 63) {
            return Glfw.glfwGetKey((long)this.app.graphics.window, (int)343) || Glfw.glfwGetKey((long)this.app.graphics.window, (int)347);
        }
        return Glfw.glfwGetKey((long)this.app.graphics.window, (int)JglfwInput.getJglfwKeyCode(key));
    }

    public boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > 256) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    public void vibrate(int milliseconds) {
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public float getAzimuth() {
        return 0.0f;
    }

    public float getPitch() {
        return 0.0f;
    }

    public float getRoll() {
        return 0.0f;
    }

    public void getRotationMatrix(float[] matrix) {
    }

    public long getCurrentEventTime() {
        return this.processorQueue != null ? this.processorQueue.getCurrentEventTime() : this.currentEventTime;
    }

    public void setCatchBackKey(boolean catchBack) {
    }

    public boolean isCatchBackKey() {
        return false;
    }

    public void setCatchMenuKey(boolean catchMenu) {
    }

    public void setInputProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        return peripheral == Input.Peripheral.HardwareKeyboard;
    }

    public int getRotation() {
        return 0;
    }

    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    public void setCursorCatched(boolean captured) {
        Glfw.glfwSetInputMode((long)this.app.graphics.window, (int)196609, (int)(captured ? 262147 : 262145));
    }

    public boolean isCursorCatched() {
        return Glfw.glfwGetInputMode((long)this.app.graphics.window, (int)196609) == 262147;
    }

    public void setCursorPosition(int x, int y) {
        Glfw.glfwSetCursorPos((long)this.app.graphics.window, (int)x, (int)y);
    }

    public void setCursorImage(Pixmap pixmap, int xHotspot, int yHotspot) {
    }

    public void getTextInput(final Input.TextInputListener listener, final String title, final String text, final String hint) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel(new FlowLayout());
                JPanel textPanel = new JPanel(){

                    @Override
                    public boolean isOptimizedDrawingEnabled() {
                        return false;
                    }
                };
                textPanel.setLayout(new OverlayLayout(textPanel));
                panel.add(textPanel);
                final JTextField textField = new JTextField(20);
                textField.setText(text);
                textField.setAlignmentX(0.0f);
                textPanel.add(textField);
                final JLabel placeholderLabel = new JLabel(hint);
                placeholderLabel.setForeground(Color.GRAY);
                placeholderLabel.setAlignmentX(0.0f);
                textPanel.add((Component)placeholderLabel, 0);
                textField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent event) {
                        this.updated();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent event) {
                        this.updated();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent event) {
                        this.updated();
                    }

                    private void updated() {
                        placeholderLabel.setVisible(textField.getText().length() == 0);
                    }
                });
                JOptionPane pane = new JOptionPane(panel, 3, 2, null, null, null);
                pane.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
                pane.selectInitialValue();
                placeholderLabel.setBorder(new EmptyBorder(textField.getBorder().getBorderInsets(textField)));
                JDialog dialog = pane.createDialog(null, title);
                dialog.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowLostFocus(WindowEvent arg0) {
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent arg0) {
                        textField.requestFocusInWindow();
                    }
                });
                dialog.setVisible(true);
                dialog.dispose();
                Object selectedValue = pane.getValue();
                if (selectedValue != null && selectedValue instanceof Integer && (Integer)selectedValue == 0) {
                    listener.input(textField.getText());
                } else {
                    listener.canceled();
                }
            }
        });
    }

    static char characterForKeyCode(int key) {
        switch (key) {
            case 67: {
                return '\b';
            }
            case 61: {
                return '\t';
            }
            case 112: {
                return '\u007f';
            }
        }
        return '\u0000';
    }

    public static int getGdxKeyCode(int lwjglKeyCode) {
        switch (lwjglKeyCode) {
            case 32: {
                return 62;
            }
            case 39: {
                return 75;
            }
            case 44: {
                return 55;
            }
            case 45: {
                return 69;
            }
            case 46: {
                return 56;
            }
            case 47: {
                return 76;
            }
            case 48: {
                return 7;
            }
            case 49: {
                return 8;
            }
            case 50: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 11;
            }
            case 53: {
                return 12;
            }
            case 54: {
                return 13;
            }
            case 55: {
                return 14;
            }
            case 56: {
                return 15;
            }
            case 57: {
                return 16;
            }
            case 59: {
                return 74;
            }
            case 61: {
                return 70;
            }
            case 65: {
                return 29;
            }
            case 66: {
                return 30;
            }
            case 67: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 69: {
                return 33;
            }
            case 70: {
                return 34;
            }
            case 71: {
                return 35;
            }
            case 72: {
                return 36;
            }
            case 73: {
                return 37;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 39;
            }
            case 76: {
                return 40;
            }
            case 77: {
                return 41;
            }
            case 78: {
                return 42;
            }
            case 79: {
                return 43;
            }
            case 80: {
                return 44;
            }
            case 81: {
                return 45;
            }
            case 82: {
                return 46;
            }
            case 83: {
                return 47;
            }
            case 84: {
                return 48;
            }
            case 85: {
                return 49;
            }
            case 86: {
                return 50;
            }
            case 87: {
                return 51;
            }
            case 88: {
                return 52;
            }
            case 89: {
                return 53;
            }
            case 90: {
                return 54;
            }
            case 91: {
                return 71;
            }
            case 92: {
                return 73;
            }
            case 93: {
                return 72;
            }
            case 96: {
                return 68;
            }
            case 161: 
            case 162: {
                return 0;
            }
            case 256: {
                return 131;
            }
            case 257: {
                return 66;
            }
            case 258: {
                return 61;
            }
            case 259: {
                return 67;
            }
            case 260: {
                return 133;
            }
            case 261: {
                return 112;
            }
            case 262: {
                return 22;
            }
            case 263: {
                return 21;
            }
            case 264: {
                return 20;
            }
            case 265: {
                return 19;
            }
            case 266: {
                return 92;
            }
            case 267: {
                return 93;
            }
            case 268: {
                return 3;
            }
            case 269: {
                return 132;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: {
                return 0;
            }
            case 290: {
                return 244;
            }
            case 291: {
                return 245;
            }
            case 292: {
                return 246;
            }
            case 293: {
                return 247;
            }
            case 294: {
                return 248;
            }
            case 295: {
                return 249;
            }
            case 296: {
                return 250;
            }
            case 297: {
                return 251;
            }
            case 298: {
                return 252;
            }
            case 299: {
                return 253;
            }
            case 300: {
                return 254;
            }
            case 301: {
                return 255;
            }
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: {
                return 0;
            }
            case 320: {
                return 144;
            }
            case 321: {
                return 145;
            }
            case 322: {
                return 146;
            }
            case 323: {
                return 147;
            }
            case 324: {
                return 148;
            }
            case 325: {
                return 149;
            }
            case 326: {
                return 150;
            }
            case 327: {
                return 151;
            }
            case 328: {
                return 152;
            }
            case 329: {
                return 153;
            }
            case 330: {
                return 56;
            }
            case 331: {
                return 76;
            }
            case 332: {
                return 17;
            }
            case 333: {
                return 69;
            }
            case 334: {
                return 81;
            }
            case 335: {
                return 66;
            }
            case 336: {
                return 70;
            }
            case 340: {
                return 59;
            }
            case 341: {
                return 129;
            }
            case 342: {
                return 57;
            }
            case 343: {
                return 63;
            }
            case 344: {
                return 60;
            }
            case 345: {
                return 130;
            }
            case 346: {
                return 58;
            }
            case 347: {
                return 63;
            }
            case 348: {
                return 82;
            }
        }
        return 0;
    }

    public static int getJglfwKeyCode(int gdxKeyCode) {
        switch (gdxKeyCode) {
            case 62: {
                return 32;
            }
            case 75: {
                return 39;
            }
            case 55: {
                return 44;
            }
            case 56: {
                return 46;
            }
            case 7: {
                return 48;
            }
            case 8: {
                return 49;
            }
            case 9: {
                return 50;
            }
            case 10: {
                return 51;
            }
            case 11: {
                return 52;
            }
            case 12: {
                return 53;
            }
            case 13: {
                return 54;
            }
            case 14: {
                return 55;
            }
            case 15: {
                return 56;
            }
            case 16: {
                return 57;
            }
            case 74: {
                return 59;
            }
            case 70: {
                return 61;
            }
            case 29: {
                return 65;
            }
            case 30: {
                return 66;
            }
            case 31: {
                return 67;
            }
            case 32: {
                return 68;
            }
            case 33: {
                return 69;
            }
            case 34: {
                return 70;
            }
            case 35: {
                return 71;
            }
            case 36: {
                return 72;
            }
            case 37: {
                return 73;
            }
            case 38: {
                return 74;
            }
            case 39: {
                return 75;
            }
            case 40: {
                return 76;
            }
            case 41: {
                return 77;
            }
            case 42: {
                return 78;
            }
            case 43: {
                return 79;
            }
            case 44: {
                return 80;
            }
            case 45: {
                return 81;
            }
            case 46: {
                return 82;
            }
            case 47: {
                return 83;
            }
            case 48: {
                return 84;
            }
            case 49: {
                return 85;
            }
            case 50: {
                return 86;
            }
            case 51: {
                return 87;
            }
            case 52: {
                return 88;
            }
            case 53: {
                return 89;
            }
            case 54: {
                return 90;
            }
            case 71: {
                return 91;
            }
            case 73: {
                return 92;
            }
            case 72: {
                return 93;
            }
            case 68: {
                return 96;
            }
            case 131: {
                return 256;
            }
            case 66: {
                return 257;
            }
            case 61: {
                return 258;
            }
            case 67: {
                return 259;
            }
            case 133: {
                return 260;
            }
            case 112: {
                return 261;
            }
            case 22: {
                return 262;
            }
            case 21: {
                return 263;
            }
            case 20: {
                return 264;
            }
            case 19: {
                return 265;
            }
            case 92: {
                return 266;
            }
            case 93: {
                return 267;
            }
            case 3: {
                return 268;
            }
            case 132: {
                return 269;
            }
            case 244: {
                return 290;
            }
            case 245: {
                return 291;
            }
            case 246: {
                return 292;
            }
            case 247: {
                return 293;
            }
            case 248: {
                return 294;
            }
            case 249: {
                return 295;
            }
            case 250: {
                return 296;
            }
            case 251: {
                return 297;
            }
            case 252: {
                return 298;
            }
            case 253: {
                return 299;
            }
            case 254: {
                return 300;
            }
            case 255: {
                return 301;
            }
            case 144: {
                return 320;
            }
            case 145: {
                return 321;
            }
            case 146: {
                return 322;
            }
            case 147: {
                return 323;
            }
            case 148: {
                return 324;
            }
            case 149: {
                return 325;
            }
            case 150: {
                return 326;
            }
            case 151: {
                return 327;
            }
            case 152: {
                return 328;
            }
            case 153: {
                return 329;
            }
            case 76: {
                return 331;
            }
            case 17: {
                return 332;
            }
            case 69: {
                return 333;
            }
            case 81: {
                return 334;
            }
            case 59: {
                return 340;
            }
            case 129: {
                return 341;
            }
            case 57: {
                return 342;
            }
            case 63: {
                return 343;
            }
            case 60: {
                return 344;
            }
            case 130: {
                return 345;
            }
            case 58: {
                return 346;
            }
            case 82: {
                return 348;
            }
        }
        return 0;
    }

    static class GlfwInputProcessor
    extends GlfwCallbackAdapter {
        private int mouseX;
        private int mouseY;
        private int mousePressed;
        private char lastCharacter;
        private InputProcessor processor;

        public GlfwInputProcessor(InputProcessor processor) {
            if (processor == null) {
                throw new IllegalArgumentException("processor cannot be null.");
            }
            this.processor = processor;
        }

        public void key(long window, int key, int action) {
            switch (action) {
                case 1: {
                    key = JglfwInput.getGdxKeyCode(key);
                    this.processor.keyDown(key);
                    this.lastCharacter = '\u0000';
                    char character = JglfwInput.characterForKeyCode(key);
                    if (character == '\u0000') break;
                    this.character(window, character);
                    break;
                }
                case 0: {
                    this.processor.keyUp(JglfwInput.getGdxKeyCode(key));
                    break;
                }
                case 2: {
                    if (this.lastCharacter == '\u0000') break;
                    this.processor.keyTyped(this.lastCharacter);
                }
            }
        }

        public void character(long window, char character) {
            if ((character & 0xFF00) == 63232) {
                return;
            }
            this.lastCharacter = character;
            this.processor.keyTyped(character);
        }

        public void scroll(long window, double scrollX, double scrollY) {
            this.processor.scrolled((int)(-Math.signum(scrollY)));
        }

        private int toGdxButton(int button) {
            if (button == 0) {
                return 0;
            }
            if (button == 1) {
                return 1;
            }
            if (button == 2) {
                return 2;
            }
            if (button == 3) {
                return 3;
            }
            if (button == 4) {
                return 4;
            }
            return -1;
        }

        public void mouseButton(long window, int button, boolean pressed) {
            int gdxButton = this.toGdxButton(button);
            if (button != -1 && gdxButton == -1) {
                return;
            }
            if (pressed) {
                ++this.mousePressed;
                this.processor.touchDown(this.mouseX, this.mouseY, 0, gdxButton);
            } else {
                this.mousePressed = Math.max(0, this.mousePressed - 1);
                this.processor.touchUp(this.mouseX, this.mouseY, 0, gdxButton);
            }
        }

        public void cursorPos(long window, int x, int y) {
            this.mouseX = x;
            this.mouseY = y;
            if (this.mousePressed > 0) {
                this.processor.touchDragged(x, y, 0);
            } else {
                this.processor.mouseMoved(x, y);
            }
        }
    }
}

