/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.jglfw;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.jglfw.JglfwGraphics;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;

public class JglfwApplicationConfiguration {
    public String title = "";
    public int width = 640;
    public int height = 480;
    public int x = -1;
    public int y = -1;
    public boolean fullscreen;
    public int fullscreenMonitorIndex = -1;
    public int r = 8;
    public int g = 8;
    public int b = 8;
    public int a = 8;
    public int depth = 16;
    public int stencil = 0;
    public int samples = 0;
    public boolean vSync = true;
    public boolean resizable = true;
    public boolean forceExit = true;
    public boolean undecorated;
    public boolean runOnEDT;
    public Color initialBackgroundColor = Color.BLACK;
    public boolean hidden;
    public int foregroundFPS;
    public int backgroundFPS;
    public int hiddenFPS = -1;
    public String preferencesLocation = ".prefs/";

    public static Graphics.DisplayMode[] getDisplayModes() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode desktopMode = device.getDisplayMode();
        DisplayMode[] displayModes = device.getDisplayModes();
        Array modes = new Array();
        block0: for (DisplayMode mode : displayModes) {
            for (Graphics.DisplayMode other : modes) {
                if (other.width != mode.getWidth() || other.height != mode.getHeight() || other.bitsPerPixel != mode.getBitDepth()) continue;
                continue block0;
            }
            if (mode.getBitDepth() != desktopMode.getBitDepth()) continue;
            modes.add((Object)new JglfwGraphics.JglfwDisplayMode(mode.getWidth(), mode.getHeight(), mode.getRefreshRate(), mode.getBitDepth()));
        }
        return (Graphics.DisplayMode[])modes.toArray(Graphics.DisplayMode.class);
    }

    public static Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMode mode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        return new JglfwGraphics.JglfwDisplayMode(mode.getWidth(), mode.getHeight(), mode.getRefreshRate(), mode.getBitDepth());
    }
}

