/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.jglfw;

import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.jglfw.gl.GL;
import com.badlogic.jglfw.utils.Memory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class JglfwGL20
implements GL20 {
    private ByteBuffer buffer = null;
    private FloatBuffer floatBuffer = null;
    private IntBuffer intBuffer = null;

    private void ensureBufferCapacity(int numBytes) {
        if (this.buffer == null || this.buffer.capacity() < numBytes) {
            this.buffer = BufferUtils.newByteBuffer((int)numBytes);
            this.floatBuffer = this.buffer.asFloatBuffer();
            this.intBuffer = this.buffer.asIntBuffer();
        }
    }

    private FloatBuffer toFloatBuffer(float[] v, int offset, int count) {
        this.ensureBufferCapacity(count << 2);
        this.floatBuffer.clear();
        BufferUtils.copy((float[])v, (Buffer)this.floatBuffer, (int)count, (int)offset);
        return this.floatBuffer;
    }

    private IntBuffer toIntBuffer(int[] v, int offset, int count) {
        this.ensureBufferCapacity(count << 2);
        this.intBuffer.clear();
        BufferUtils.copy((int[])v, (int)count, (int)offset, (Buffer)this.intBuffer);
        return this.intBuffer;
    }

    private IntBuffer toIntBuffer(int v) {
        this.ensureBufferCapacity(4);
        this.intBuffer.put(0, v);
        this.intBuffer.position(0);
        this.intBuffer.limit(1);
        return this.intBuffer;
    }

    public void glActiveTexture(int texture) {
        GL.glActiveTexture((int)texture);
    }

    public void glBindTexture(int target, int texture) {
        GL.glBindTexture((int)target, (int)texture);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        GL.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public void glClear(int mask) {
        GL.glClear((int)mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        GL.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glClearDepthf(float depth) {
        GL.glClearDepthf((float)depth);
    }

    public void glClearStencil(int s) {
        GL.glClearStencil((int)s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        GL.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)imageSize, (Buffer)data, (int)Memory.getPosition((Buffer)data));
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        GL.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)imageSize, (Buffer)data, (int)Memory.getPosition((Buffer)data));
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GL.glCopyTexImage2D((int)target, (int)level, (int)internalformat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public void glCullFace(int mode) {
        GL.glCullFace((int)mode);
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        GL.glDeleteTextures((int)n, (Buffer)textures, (int)Memory.getPosition((Buffer)textures));
    }

    public void glDeleteTexture(int texture) {
        this.glDeleteTextures(1, this.toIntBuffer(texture));
    }

    public void glDepthFunc(int func) {
        GL.glDepthFunc((int)func);
    }

    public void glDepthMask(boolean flag) {
        GL.glDepthMask((boolean)flag);
    }

    public void glDepthRangef(float zNear, float zFar) {
        GL.glDepthRangef((float)zNear, (float)zFar);
    }

    public void glDisable(int cap) {
        GL.glDisable((int)cap);
    }

    public void glDrawArrays(int mode, int first, int count) {
        GL.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        GL.glDrawElements((int)mode, (int)count, (int)type, (Buffer)indices, (int)Memory.getPosition((Buffer)indices));
    }

    public void glEnable(int cap) {
        GL.glEnable((int)cap);
    }

    public void glFinish() {
        GL.glFinish();
    }

    public void glFlush() {
        GL.glFlush();
    }

    public void glFrontFace(int mode) {
        GL.glFrontFace((int)mode);
    }

    public void glGenTextures(int n, IntBuffer textures) {
        GL.glGenTextures((int)n, (Buffer)textures, (int)Memory.getPosition((Buffer)textures));
    }

    public int glGenTexture() {
        this.ensureBufferCapacity(4);
        this.intBuffer.position(0);
        this.intBuffer.limit(1);
        this.glGenTextures(1, this.intBuffer);
        return this.intBuffer.get(0);
    }

    public int glGetError() {
        return GL.glGetError();
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        GL.glGetIntegerv((int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public String glGetString(int name) {
        return GL.glGetString((int)name);
    }

    public void glHint(int target, int mode) {
        GL.glHint((int)target, (int)mode);
    }

    public void glLineWidth(float width) {
        GL.glLineWidth((float)width);
    }

    public void glPixelStorei(int pname, int param) {
        GL.glPixelStorei((int)pname, (int)param);
    }

    public void glPolygonOffset(float factor, float units) {
        GL.glPolygonOffset((float)factor, (float)units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        GL.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)pixels, (int)Memory.getPosition((Buffer)pixels));
    }

    public void glScissor(int x, int y, int width, int height) {
        GL.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public void glStencilFunc(int func, int ref, int mask) {
        GL.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public void glStencilMask(int mask) {
        GL.glStencilMask((int)mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        GL.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer pixels) {
        GL.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (Buffer)pixels, (int)Memory.getPosition((Buffer)pixels));
    }

    public void glTexParameterf(int target, int pname, float param) {
        GL.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        GL.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (Buffer)pixels, (int)Memory.getPosition((Buffer)pixels));
    }

    public void glViewport(int x, int y, int width, int height) {
        GL.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        GL.glGetFloatv((int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        GL.glGetTexParameterfv((int)target, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        GL.glTexParameterfv((int)target, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glBindBuffer(int target, int buffer) {
        GL.glBindBuffer((int)target, (int)buffer);
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        GL.glBufferData((int)target, (long)size, (Buffer)data, (int)Memory.getPosition((Buffer)data), (int)usage);
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        GL.glBufferSubData((int)target, (long)offset, (long)size, (Buffer)data, (int)Memory.getPosition((Buffer)data));
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        GL.glDeleteBuffers((int)n, (Buffer)buffers, (int)Memory.getPosition((Buffer)buffers));
    }

    public void glDeleteBuffer(int buffer) {
        this.glDeleteBuffers(1, this.toIntBuffer(buffer));
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        GL.glGetBufferParameteriv((int)target, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        GL.glGenBuffers((int)n, (Buffer)buffers, (int)Memory.getPosition((Buffer)buffers));
    }

    public int glGenBuffer() {
        this.ensureBufferCapacity(4);
        this.intBuffer.position(0);
        this.intBuffer.limit(1);
        this.glGenBuffers(1, this.intBuffer);
        return this.intBuffer.get(0);
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        GL.glGetTexParameteriv((int)target, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public boolean glIsBuffer(int buffer) {
        return GL.glIsBuffer((int)buffer);
    }

    public boolean glIsEnabled(int cap) {
        return GL.glIsEnabled((int)cap);
    }

    public boolean glIsTexture(int texture) {
        return GL.glIsTexture((int)texture);
    }

    public void glTexParameteri(int target, int pname, int param) {
        GL.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        GL.glTexParameteriv((int)target, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glDrawElements(int mode, int count, int type, int indices) {
        GL.glDrawElements((int)mode, (int)count, (int)type, (long)indices);
    }

    public void glAttachShader(int program, int shader) {
        GL.glAttachShader((int)program, (int)shader);
    }

    public void glBindAttribLocation(int program, int index, String name) {
        GL.glBindAttribLocation((int)program, (int)index, (String)name);
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        GL.glBindFramebufferEXT((int)target, (int)framebuffer);
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        GL.glBindRenderbufferEXT((int)target, (int)renderbuffer);
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        GL.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glBlendEquation(int mode) {
        GL.glBlendEquation((int)mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        GL.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GL.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public int glCheckFramebufferStatus(int target) {
        return GL.glCheckFramebufferStatusEXT((int)target);
    }

    public void glCompileShader(int shader) {
        GL.glCompileShader((int)shader);
    }

    public int glCreateProgram() {
        return GL.glCreateProgram();
    }

    public int glCreateShader(int type) {
        return GL.glCreateShader((int)type);
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        GL.glDeleteFramebuffersEXT((int)n, (Buffer)framebuffers, (int)Memory.getPosition((Buffer)framebuffers));
    }

    public void glDeleteFramebuffer(int framebuffer) {
        this.glDeleteFramebuffers(1, this.toIntBuffer(framebuffer));
    }

    public void glDeleteProgram(int program) {
        GL.glDeleteProgram((int)program);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        GL.glDeleteRenderbuffersEXT((int)n, (Buffer)renderbuffers, (int)Memory.getPosition((Buffer)renderbuffers));
    }

    public void glDeleteRenderbuffer(int renderbuffer) {
        this.glDeleteRenderbuffers(1, this.toIntBuffer(renderbuffer));
    }

    public void glDeleteShader(int shader) {
        GL.glDeleteShader((int)shader);
    }

    public void glDetachShader(int program, int shader) {
        GL.glDetachShader((int)program, (int)shader);
    }

    public void glDisableVertexAttribArray(int index) {
        GL.glDisableVertexAttribArray((int)index);
    }

    public void glEnableVertexAttribArray(int index) {
        GL.glEnableVertexAttribArray((int)index);
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GL.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GL.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public void glGenerateMipmap(int target) {
        GL.glGenerateMipmapEXT((int)target);
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        GL.glGenFramebuffersEXT((int)n, (Buffer)framebuffers, (int)Memory.getPosition((Buffer)framebuffers));
    }

    public int glGenFramebuffer() {
        this.ensureBufferCapacity(4);
        this.intBuffer.position(0);
        this.intBuffer.limit(1);
        this.glGenFramebuffers(1, this.intBuffer);
        return this.intBuffer.get(0);
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        GL.glGenRenderbuffersEXT((int)n, (Buffer)renderbuffers, (int)Memory.getPosition((Buffer)renderbuffers));
    }

    public int glGenRenderbuffer() {
        this.ensureBufferCapacity(4);
        this.intBuffer.position(0);
        this.intBuffer.limit(1);
        this.glGenRenderbuffers(1, this.intBuffer);
        return this.intBuffer.get(0);
    }

    public String glGetActiveAttrib(int program, int index, IntBuffer size, Buffer type) {
        return GL.glGetActiveAttrib((int)program, (int)index, (Buffer)size, (int)Memory.getPosition((Buffer)size), (Buffer)type, (int)Memory.getPosition((Buffer)type));
    }

    public String glGetActiveUniform(int program, int index, IntBuffer size, Buffer type) {
        return GL.glGetActiveUniform((int)program, (int)index, (Buffer)size, (int)Memory.getPosition((Buffer)size), (Buffer)type, (int)Memory.getPosition((Buffer)type));
    }

    public void glGetAttachedShaders(int program, int maxcount, Buffer count, IntBuffer shaders) {
        GL.glGetAttachedShaders((int)program, (int)maxcount, (Buffer)count, (int)Memory.getPosition((Buffer)count), (Buffer)shaders, (int)Memory.getPosition((Buffer)shaders));
    }

    public int glGetAttribLocation(int program, String name) {
        return GL.glGetAttribLocation((int)program, (String)name);
    }

    public void glGetBooleanv(int pname, Buffer params) {
        GL.glGetBooleanv((int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        GL.glGetFramebufferAttachmentParameterivEXT((int)target, (int)attachment, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        GL.glGetProgramiv((int)program, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public String glGetProgramInfoLog(int program) {
        return GL.glGetProgramInfoLog((int)program);
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        GL.glGetRenderbufferParameterivEXT((int)target, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        GL.glGetShaderiv((int)shader, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public String glGetShaderInfoLog(int shader) {
        return GL.glGetShaderInfoLog((int)shader);
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        GL.glGetShaderPrecisionFormat((int)shadertype, (int)precisiontype, (Buffer)range, (int)Memory.getPosition((Buffer)range), (Buffer)precision, (int)Memory.getPosition((Buffer)precision));
    }

    public void glGetShaderSource(int shader, int bufsize, Buffer length, String source) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        GL.glGetUniformfv((int)program, (int)location, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        GL.glGetUniformiv((int)program, (int)location, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public int glGetUniformLocation(int program, String name) {
        return GL.glGetUniformLocation((int)program, (String)name);
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        GL.glGetVertexAttribfv((int)index, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        GL.glGetVertexAttribiv((int)index, (int)pname, (Buffer)params, (int)Memory.getPosition((Buffer)params));
    }

    public void glGetVertexAttribPointerv(int index, int pname, Buffer pointer) {
        GL.glGetVertexAttribPointerv((int)index, (int)pname, (Buffer)pointer, (int)Memory.getPosition((Buffer)pointer));
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return GL.glIsFramebufferEXT((int)framebuffer);
    }

    public boolean glIsProgram(int program) {
        return GL.glIsProgram((int)program);
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return GL.glIsRenderbufferEXT((int)renderbuffer);
    }

    public boolean glIsShader(int shader) {
        return GL.glIsShader((int)shader);
    }

    public void glLinkProgram(int program) {
        GL.glLinkProgram((int)program);
    }

    public void glReleaseShaderCompiler() {
        GL.glReleaseShaderCompiler();
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GL.glRenderbufferStorageEXT((int)target, (int)internalformat, (int)width, (int)height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        GL.glSampleCoverage((float)value, (boolean)invert);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        GL.glShaderBinary((int)n, (Buffer)shaders, (int)Memory.getPosition((Buffer)shaders), (int)binaryformat, (Buffer)binary, (int)Memory.getPosition((Buffer)binary), (int)length);
    }

    public void glShaderSource(int shader, String string) {
        GL.glShaderSource((int)shader, (String)string);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GL.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        GL.glStencilMaskSeparate((int)face, (int)mask);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        GL.glStencilOpSeparate((int)face, (int)fail, (int)zfail, (int)zpass);
    }

    public void glUniform1f(int location, float x) {
        GL.glUniform1f((int)location, (float)x);
    }

    public void glUniform1fv(int location, int count, FloatBuffer v) {
        GL.glUniform1fv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform1fv(int location, int count, float[] v, int offset) {
        this.glUniform1fv(location, count, this.toFloatBuffer(v, offset, count));
    }

    public void glUniform1i(int location, int x) {
        GL.glUniform1i((int)location, (int)x);
    }

    public void glUniform1iv(int location, int count, IntBuffer v) {
        GL.glUniform1iv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform1iv(int location, int count, int[] v, int offset) {
        this.glUniform1iv(location, count, this.toIntBuffer(v, offset, count));
    }

    public void glUniform2f(int location, float x, float y) {
        GL.glUniform2f((int)location, (float)x, (float)y);
    }

    public void glUniform2fv(int location, int count, FloatBuffer v) {
        GL.glUniform2fv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform2fv(int location, int count, float[] v, int offset) {
        this.glUniform2fv(location, count, this.toFloatBuffer(v, offset, count << 1));
    }

    public void glUniform2i(int location, int x, int y) {
        GL.glUniform2i((int)location, (int)x, (int)y);
    }

    public void glUniform2iv(int location, int count, IntBuffer v) {
        GL.glUniform2iv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform2iv(int location, int count, int[] v, int offset) {
        this.glUniform2iv(location, count, this.toIntBuffer(v, offset, count << 1));
    }

    public void glUniform3f(int location, float x, float y, float z) {
        GL.glUniform3f((int)location, (float)x, (float)y, (float)z);
    }

    public void glUniform3fv(int location, int count, FloatBuffer v) {
        GL.glUniform3fv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform3fv(int location, int count, float[] v, int offset) {
        this.glUniform3fv(location, count, this.toFloatBuffer(v, offset, count * 3));
    }

    public void glUniform3i(int location, int x, int y, int z) {
        GL.glUniform3i((int)location, (int)x, (int)y, (int)z);
    }

    public void glUniform3iv(int location, int count, IntBuffer v) {
        GL.glUniform3iv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform3iv(int location, int count, int[] v, int offset) {
        this.glUniform3iv(location, count, this.toIntBuffer(v, offset, count * 3));
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        GL.glUniform4f((int)location, (float)x, (float)y, (float)z, (float)w);
    }

    public void glUniform4fv(int location, int count, FloatBuffer v) {
        GL.glUniform4fv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform4fv(int location, int count, float[] v, int offset) {
        this.glUniform4fv(location, count, this.toFloatBuffer(v, offset, count << 2));
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        GL.glUniform4i((int)location, (int)x, (int)y, (int)z, (int)w);
    }

    public void glUniform4iv(int location, int count, IntBuffer v) {
        GL.glUniform4iv((int)location, (int)count, (Buffer)v, (int)Memory.getPosition((Buffer)v));
    }

    public void glUniform4iv(int location, int count, int[] v, int offset) {
        this.glUniform4iv(location, count, this.toIntBuffer(v, offset, count << 2));
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL.glUniformMatrix2fv((int)location, (int)count, (boolean)transpose, (Buffer)value, (int)Memory.getPosition((Buffer)value));
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, float[] value, int offset) {
        this.glUniformMatrix2fv(location, count, transpose, this.toFloatBuffer(value, offset, count << 2));
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL.glUniformMatrix3fv((int)location, (int)count, (boolean)transpose, (Buffer)value, (int)Memory.getPosition((Buffer)value));
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, float[] value, int offset) {
        this.glUniformMatrix3fv(location, count, transpose, this.toFloatBuffer(value, offset, count * 9));
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        GL.glUniformMatrix4fv((int)location, (int)count, (boolean)transpose, (Buffer)value, (int)Memory.getPosition((Buffer)value));
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, float[] value, int offset) {
        this.glUniformMatrix4fv(location, count, transpose, this.toFloatBuffer(value, offset, count << 4));
    }

    public void glUseProgram(int program) {
        GL.glUseProgram((int)program);
    }

    public void glValidateProgram(int program) {
        GL.glValidateProgram((int)program);
    }

    public void glVertexAttrib1f(int indx, float x) {
        GL.glVertexAttrib1f((int)indx, (float)x);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        GL.glVertexAttrib1fv((int)indx, (Buffer)values, (int)Memory.getPosition((Buffer)values));
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        GL.glVertexAttrib2f((int)indx, (float)x, (float)y);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        GL.glVertexAttrib2fv((int)indx, (Buffer)values, (int)Memory.getPosition((Buffer)values));
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        GL.glVertexAttrib3f((int)indx, (float)x, (float)y, (float)z);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        GL.glVertexAttrib3fv((int)indx, (Buffer)values, (int)Memory.getPosition((Buffer)values));
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        GL.glVertexAttrib4f((int)indx, (float)x, (float)y, (float)z, (float)w);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        GL.glVertexAttrib4fv((int)indx, (Buffer)values, (int)Memory.getPosition((Buffer)values));
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer ptr) {
        GL.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (Buffer)ptr, (int)Memory.getPosition((Buffer)ptr));
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        GL.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (long)ptr);
    }
}

