/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.jglfw;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.jglfw.JglfwApplicationConfiguration;
import com.badlogic.gdx.backends.jglfw.JglfwClipboard;
import com.badlogic.gdx.backends.jglfw.JglfwFiles;
import com.badlogic.gdx.backends.jglfw.JglfwGraphics;
import com.badlogic.gdx.backends.jglfw.JglfwInput;
import com.badlogic.gdx.backends.jglfw.JglfwNet;
import com.badlogic.gdx.backends.jglfw.JglfwPreferences;
import com.badlogic.gdx.backends.jglfw.Sync;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.badlogic.jglfw.Glfw;
import com.badlogic.jglfw.GlfwCallback;
import com.badlogic.jglfw.GlfwCallbackAdapter;
import com.badlogic.jglfw.GlfwCallbacks;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;

public class JglfwApplication
implements Application {
    JglfwGraphics graphics;
    JglfwFiles files;
    JglfwInput input;
    JglfwNet net;
    final ApplicationListener listener;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    private final Array<LifecycleListener> lifecycleListeners = new Array();
    private final Map<String, Preferences> preferences = new HashMap<String, Preferences>();
    private final JglfwClipboard clipboard = new JglfwClipboard();
    private final GlfwCallbacks callbacks = new GlfwCallbacks();
    private int logLevel = 2;
    volatile boolean running = true;
    boolean isPaused;
    protected String preferencesdir;
    private boolean forceExit;
    private boolean runOnEDT;
    private int foregroundFPS;
    private int backgroundFPS;
    private int hiddenFPS;

    public JglfwApplication(ApplicationListener listener) {
        this(listener, listener.getClass().getSimpleName(), 640, 480);
    }

    public JglfwApplication(ApplicationListener listener, String title, int width, int height) {
        this(listener, JglfwApplication.createConfig(title, width, height));
    }

    private static JglfwApplicationConfiguration createConfig(String title, int width, int height) {
        JglfwApplicationConfiguration config = new JglfwApplicationConfiguration();
        config.title = title;
        config.width = width;
        config.height = height;
        return config;
    }

    public JglfwApplication(ApplicationListener listener, final JglfwApplicationConfiguration config) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        this.listener = listener;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    JglfwApplication.this.initialize(config);
                }
                catch (Throwable ex) {
                    JglfwApplication.this.exception(ex);
                }
            }
        };
        if (config.runOnEDT) {
            EventQueue.invokeLater(runnable);
        } else {
            new Thread(runnable, "MainLoop").start();
        }
    }

    protected void exception(Throwable ex) {
        ex.printStackTrace();
        System.exit(0);
    }

    void initialize(JglfwApplicationConfiguration config) {
        this.forceExit = config.forceExit;
        this.runOnEDT = config.runOnEDT;
        this.foregroundFPS = config.foregroundFPS;
        this.backgroundFPS = config.backgroundFPS;
        this.hiddenFPS = config.hiddenFPS;
        this.preferencesdir = config.preferencesLocation;
        final Thread glThread = Thread.currentThread();
        GdxNativesLoader.load();
        boolean inputCallbacksOnAppKitThread = SharedLibraryLoader.isMac;
        if (inputCallbacksOnAppKitThread) {
            Toolkit.getDefaultToolkit();
        }
        if (!Glfw.glfwInit()) {
            throw new GdxRuntimeException("Unable to initialize GLFW.");
        }
        Gdx.app = this;
        this.graphics = new JglfwGraphics(config);
        Gdx.graphics = this.graphics;
        this.files = new JglfwFiles();
        Gdx.files = this.files;
        this.input = new JglfwInput(this, inputCallbacksOnAppKitThread);
        Gdx.input = this.input;
        this.net = new JglfwNet();
        Gdx.net = this.net;
        this.callbacks.add((GlfwCallback)new GlfwCallbackAdapter(){

            public void windowSize(long window, final int width, final int height) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JglfwApplication.this.graphics.sizeChanged(width, height);
                    }
                };
                if (Thread.currentThread() != glThread) {
                    JglfwApplication.this.postRunnable(runnable);
                } else {
                    runnable.run();
                }
            }

            public void windowPos(long window, final int x, final int y) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JglfwApplication.this.graphics.positionChanged(x, y);
                    }
                };
                if (Thread.currentThread() != glThread) {
                    JglfwApplication.this.postRunnable(runnable);
                } else {
                    runnable.run();
                }
            }

            public void windowRefresh(long window) {
                if (Thread.currentThread() == glThread) {
                    JglfwApplication.this.render(System.nanoTime());
                }
            }

            public void windowFocus(long window, boolean focused) {
                JglfwApplication.this.graphics.foreground = focused;
            }

            public void windowIconify(long window, boolean iconified) {
                JglfwApplication.this.graphics.minimized = iconified;
            }

            public boolean windowClose(long window) {
                if (JglfwApplication.this.shouldExit()) {
                    JglfwApplication.this.exit();
                }
                return false;
            }

            public void error(int error, String description) {
                throw new GdxRuntimeException("GLFW error " + error + ": " + description);
            }
        });
        Glfw.glfwSetCallback((GlfwCallback)this.callbacks);
        this.start();
    }

    protected void start() {
        this.listener.create();
        this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
        if (this.runOnEDT) {
            new Runnable(){

                @Override
                public void run() {
                    JglfwApplication.this.frame();
                    if (JglfwApplication.this.running) {
                        EventQueue.invokeLater(this);
                    } else {
                        JglfwApplication.this.end();
                    }
                }
            }.run();
        } else {
            while (this.running) {
                this.frame();
            }
            this.end();
        }
    }

    protected void frame() {
        int targetFPS;
        if (!this.running) {
            return;
        }
        boolean shouldRender = false;
        if (this.executeRunnables()) {
            shouldRender = true;
        }
        if (!this.running) {
            return;
        }
        this.input.update();
        shouldRender |= this.graphics.shouldRender();
        long frameStartTime = System.nanoTime();
        int n = this.graphics.isHidden() || this.graphics.isMinimized() ? this.hiddenFPS : (targetFPS = this.graphics.isForeground() ? this.foregroundFPS : this.backgroundFPS);
        if (targetFPS == -1) {
            if (!this.isPaused) {
                this.listener.pause();
            }
            this.isPaused = true;
        } else {
            if (this.isPaused) {
                this.listener.resume();
            }
            this.isPaused = false;
            if (shouldRender) {
                this.render(frameStartTime);
            } else {
                targetFPS = this.backgroundFPS;
            }
        }
        if (targetFPS != 0) {
            if (targetFPS == -1) {
                this.sleep(100);
            } else {
                Sync.sync(targetFPS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRunnables() {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            for (int i = this.runnables.size - 1; i >= 0; --i) {
                this.executedRunnables.addAll((Object[])new Runnable[]{(Runnable)this.runnables.get(i)});
            }
            this.runnables.clear();
        }
        if (this.executedRunnables.size == 0) {
            return false;
        }
        for (int i = this.executedRunnables.size - 1; i >= 0; --i) {
            ((Runnable)this.executedRunnables.removeIndex(i)).run();
        }
        return true;
    }

    void sleep(int millis) {
        try {
            if (millis > 0) {
                Thread.sleep(millis);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void render(long time) {
        this.graphics.frameStart(time);
        this.listener.render();
        Glfw.glfwSwapBuffers((long)this.graphics.window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end() {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : this.lifecycleListeners) {
                listener.pause();
                listener.dispose();
            }
        }
        this.listener.pause();
        this.listener.dispose();
        Glfw.glfwTerminate();
        if (this.forceExit) {
            System.exit(-1);
        }
    }

    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public JglfwGraphics getGraphics() {
        return this.graphics;
    }

    public Audio getAudio() {
        return null;
    }

    public JglfwInput getInput() {
        return this.input;
    }

    public JglfwFiles getFiles() {
        return this.files;
    }

    public JglfwNet getNet() {
        return this.net;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    public int getVersion() {
        return 0;
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey(name)) {
            return this.preferences.get(name);
        }
        JglfwPreferences prefs = new JglfwPreferences(name, this.preferencesdir);
        this.preferences.put(name, prefs);
        return prefs;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
            this.graphics.requestRendering();
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void setForegroundFPS(int foregroundFPS) {
        this.foregroundFPS = foregroundFPS;
    }

    public void setBackgroundFPS(int backgroundFPS) {
        this.backgroundFPS = backgroundFPS;
    }

    public void setHiddenFPS(int hiddenFPS) {
        this.hiddenFPS = hiddenFPS;
    }

    protected boolean shouldExit() {
        return true;
    }

    public void exit() {
        this.running = false;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
            exception.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public GlfwCallbacks getCallbacks() {
        return this.callbacks;
    }
}

