/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RowQueryCriteria {
    private String tableName;
    private String viewName;
    private List<String> columnNames = new LinkedList<String>();

    public RowQueryCriteria(String tableName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableName);
        this.tableName = tableName;
    }

    public RowQueryCriteria(String tableName, String viewName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        if (viewName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableName);
        OTSUtil.ensureNameValid(viewName);
        this.tableName = tableName;
        this.viewName = viewName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        if (tableName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(tableName);
        this.tableName = tableName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        if (viewName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(viewName);
        this.viewName = viewName;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public void addColumnName(String columnName) {
        if (columnName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(columnName);
        this.columnNames.add(columnName);
    }

    public void addColumnNames(String[] columnNames) {
        int i;
        if (columnNames == null) {
            throw new NullPointerException();
        }
        for (i = 0; i < columnNames.length; ++i) {
            OTSUtil.ensureNameValid(columnNames[i]);
        }
        for (i = 0; i < columnNames.length; ++i) {
            this.columnNames.add(columnNames[i]);
        }
    }
}

