/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.PrimaryKeyRange;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.model.RowQueryCriteria;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class RangeRowQueryCriteria
extends RowQueryCriteria {
    private int top = -1;
    private PrimaryKeyRange range;
    private boolean isReverse;
    private Map<String, PrimaryKeyValue> primaryKeys = new LinkedHashMap<String, PrimaryKeyValue>();

    public RangeRowQueryCriteria(String tableName) {
        super(tableName);
    }

    public RangeRowQueryCriteria(String tableName, String viewName) {
        super(tableName, viewName);
    }

    public Map<String, PrimaryKeyValue> getPrimaryKeys() {
        return Collections.unmodifiableMap(this.primaryKeys);
    }

    public void addPrimaryKey(String name, PrimaryKeyValue value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(name)) {
            throw new IllegalArgumentException();
        }
        if (OTSUtil.isPKInf(value)) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("InfPKNotAllowed"));
        }
        this.primaryKeys.put(name, value);
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public boolean getIsReverse() {
        return this.isReverse;
    }

    public void setIsReverse(boolean isReverse) {
        this.isReverse = isReverse;
    }

    public PrimaryKeyRange getRange() {
        return this.range;
    }

    public void setRange(String primaryKeyName, PrimaryKeyValue begin, PrimaryKeyValue end) {
        this.setRange(new PrimaryKeyRange(primaryKeyName, begin, end));
    }

    public void setRange(PrimaryKeyRange range) {
        if (range == null) {
            throw new NullPointerException();
        }
        this.range = range;
    }
}

