/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.RequestSigner;
import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.auth.ServiceSignature;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.utils.DateUtil;
import com.aliyun.common.utils.HttpUtil;
import com.aliyun.openservices.ClientException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

public class OTSRequestSigner
implements RequestSigner {
    private String otsAction;
    private ServiceCredentials credentials;

    public OTSRequestSigner(String otsAction, ServiceCredentials credentials) {
        assert (otsAction != null && credentials != null);
        this.otsAction = otsAction;
        this.credentials = credentials;
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        OTSRequestSigner.addRequiredParameters(this.otsAction, request.getParameters(), this.credentials);
        try {
            OTSRequestSigner.addSignature(this.otsAction, request.getParameters(), this.credentials);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("\u65e0\u6cd5\u8ba1\u7b97\u7b7e\u540d\uff1a" + e.getMessage());
        }
    }

    private static void addRequiredParameters(String action, Map<String, String> parameters, ServiceCredentials credentials) {
        ServiceSignature signer = ServiceSignature.create();
        parameters.put("Date", DateUtil.formatRfc822Date(new Date()));
        parameters.put("OTSAccessKeyId", credentials.getAccessKeyId());
        parameters.put("APIVersion", "1");
        parameters.put("SignatureMethod", signer.getAlgorithm());
        parameters.put("SignatureVersion", signer.getVersion());
    }

    private static void addSignature(String otsAction, Map<String, String> parameters, ServiceCredentials credentials) throws UnsupportedEncodingException {
        parameters.put("Signature", OTSRequestSigner.getSignature(otsAction, parameters, credentials));
    }

    private static String getSignature(String action, Map<String, String> parameters, ServiceCredentials credentials) throws UnsupportedEncodingException {
        String data = String.format("/%s\n%s", action, HttpUtil.paramToQueryString(OTSRequestSigner.sortMap(parameters), "utf-8"));
        return ServiceSignature.create().computeSignature(credentials.getAccessKeySecret(), data);
    }

    private static Map<String, String> sortMap(Map<String, String> unsortMap) {
        TreeSet<String> sortedKeys = new TreeSet<String>(unsortMap.keySet());
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        for (String key : sortedKeys) {
            sortedMap.put(key, unsortMap.get(key));
        }
        return sortedMap;
    }
}

