/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ResponseHandler;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.common.utils.DateUtil;
import com.aliyun.common.utils.IOUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ServiceException;
import com.aliyun.openservices.oss.OSSException;
import com.aliyun.openservices.oss.internal.OSSExceptionFactory;
import com.aliyun.openservices.oss.internal.OSSOperation;
import com.aliyun.openservices.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.internal.ResponseParser;
import com.aliyun.openservices.oss.model.CopyObjectRequest;
import com.aliyun.openservices.oss.model.CopyObjectResult;
import com.aliyun.openservices.oss.model.GetObjectRequest;
import com.aliyun.openservices.oss.model.OSSObject;
import com.aliyun.openservices.oss.model.ObjectMetadata;
import com.aliyun.openservices.oss.model.PutObjectResult;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSSObjectOperation
extends OSSOperation {
    public OSSObjectOperation(URI endpoint, ServiceClient client, ServiceCredentials cred) {
        super(endpoint, client, cred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertParameterNotNull(input, "input");
        CodingUtils.assertParameterNotNull(metadata, "metadata");
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.populateRequestMetadata(headers, metadata);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setHeaders(headers).setInputStream(input).setInputSize(metadata.getContentLength()).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key);
        ResponseMessage response = this.send(request, context, true);
        PutObjectResult result = new PutObjectResult();
        try {
            result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
        }
        finally {
            OSSUtils.safeCloseResponse(response);
        }
        return result;
    }

    public OSSObject getObject(String bucketName, String key) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    public OSSObject getObject(GetObjectRequest getObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getObjectRequest, "getObjectRequest");
        if (getObjectRequest.getBucketName() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetBucketName"));
        }
        String bucketName = getObjectRequest.getBucketName();
        String key = getObjectRequest.getKey();
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (getObjectRequest.getRange() != null) {
            long[] range = getObjectRequest.getRange();
            headers.put("Range", "bytes=" + Long.toString(range[0]) + "-" + Long.toString(range[1]));
        }
        if (getObjectRequest.getModifiedSinceConstraint() != null) {
            headers.put("If-Modified-Since", DateUtil.formatRfc822Date(getObjectRequest.getModifiedSinceConstraint()));
        }
        if (getObjectRequest.getUnmodifiedSinceConstraint() != null) {
            headers.put("If-Unmodified-Since", DateUtil.formatRfc822Date(getObjectRequest.getUnmodifiedSinceConstraint()));
        }
        if (getObjectRequest.getMatchingETagConstraints().size() > 0) {
            headers.put("If-Match", OSSObjectOperation.joinETags(getObjectRequest.getMatchingETagConstraints()));
        }
        if (getObjectRequest.getNonmatchingETagConstraints().size() > 0) {
            headers.put("If-None-Match", OSSObjectOperation.joinETags(getObjectRequest.getNonmatchingETagConstraints()));
        }
        Map<String, String> params = OSSUtils.getResponseHeaderParameters(getObjectRequest.getResponseHeaders());
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key);
        ResponseMessage response = this.send(request, context, true);
        OSSObject ossObject = new OSSObject();
        ossObject.setObjectContent(response.getContent());
        ossObject.setKey(key);
        try {
            ossObject.setObjectMetadata(ResponseParser.getObjectMetadata(response.getHeaders()));
        }
        catch (ClientException e) {
            OSSUtils.safeCloseResponse(response);
            throw e;
        }
        return ossObject;
    }

    private static String joinETags(List<String> etags) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String etag : etags) {
            if (!first) {
                result.append(", ");
            }
            result.append(etag);
            first = false;
        }
        return result.toString();
    }

    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(file, "file");
        OSSObject ossObject = this.getObject(getObjectRequest);
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            int bufSize = 4096;
            byte[] buffer = new byte[bufSize];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) > -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                throw new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), e);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(outputStream);
                IOUtils.safeClose(ossObject.getObjectContent());
                throw throwable;
            }
        }
        IOUtils.safeClose(outputStream);
        IOUtils.safeClose(ossObject.getObjectContent());
        return ossObject.getObjectMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key);
        context.insertResponseHandler(0, new ResponseHandler(){

            @Override
            public void handle(ResponseMessage responseData) throws ServiceException, ClientException {
                if (responseData.getStatusCode() == 404) {
                    OSSUtils.safeCloseResponse(responseData);
                    throw OSSExceptionFactory.create(responseData.getHeaders().get("x-oss-request-id"), "NoSuchKey", OSSUtils.OSS_RESOURCE_MANAGER.getString("NoSuchKey"));
                }
            }
        });
        ResponseMessage response = this.send(request, context, true);
        try {
            ObjectMetadata result;
            ObjectMetadata objectMetadata = result = ResponseParser.getObjectMetadata(response.getHeaders());
            return objectMetadata;
        }
        finally {
            OSSUtils.safeCloseResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(copyObjectRequest, "copyObjectRequest");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.populateCopyObjectHeaders(copyObjectRequest, headers);
        headers.remove("Content-Length");
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(copyObjectRequest.getDestinationBucketName()).setKey(copyObjectRequest.getDestinationKey()).setHeaders(headers).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), copyObjectRequest.getDestinationBucketName(), copyObjectRequest.getDestinationKey());
        ResponseMessage response = this.send(request, context, true);
        try {
            CopyObjectResult copyObjectResult = ResponseParser.parseCopyObjectResult(response.getContent());
            return copyObjectResult;
        }
        finally {
            OSSUtils.safeCloseResponse(response);
        }
    }

    private void populateCopyObjectHeaders(CopyObjectRequest copyObjectRequest, Map<String, String> headers) {
        String sourceHeader = "/" + copyObjectRequest.getSourceBucketName() + "/" + copyObjectRequest.getSourceKey();
        headers.put("x-oss-copy-source", sourceHeader);
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addListHeader(headers, "x-oss-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        OSSUtils.addListHeader(headers, "x-oss-copy-source-if-none-match", copyObjectRequest.getNonmatchingEtagConstraints());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            headers.put("x-oss-metadata-directive", "REPLACE");
            OSSUtils.populateRequestMetadata(headers, newObjectMetadata);
        }
    }

    public void deleteObject(String bucketName, String key) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key);
        this.send(request, context);
    }
}

