/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.oss.OSSException;
import com.aliyun.openservices.oss.internal.OSSOperation;
import com.aliyun.openservices.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.internal.ResponseParser;
import com.aliyun.openservices.oss.model.AccessControlList;
import com.aliyun.openservices.oss.model.Bucket;
import com.aliyun.openservices.oss.model.CannedAccessControlList;
import com.aliyun.openservices.oss.model.ListObjectsRequest;
import com.aliyun.openservices.oss.model.ObjectListing;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class OSSBucketOperation
extends OSSOperation {
    private static final String SUBRESOURCE_ACL = "acl";

    public OSSBucketOperation(URI endpoint, ServiceClient client, ServiceCredentials cred) {
        super(endpoint, client, cred);
    }

    public Bucket createBucket(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
        return new Bucket(bucketName);
    }

    public void deleteBucket(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bucket> listBuckets() throws OSSException, ClientException {
        List<Bucket> list;
        block3: {
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod());
                response = this.send(request, context, true);
                list = ResponseParser.parseListBucket(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return list;
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        if (acl == null) {
            acl = CannedAccessControlList.Private;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-oss-acl", acl.toString());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_ACL, null);
        RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getBucketAcl(String bucketName) throws OSSException, ClientException {
        AccessControlList accessControlList;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_ACL, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                accessControlList = ResponseParser.parseGetBucketAcl(response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return accessControlList;
    }

    public boolean bucketExists(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        List<Bucket> buckets = this.listBuckets();
        for (Bucket bucket : buckets) {
            if (!bucketName.equals(bucket.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectListing listObjects(ListObjectsRequest listObjectRequest) throws OSSException, ClientException {
        ObjectListing objectListing;
        block8: {
            CodingUtils.assertParameterNotNull(listObjectRequest, "request");
            if (listObjectRequest.getBucketName() == null) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetBucketName"));
            }
            OSSUtils.ensureBucketNameValid(listObjectRequest.getBucketName());
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            if (listObjectRequest.getPrefix() != null) {
                params.put("prefix", listObjectRequest.getPrefix());
            }
            if (listObjectRequest.getMarker() != null) {
                params.put("marker", listObjectRequest.getMarker());
            }
            if (listObjectRequest.getDelimiter() != null) {
                params.put("delimiter", listObjectRequest.getDelimiter());
            }
            if (listObjectRequest.getMaxKeys() != null) {
                params.put("max-keys", Integer.toString(listObjectRequest.getMaxKeys()));
            }
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder().setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(listObjectRequest.getBucketName()).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), listObjectRequest.getBucketName());
                response = this.send(request, context, true);
                objectListing = ResponseParser.parseListObjects(response.getContent());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return objectListing;
    }
}

