/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.Job;
import com.aliyun.openservices.log.common.JobSchedule;
import com.aliyun.openservices.log.common.JobState;
import com.aliyun.openservices.log.common.JobType;
import com.aliyun.openservices.log.common.ReportConfiguration;
import com.aliyun.openservices.log.util.JsonUtils;
import com.aliyun.openservices.log.util.Utils;
import java.io.Serializable;
import java.util.Date;
import net.sf.json.JSONObject;

public class Report
implements Serializable {
    private static final long serialVersionUID = 9211926785430833230L;
    private String name;
    private String displayName;
    private String description;
    private JobState state;
    private ReportConfiguration configuration;
    private JobSchedule schedule;
    private Date createTime;
    private Date lastModifiedTime;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReportConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ReportConfiguration configuration) {
        this.configuration = configuration;
    }

    public JobSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(JobSchedule schedule) {
        this.schedule = schedule;
    }

    public JobState getState() {
        return this.state;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public void deserialize(JSONObject value) {
        this.name = value.getString("name");
        this.displayName = JsonUtils.readOptionalString(value, "displayName");
        this.description = JsonUtils.readOptionalString(value, "description");
        this.state = JobState.fromString(value.getString("state"));
        this.configuration = new ReportConfiguration();
        this.configuration.deserialize(value.getJSONObject("configuration"));
        this.createTime = Utils.timestampToDate(value.getLong("createTime"));
        this.lastModifiedTime = Utils.timestampToDate(value.getLong("lastModifiedTime"));
        this.schedule = new JobSchedule();
        this.schedule.deserialize(value.getJSONObject("schedule"));
    }

    public Job makeJob() {
        Job job = new Job();
        job.setType(JobType.REPORT);
        job.setName(this.getName());
        job.setDisplayName(this.getDisplayName());
        job.setDescription(this.getDescription());
        job.setState(this.getState());
        job.setSchedule(this.getSchedule());
        job.setConfiguration(this.getConfiguration());
        return job;
    }
}

