/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.spring.boot.context.event;

import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.qos.server.DubboLogo;
import com.alibaba.dubbo.spring.boot.bean.DubboSpringBootStarterConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=-2147483628)
public class DubboBannerApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Log logger = LogFactory.getLog(DubboBannerApplicationListener.class);
    private static Banner.Mode BANNER_MODE = Banner.Mode.CONSOLE;

    public static void setBANNER_MODE(Banner.Mode bANNER_MODE) {
        BANNER_MODE = bANNER_MODE;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (BANNER_MODE == Banner.Mode.OFF) {
            return;
        }
        String bannerText = this.buildBannerText();
        if (BANNER_MODE == Banner.Mode.CONSOLE) {
            System.out.print(bannerText);
        } else if (BANNER_MODE == Banner.Mode.LOG) {
            logger.info((Object)bannerText);
        }
    }

    private String buildBannerText() {
        StringBuilder bannerTextBuilder = new StringBuilder();
        bannerTextBuilder.append(DubboSpringBootStarterConstants.LINE_SEPARATOR).append(DubboLogo.dubbo).append(" :: Dubbo ::        (v").append(Version.getVersion()).append(")").append(DubboSpringBootStarterConstants.LINE_SEPARATOR);
        return bannerTextBuilder.toString();
    }
}

