/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.net.HttpCookie;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.util.CharsetUtil;
import org.webbitserver.HttpRequest;
import org.webbitserver.helpers.InboundCookieParser;
import org.webbitserver.helpers.QueryParameters;

public class NettyHttpRequest
implements HttpRequest {
    private final org.jboss.netty.handler.codec.http.HttpRequest httpRequest;
    private final MessageEvent messageEvent;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final Object id;
    private final long timestamp;
    public QueryParameters queryParameters;
    public QueryParameters postParameters;

    public NettyHttpRequest(MessageEvent messageEvent, org.jboss.netty.handler.codec.http.HttpRequest httpRequest, Object id, long timestamp) {
        this.messageEvent = messageEvent;
        this.httpRequest = httpRequest;
        this.id = id;
        this.timestamp = timestamp;
    }

    @Override
    public String uri() {
        return this.httpRequest.getUri();
    }

    @Override
    public NettyHttpRequest uri(String uri) {
        this.httpRequest.setUri(uri);
        return this;
    }

    @Override
    public String header(String name) {
        return this.httpRequest.getHeader(name);
    }

    @Override
    public List<String> headers(String name) {
        return this.httpRequest.getHeaders(name);
    }

    @Override
    public boolean hasHeader(String name) {
        return this.httpRequest.containsHeader(name);
    }

    @Override
    public List<HttpCookie> cookies() {
        return InboundCookieParser.parse(this.headers("Cookie"));
    }

    @Override
    public HttpCookie cookie(String name) {
        for (HttpCookie cookie : this.cookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public String queryParam(String key) {
        return this.parsedQueryParams().first(key);
    }

    @Override
    public List<String> queryParams(String key) {
        return this.parsedQueryParams().all(key);
    }

    @Override
    public Set<String> queryParamKeys() {
        return this.parsedQueryParams().keys();
    }

    @Override
    public String postParam(String key) {
        return this.parsedPostParams().first(key);
    }

    @Override
    public List<String> postParams(String key) {
        return this.parsedPostParams().all(key);
    }

    @Override
    public Set<String> postParamKeys() {
        return this.parsedPostParams().keys();
    }

    private QueryParameters parsedQueryParams() {
        if (this.queryParameters == null) {
            this.queryParameters = new QueryParameters(URI.create(this.uri()).getQuery());
        }
        return this.queryParameters;
    }

    private QueryParameters parsedPostParams() {
        if (this.postParameters == null) {
            this.postParameters = new QueryParameters(this.body());
        }
        return this.postParameters;
    }

    @Override
    public String cookieValue(String name) {
        HttpCookie cookie = this.cookie(name);
        return cookie == null ? null : cookie.getValue();
    }

    @Override
    public List<Map.Entry<String, String>> allHeaders() {
        return this.httpRequest.getHeaders();
    }

    @Override
    public String method() {
        return this.httpRequest.getMethod().getName();
    }

    @Override
    public String body() {
        return this.httpRequest.getContent().toString(CharsetUtil.UTF_8);
    }

    @Override
    public byte[] bodyAsBytes() {
        return this.httpRequest.getContent().array();
    }

    @Override
    public Map<String, Object> data() {
        return this.data;
    }

    @Override
    public Object data(String key) {
        return this.data.get(key);
    }

    @Override
    public NettyHttpRequest data(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    @Override
    public Set<String> dataKeys() {
        return this.data.keySet();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.messageEvent.getRemoteAddress();
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.messageEvent.getRemoteAddress() + " " + this.httpRequest.getMethod() + " " + this.httpRequest.getUri();
    }
}

