/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextCache<KEY extends Serializable, CONTEXT extends ApplicationContext> {
    private final Map<KEY, CONTEXT> contextKeyToContextMap = Collections.synchronizedMap(new HashMap());
    private int hitCount;
    private int missCount;

    ContextCache() {
    }

    void clear() {
        this.contextKeyToContextMap.clear();
    }

    void clearStatistics() {
        this.hitCount = 0;
        this.missCount = 0;
    }

    final boolean contains(KEY key) {
        Assert.notNull(key, (String)"Key must not be null.");
        return this.contextKeyToContextMap.containsKey(key);
    }

    final CONTEXT get(KEY key) throws Exception {
        Assert.notNull(key, (String)"Key must not be null.");
        ApplicationContext context = (ApplicationContext)this.contextKeyToContextMap.get(key);
        if (context == null) {
            this.incrementMissCount();
        } else {
            this.incrementHitCount();
        }
        return (CONTEXT)context;
    }

    protected final void incrementHitCount() {
        ++this.hitCount;
    }

    protected final void incrementMissCount() {
        ++this.missCount;
    }

    final int getHitCount() {
        return this.hitCount;
    }

    final int getMissCount() {
        return this.missCount;
    }

    final void put(KEY key, CONTEXT context) {
        Assert.notNull(key, (String)"Key must not be null.");
        Assert.notNull(context, (String)"ConfigurableApplicationContext must not be null.");
        this.contextKeyToContextMap.put(key, context);
    }

    final CONTEXT remove(KEY key) {
        return (CONTEXT)((ApplicationContext)this.contextKeyToContextMap.remove(key));
    }

    final void setDirty(KEY key) {
        Assert.notNull(key, (String)"Key must not be null.");
        CONTEXT context = this.remove(key);
        if (context instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).close();
        }
    }

    int size() {
        return this.contextKeyToContextMap.size();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("size", this.size()).append("hitCount", this.getHitCount()).append("missCount", this.getMissCount()).toString();
    }
}

